/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.internal.SqlApiConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.ModuleSerializationProxy;

@Stable
public final class DecimalType$
extends AbstractDataType
implements Serializable {
    public static final DecimalType$ MODULE$ = new DecimalType$();
    private static final int MAX_PRECISION = 38;
    private static final int MAX_SCALE = 38;
    private static final int DEFAULT_SCALE = 18;
    private static final DecimalType SYSTEM_DEFAULT = new DecimalType(MODULE$.MAX_PRECISION(), MODULE$.DEFAULT_SCALE());
    private static final DecimalType USER_DEFAULT = new DecimalType(10, 0);
    private static final int MINIMUM_ADJUSTED_SCALE = 6;
    private static final DecimalType BooleanDecimal = new DecimalType(1, 0);
    private static final DecimalType ByteDecimal = new DecimalType(3, 0);
    private static final DecimalType ShortDecimal = new DecimalType(5, 0);
    private static final DecimalType IntDecimal = new DecimalType(10, 0);
    private static final DecimalType LongDecimal = new DecimalType(20, 0);
    private static final DecimalType FloatDecimal = new DecimalType(14, 7);
    private static final DecimalType DoubleDecimal = new DecimalType(30, 15);
    private static final DecimalType BigIntDecimal = new DecimalType(38, 0);

    public int MAX_PRECISION() {
        return MAX_PRECISION;
    }

    public int MAX_SCALE() {
        return MAX_SCALE;
    }

    public int DEFAULT_SCALE() {
        return DEFAULT_SCALE;
    }

    public DecimalType SYSTEM_DEFAULT() {
        return SYSTEM_DEFAULT;
    }

    public DecimalType USER_DEFAULT() {
        return USER_DEFAULT;
    }

    public int MINIMUM_ADJUSTED_SCALE() {
        return MINIMUM_ADJUSTED_SCALE;
    }

    public DecimalType BooleanDecimal() {
        return BooleanDecimal;
    }

    public DecimalType ByteDecimal() {
        return ByteDecimal;
    }

    public DecimalType ShortDecimal() {
        return ShortDecimal;
    }

    public DecimalType IntDecimal() {
        return IntDecimal;
    }

    public DecimalType LongDecimal() {
        return LongDecimal;
    }

    public DecimalType FloatDecimal() {
        return FloatDecimal;
    }

    public DecimalType DoubleDecimal() {
        return DoubleDecimal;
    }

    public DecimalType BigIntDecimal() {
        return BigIntDecimal;
    }

    public DecimalType forType(DataType dataType) {
        DecimalType decimalType;
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2)) {
            decimalType = this.ByteDecimal();
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            decimalType = this.ShortDecimal();
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            decimalType = this.IntDecimal();
        } else if (LongType$.MODULE$.equals(dataType2)) {
            decimalType = this.LongDecimal();
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            decimalType = this.FloatDecimal();
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            decimalType = this.DoubleDecimal();
        } else {
            throw new MatchError((Object)dataType2);
        }
        return decimalType;
    }

    public DecimalType fromDecimal(Decimal d) {
        return new DecimalType(d.precision(), d.scale());
    }

    public DecimalType bounded(int precision, int scale) {
        return new DecimalType(package$.MODULE$.min(precision, this.MAX_PRECISION()), package$.MODULE$.min(scale, this.MAX_SCALE()));
    }

    public void checkNegativeScale(int scale) {
        if (scale < 0 && !SqlApiConf$.MODULE$.get().allowNegativeScaleOfDecimalEnabled()) {
            throw DataTypeErrors$.MODULE$.negativeScaleNotAllowedError(scale);
        }
    }

    public DecimalType adjustPrecisionScale(int precision, int scale) {
        DecimalType decimalType;
        this.checkNegativeScale(scale);
        Predef$.MODULE$.assert(precision >= scale);
        if (precision <= this.MAX_PRECISION()) {
            decimalType = new DecimalType(precision, scale);
        } else if (scale < 0) {
            decimalType = new DecimalType(this.MAX_PRECISION(), scale);
        } else {
            int intDigits = precision - scale;
            int minScaleValue = Math.min(scale, this.MINIMUM_ADJUSTED_SCALE());
            int adjustedScale = Math.max(this.MAX_PRECISION() - intDigits, minScaleValue);
            decimalType = new DecimalType(this.MAX_PRECISION(), adjustedScale);
        }
        return decimalType;
    }

    @Override
    public DataType defaultConcreteType() {
        return this.SYSTEM_DEFAULT();
    }

    @Override
    public boolean acceptsType(DataType other) {
        return other instanceof DecimalType;
    }

    @Override
    public String simpleString() {
        return "decimal";
    }

    public boolean is32BitDecimalType(DataType dt) {
        DecimalType decimalType;
        DataType dataType = dt;
        boolean bl = dataType instanceof DecimalType ? (decimalType = (DecimalType)dataType).precision() <= Decimal$.MODULE$.MAX_INT_DIGITS() : false;
        return bl;
    }

    public boolean is64BitDecimalType(DataType dt) {
        DecimalType decimalType;
        DataType dataType = dt;
        boolean bl = dataType instanceof DecimalType ? (decimalType = (DecimalType)dataType).precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS() : false;
        return bl;
    }

    public boolean isByteArrayDecimalType(DataType dt) {
        DecimalType decimalType;
        DataType dataType = dt;
        boolean bl = dataType instanceof DecimalType ? (decimalType = (DecimalType)dataType).precision() > Decimal$.MODULE$.MAX_LONG_DIGITS() : false;
        return bl;
    }

    public boolean unapply(DataType t) {
        return t instanceof DecimalType;
    }

    public DecimalType apply(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public Option<Tuple2<Object, Object>> unapply(DecimalType x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2.mcII.sp(x$0.precision(), x$0.scale()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DecimalType$.class);
    }

    private DecimalType$() {
    }
}

