/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010.consumer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager$;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaTokenUtil$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.consumer.FetchedData;
import org.apache.spark.sql.kafka010.consumer.FetchedDataPool;
import org.apache.spark.sql.kafka010.consumer.FetchedRecord;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumer;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumerPool;
import org.apache.spark.sql.kafka010.consumer.KafkaDataConsumer$;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011-dA\u0002?~\u0001}\f\u0019\u0002\u0003\u0006\u0002.\u0001\u0011\t\u0011)A\u0005\u0003cA!\"!\u0011\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u0011)\t)\b\u0001B\u0001B\u0003%\u0011q\u000f\u0005\u000b\u0003\u007f\u0002!\u0011!Q\u0001\n\u0005\u0005\u0005bBAD\u0001\u0011\u0005\u0011\u0011\u0012\u0005\n\u0003+\u0003\u0001\u0019!C\u0005\u0003/C\u0011\"a(\u0001\u0001\u0004%I!!)\t\u0011\u00055\u0006\u0001)Q\u0005\u00033C\u0011\"a,\u0001\u0001\u0004%I!a&\t\u0013\u0005E\u0006\u00011A\u0005\n\u0005M\u0006\u0002CA\\\u0001\u0001\u0006K!!'\t\u0013\u0005e\u0006A1A\u0005\n\u0005m\u0006\u0002CAb\u0001\u0001\u0006I!!0\t\u0015\u0005\u0015\u0007\u00011A\u0005\u0002u\f9\r\u0003\u0006\u0002V\u0002\u0001\r\u0011\"\u0001~\u0003/D\u0001\"a7\u0001A\u0003&\u0011\u0011\u001a\u0005\n\u0003K\u0004\u0001\u0019!C\u0005\u0003OD\u0011\"!=\u0001\u0001\u0004%I!a=\t\u0011\u0005]\b\u0001)Q\u0005\u0003SD\u0011\"a?\u0001\u0005\u0004%I!!@\t\u0011\u0005}\b\u0001)A\u0005\u0003'B\u0011B!\u0001\u0001\u0005\u0004%IAa\u0001\t\u0011\r5\u0004\u0001)A\u0005\u0005\u000bA\u0011ba\u001c\u0001\u0005\u0004%Ia!\u001d\t\u0011\re\u0004\u0001)A\u0005\u0007gB\u0011ba\u001f\u0001\u0001\u0004%I!a&\t\u0013\ru\u0004\u00011A\u0005\n\r}\u0004\u0002CBB\u0001\u0001\u0006K!!'\t\u0013\r\u0015\u0005\u00011A\u0005\n\u0005]\u0005\"CBD\u0001\u0001\u0007I\u0011BBE\u0011!\u0019i\t\u0001Q!\n\u0005e\u0005\"CBH\u0001\u0001\u0007I\u0011BAL\u0011%\u0019\t\n\u0001a\u0001\n\u0013\u0019\u0019\n\u0003\u0005\u0004\u0018\u0002\u0001\u000b\u0015BAM\u0011%\u0019I\n\u0001a\u0001\n\u0013\t9\nC\u0005\u0004\u001c\u0002\u0001\r\u0011\"\u0003\u0004\u001e\"A1\u0011\u0015\u0001!B\u0013\tI\nC\u0005\u0004$\u0002\u0001\r\u0011\"\u0003\u0002\u0018\"I1Q\u0015\u0001A\u0002\u0013%1q\u0015\u0005\t\u0007W\u0003\u0001\u0015)\u0003\u0002\u001a\"91Q\u0016\u0001\u0005\u0002\r=\u0006bBBm\u0001\u0011\u000511\u001c\u0005\b\u0007?\u0004A\u0011ABq\u0011\u001d\u0019\u0019\u000f\u0001C\u0001\u0007CDqa!:\u0001\t\u0003\u00199\u000fC\u0004\u0004j\u0002!Iaa:\t\u000f\r-\b\u0001\"\u0003\u0004h\"91Q\u001e\u0001\u0005\n\r=\bbBB|\u0001\u0011%1\u0011 \u0005\b\t\u0013\u0001A\u0011\u0002C\u0006\u0011!!)\u0002\u0001C\u0001\u007f\u0012]\u0001b\u0002C\r\u0001\u0011%1q\u001d\u0005\b\t7\u0001A\u0011\u0002C\u000f\u0011\u001d!\t\u0003\u0001C\u0005\tGAq\u0001b\u000b\u0001\t\u0013!i\u0003C\u0005\u0005<\u0001\t\n\u0011\"\u0003\u0004j!9AQ\b\u0001\u0005\n\u0011}\u0002b\u0002C/\u0001\u0011%AqL\u0004\t\u0005\u0013i\b\u0012A@\u0003\f\u00199A0 E\u0001\u007f\n5\u0001bBADy\u0011\u0005!q\u0002\u0005\n\u0005#a$\u0019!C\u0001\u0003/C\u0001Ba\u0005=A\u0003%\u0011\u0011\u0014\u0004\u0007\u0005+a\u0004Ia\u0006\t\u0015\tE\u0002I!f\u0001\n\u0003\t9\n\u0003\u0006\u00034\u0001\u0013\t\u0012)A\u0005\u00033C!B!\u000eA\u0005+\u0007I\u0011AAL\u0011)\u00119\u0004\u0011B\tB\u0003%\u0011\u0011\u0014\u0005\b\u0003\u000f\u0003E\u0011\u0001B\u001d\u0011%\u0011\u0019\u0005QA\u0001\n\u0003\u0011)\u0005C\u0005\u0003L\u0001\u000b\n\u0011\"\u0001\u0003N!I!1\r!\u0012\u0002\u0013\u0005!Q\n\u0005\n\u0005K\u0002\u0015\u0011!C!\u0005OB\u0011B!\u001cA\u0003\u0003%\tAa\u001c\t\u0013\t]\u0004)!A\u0005\u0002\te\u0004\"\u0003BB\u0001\u0006\u0005I\u0011\tBC\u0011%\u0011\u0019\nQA\u0001\n\u0003\u0011)\nC\u0005\u0003\u001a\u0002\u000b\t\u0011\"\u0011\u0003\u001c\"I!q\u0014!\u0002\u0002\u0013\u0005#\u0011\u0015\u0005\n\u0005G\u0003\u0015\u0011!C!\u0005KC\u0011Ba*A\u0003\u0003%\tE!+\b\u0013\t5F(!A\t\u0002\t=f!\u0003B\u000by\u0005\u0005\t\u0012\u0001BY\u0011\u001d\t9i\u0015C\u0001\u0005\u0013D\u0011Ba)T\u0003\u0003%)E!*\t\u0013\t-7+!A\u0005\u0002\n5\u0007\"\u0003Bj'\u0006\u0005I\u0011\u0011Bk\u0011%\u0011\u0019oUA\u0001\n\u0013\u0011)O\u0002\u0004\u0003hr\u0002%\u0011\u001e\u0005\u000b\u0003wL&Q3A\u0005\u0002\u0005u\bBCA\u00003\nE\t\u0015!\u0003\u0002T!Q\u0011QF-\u0003\u0016\u0004%\tAa;\t\u0015\t5\u0018L!E!\u0002\u0013\t\t\u0004C\u0004\u0002\bf#\tAa<\t\u000f\u0005\u001d\u0015\f\"\u0001\u0003x\"I!1I-\u0002\u0002\u0013\u0005!Q \u0005\n\u0005\u0017J\u0016\u0013!C\u0001\u0007\u0007A\u0011Ba\u0019Z#\u0003%\taa\u0002\t\u0013\t\u0015\u0014,!A\u0005B\t\u001d\u0004\"\u0003B73\u0006\u0005I\u0011\u0001B8\u0011%\u00119(WA\u0001\n\u0003\u0019Y\u0001C\u0005\u0003\u0004f\u000b\t\u0011\"\u0011\u0003\u0006\"I!1S-\u0002\u0002\u0013\u00051q\u0002\u0005\n\u00053K\u0016\u0011!C!\u0007'A\u0011Ba(Z\u0003\u0003%\tE!)\t\u0013\t\r\u0016,!A\u0005B\t\u0015\u0006\"\u0003BT3\u0006\u0005I\u0011IB\f\u000f%\u0019Y\u0002PA\u0001\u0012\u0003\u0019iBB\u0005\u0003hr\n\t\u0011#\u0001\u0004 !9\u0011qQ7\u0005\u0002\r\r\u0002\"\u0003BR[\u0006\u0005IQ\tBS\u0011%\u0011Y-\\A\u0001\n\u0003\u001b)\u0003C\u0005\u0003T6\f\t\u0011\"!\u0004,!I!1]7\u0002\u0002\u0013%!Q\u001d\u0005\n\u0007ga$\u0019!C\u0005\u0007kA\u0001ba\u0010=A\u0003%1q\u0007\u0005\n\u0003kb$\u0019!C\u0005\u0007\u0003B\u0001ba\u0011=A\u0003%\u0011q\u000f\u0005\n\u0003\u007fb$\u0019!C\u0005\u0007\u000bB\u0001ba\u0012=A\u0003%\u0011\u0011\u0011\u0005\b\u0007\u0013bD\u0011AB&\u0011\u001d\u0019\t\u0006\u0010C\u0005\u0007'B\u0011ba\u001a=#\u0003%Ia!\u001b\u0003#-\u000bgm[1ECR\f7i\u001c8tk6,'O\u0003\u0002\u007f\u007f\u0006A1m\u001c8tk6,'O\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001C6bM.\f\u0007'\r\u0019\u000b\t\u0005\u0015\u0011qA\u0001\u0004gFd'\u0002BA\u0005\u0003\u0017\tQa\u001d9be.TA!!\u0004\u0002\u0010\u00051\u0011\r]1dQ\u0016T!!!\u0005\u0002\u0007=\u0014xmE\u0003\u0001\u0003+\t\t\u0003\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\t\tY\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002 \u0005e!AB!osJ+g\r\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\u0011\t9#a\u0002\u0002\u0011%tG/\u001a:oC2LA!a\u000b\u0002&\t9Aj\\4hS:<\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0002\u0001!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\taaY8n[>t'\u0002BA\u001e\u0003\u0017\tQa[1gW\u0006LA!a\u0010\u00026\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017aC6bM.\f\u0007+\u0019:b[N\u0004\u0002\"!\u0012\u0002P\u0005M\u0013\u0011N\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005!Q\u000f^5m\u0015\t\ti%\u0001\u0003kCZ\f\u0017\u0002BA)\u0003\u000f\u00121!T1q!\u0011\t)&a\u0019\u000f\t\u0005]\u0013q\f\t\u0005\u00033\nI\"\u0004\u0002\u0002\\)!\u0011QLA\u0018\u0003\u0019a$o\\8u}%!\u0011\u0011MA\r\u0003\u0019\u0001&/\u001a3fM&!\u0011QMA4\u0005\u0019\u0019FO]5oO*!\u0011\u0011MA\r!\u0011\tY'!\u001d\u000e\u0005\u00055$\u0002BA8\u0003\u0017\nA\u0001\\1oO&!\u00111OA7\u0005\u0019y%M[3di\u0006a1m\u001c8tk6,'\u000fU8pYB!\u0011\u0011PA>\u001b\u0005i\u0018bAA?{\nI\u0012J\u001c;fe:\fGnS1gW\u0006\u001cuN\\:v[\u0016\u0014\bk\\8m\u0003=1W\r^2iK\u0012$\u0015\r^1Q_>d\u0007\u0003BA=\u0003\u0007K1!!\"~\u0005=1U\r^2iK\u0012$\u0015\r^1Q_>d\u0017A\u0002\u001fj]&$h\b\u0006\u0006\u0002\f\u00065\u0015qRAI\u0003'\u00032!!\u001f\u0001\u0011\u001d\ti#\u0002a\u0001\u0003cAq!!\u0011\u0006\u0001\u0004\t\u0019\u0005C\u0004\u0002v\u0015\u0001\r!a\u001e\t\u000f\u0005}T\u00011\u0001\u0002\u0002\u0006\u0001rN\u001a4tKR|U\u000f^(g%\u0006tw-Z\u000b\u0003\u00033\u0003B!a\u0006\u0002\u001c&!\u0011QTA\r\u0005\u0011auN\\4\u0002)=4gm]3u\u001fV$xJ\u001a*b]\u001e,w\fJ3r)\u0011\t\u0019+!+\u0011\t\u0005]\u0011QU\u0005\u0005\u0003O\u000bIB\u0001\u0003V]&$\b\"CAV\u000f\u0005\u0005\t\u0019AAM\u0003\rAH%M\u0001\u0012_\u001a47/\u001a;PkR|eMU1oO\u0016\u0004\u0013\u0001\u00033bi\u0006dun]:\u0002\u0019\u0011\fG/\u0019'pgN|F%Z9\u0015\t\u0005\r\u0016Q\u0017\u0005\n\u0003WS\u0011\u0011!a\u0001\u00033\u000b\u0011\u0002Z1uC2{7o\u001d\u0011\u0002-%\u001cHk\\6f]B\u0013xN^5eKJ,e.\u00192mK\u0012,\"!!0\u0011\t\u0005]\u0011qX\u0005\u0005\u0003\u0003\fIBA\u0004C_>dW-\u00198\u0002/%\u001cHk\\6f]B\u0013xN^5eKJ,e.\u00192mK\u0012\u0004\u0013!C0d_:\u001cX/\\3s+\t\tI\r\u0005\u0004\u0002\u0018\u0005-\u0017qZ\u0005\u0005\u0003\u001b\fIB\u0001\u0004PaRLwN\u001c\t\u0005\u0003s\n\t.C\u0002\u0002Tv\u0014Q#\u00138uKJt\u0017\r\\&bM.\f7i\u001c8tk6,'/A\u0007`G>t7/^7fe~#S-\u001d\u000b\u0005\u0003G\u000bI\u000eC\u0005\u0002,>\t\t\u00111\u0001\u0002J\u0006QqlY8ogVlWM\u001d\u0011)\u0007A\ty\u000e\u0005\u0003\u0002\u0018\u0005\u0005\u0018\u0002BAr\u00033\u0011\u0001B^8mCRLG.Z\u0001\r?\u001a,Go\u00195fI\u0012\u000bG/Y\u000b\u0003\u0003S\u0004b!a\u0006\u0002L\u0006-\b\u0003BA=\u0003[L1!a<~\u0005-1U\r^2iK\u0012$\u0015\r^1\u0002!}3W\r^2iK\u0012$\u0015\r^1`I\u0015\fH\u0003BAR\u0003kD\u0011\"a+\u0013\u0003\u0003\u0005\r!!;\u0002\u001b}3W\r^2iK\u0012$\u0015\r^1!Q\r\u0019\u0012q\\\u0001\bOJ|W\u000f]%e+\t\t\u0019&\u0001\u0005he>,\b/\u00133!\u0003!\u0019\u0017m\u00195f\u0017\u0016LXC\u0001B\u0003!\r\u00119!\u0017\b\u0004\u0003sZ\u0014!E&bM.\fG)\u0019;b\u0007>t7/^7feB\u0019\u0011\u0011\u0010\u001f\u0014\u000bq\n)\"!\t\u0015\u0005\t-\u0011AD+O\u0017:{uKT0P\r\u001a\u001bV\tV\u0001\u0010+:[ejT,O?>3eiU#UA\t!\u0012I^1jY\u0006\u0014G.Z(gMN,GOU1oO\u0016\u001cr\u0001QA\u000b\u00053\u0011y\u0002\u0005\u0003\u0002\u0018\tm\u0011\u0002\u0002B\u000f\u00033\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003\"\t-b\u0002\u0002B\u0012\u0005OqA!!\u0017\u0003&%\u0011\u00111D\u0005\u0005\u0005S\tI\"A\u0004qC\u000e\\\u0017mZ3\n\t\t5\"q\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0005\u0005S\tI\"\u0001\u0005fCJd\u0017.Z:u\u0003%)\u0017M\u001d7jKN$\b%\u0001\u0004mCR,7\u000f^\u0001\bY\u0006$Xm\u001d;!)\u0019\u0011YDa\u0010\u0003BA\u0019!Q\b!\u000e\u0003qBqA!\rF\u0001\u0004\tI\nC\u0004\u00036\u0015\u0003\r!!'\u0002\t\r|\u0007/\u001f\u000b\u0007\u0005w\u00119E!\u0013\t\u0013\tEb\t%AA\u0002\u0005e\u0005\"\u0003B\u001b\rB\u0005\t\u0019AAM\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0014+\t\u0005e%\u0011K\u0016\u0003\u0005'\u0002BA!\u0016\u0003`5\u0011!q\u000b\u0006\u0005\u00053\u0012Y&A\u0005v]\u000eDWmY6fI*!!QLA\r\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005C\u00129FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005S\u0002B!a\u001b\u0003l%!\u0011QMA7\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011\t\b\u0005\u0003\u0002\u0018\tM\u0014\u0002\u0002B;\u00033\u00111!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u001f\u0003\u0002B!\u0011q\u0003B?\u0013\u0011\u0011y(!\u0007\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002,.\u000b\t\u00111\u0001\u0003r\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\bB1!\u0011\u0012BH\u0005wj!Aa#\u000b\t\t5\u0015\u0011D\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BI\u0005\u0017\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011Q\u0018BL\u0011%\tY+TA\u0001\u0002\u0004\u0011Y(\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B5\u0005;C\u0011\"a+O\u0003\u0003\u0005\rA!\u001d\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u001d\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u001b\u0002\r\u0015\fX/\u00197t)\u0011\tiLa+\t\u0013\u0005-\u0016+!AA\u0002\tm\u0014\u0001F!wC&d\u0017M\u00197f\u001f\u001a47/\u001a;SC:<W\rE\u0002\u0003>M\u001bRa\u0015BZ\u0005\u007f\u0003\"B!.\u0003<\u0006e\u0015\u0011\u0014B\u001e\u001b\t\u00119L\u0003\u0003\u0003:\u0006e\u0011a\u0002:v]RLW.Z\u0005\u0005\u0005{\u00139LA\tBEN$(/Y2u\rVt7\r^5p]J\u0002BA!1\u0003H6\u0011!1\u0019\u0006\u0005\u0005\u000b\fY%\u0001\u0002j_&!!Q\u0006Bb)\t\u0011y+A\u0003baBd\u0017\u0010\u0006\u0004\u0003<\t='\u0011\u001b\u0005\b\u0005c1\u0006\u0019AAM\u0011\u001d\u0011)D\u0016a\u0001\u00033\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003X\n}\u0007CBA\f\u0003\u0017\u0014I\u000e\u0005\u0005\u0002\u0018\tm\u0017\u0011TAM\u0013\u0011\u0011i.!\u0007\u0003\rQ+\b\u000f\\33\u0011%\u0011\toVA\u0001\u0002\u0004\u0011Y$A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!\u001b\u0003\u0011\r\u000b7\r[3LKf\u001cr!WA\u000b\u00053\u0011y\"\u0006\u0002\u00022\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005\u0006\u0004\u0003r\nM(Q\u001f\t\u0004\u0005{I\u0006bBA~=\u0002\u0007\u00111\u000b\u0005\b\u0003[q\u0006\u0019AA\u0019)\u0019\u0011\tP!?\u0003|\"9\u0011QF0A\u0002\u0005E\u0002bBA!?\u0002\u0007\u00111\t\u000b\u0007\u0005c\u0014yp!\u0001\t\u0013\u0005m\b\r%AA\u0002\u0005M\u0003\"CA\u0017AB\u0005\t\u0019AA\u0019+\t\u0019)A\u000b\u0003\u0002T\tESCAB\u0005U\u0011\t\tD!\u0015\u0015\t\tm4Q\u0002\u0005\n\u0003W+\u0017\u0011!a\u0001\u0005c\"B!!0\u0004\u0012!I\u00111V4\u0002\u0002\u0003\u0007!1\u0010\u000b\u0005\u0005S\u001a)\u0002C\u0005\u0002,\"\f\t\u00111\u0001\u0003rQ!\u0011QXB\r\u0011%\tYk[A\u0001\u0002\u0004\u0011Y(\u0001\u0005DC\u000eDWmS3z!\r\u0011i$\\\n\u0006[\u000e\u0005\"q\u0018\t\u000b\u0005k\u0013Y,a\u0015\u00022\tEHCAB\u000f)\u0019\u0011\tpa\n\u0004*!9\u00111 9A\u0002\u0005M\u0003bBA\u0017a\u0002\u0007\u0011\u0011\u0007\u000b\u0005\u0007[\u0019\t\u0004\u0005\u0004\u0002\u0018\u0005-7q\u0006\t\t\u0003/\u0011Y.a\u0015\u00022!I!\u0011]9\u0002\u0002\u0003\u0007!\u0011_\u0001\ngB\f'o[\"p]\u001a,\"aa\u000e\u0011\t\re21H\u0007\u0003\u0003\u000fIAa!\u0010\u0002\b\tI1\u000b]1sW\u000e{gNZ\u0001\u000bgB\f'o[\"p]\u001a\u0004SCAA<\u00035\u0019wN\\:v[\u0016\u0014\bk\\8mAU\u0011\u0011\u0011Q\u0001\u0011M\u0016$8\r[3e\t\u0006$\u0018\rU8pY\u0002\nq!Y2rk&\u0014X\r\u0006\u0004\u0002\f\u000e53q\n\u0005\b\u0003[I\b\u0019AA\u0019\u0011\u001d\t\t%\u001fa\u0001\u0003\u0007\nqB]3q_J$H)\u0019;b\u0019>\u001c8\u000f\r\u000b\t\u0003G\u001b)f!\u0017\u0004^!91q\u000b>A\u0002\u0005u\u0016A\u00044bS2|e\u000eR1uC2{7o\u001d\u0005\b\u00077R\b\u0019AA*\u000311\u0017N\\1m\u001b\u0016\u001c8/Y4f\u0011%\u0019yF\u001fI\u0001\u0002\u0004\u0019\t'A\u0003dCV\u001cX\r\u0005\u0003\u0003\"\r\r\u0014\u0002BB3\u0005_\u0011\u0011\u0002\u00165s_^\f'\r\\3\u00023I,\u0007o\u001c:u\t\u0006$\u0018\rT8tgB\"C-\u001a4bk2$HeM\u000b\u0003\u0007WRCa!\u0019\u0003R\u0005I1-Y2iK.+\u0017\u0010I\u0001\u000eM\u0016$8\r[3e%\u0016\u001cwN\u001d3\u0016\u0005\rM\u0004\u0003BA=\u0007kJ1aa\u001e~\u000551U\r^2iK\u0012\u0014VmY8sI\u0006qa-\u001a;dQ\u0016$'+Z2pe\u0012\u0004\u0013A\u0005;pi\u0006dG+[7f%\u0016\fGMT1o_N\fa\u0003^8uC2$\u0016.\\3SK\u0006$g*\u00198pg~#S-\u001d\u000b\u0005\u0003G\u001b\t\tC\u0005\u0002,n\t\t\u00111\u0001\u0002\u001a\u0006\u0019Bo\u001c;bYRKW.\u001a*fC\u0012t\u0015M\\8tA\u0005Aa.^7Q_2d7/\u0001\u0007ok6\u0004v\u000e\u001c7t?\u0012*\u0017\u000f\u0006\u0003\u0002$\u000e-\u0005\"CAV=\u0005\u0005\t\u0019AAM\u0003%qW/\u001c)pY2\u001c\b%\u0001\tok6\u0014VmY8sIN\u0004v\u000e\u001c7fI\u0006!b.^7SK\u000e|'\u000fZ:Q_2dW\rZ0%KF$B!a)\u0004\u0016\"I\u00111V\u0011\u0002\u0002\u0003\u0007\u0011\u0011T\u0001\u0012]Vl'+Z2pe\u0012\u001c\bk\u001c7mK\u0012\u0004\u0013\u0001\u0005;pi\u0006d'+Z2pe\u0012\u001c(+Z1e\u0003Q!x\u000e^1m%\u0016\u001cwN\u001d3t%\u0016\fGm\u0018\u0013fcR!\u00111UBP\u0011%\tY\u000bJA\u0001\u0002\u0004\tI*A\tu_R\fGNU3d_J$7OU3bI\u0002\n!c\u001d;beR$\u0016.\\3ti\u0006l\u0007OT1o_\u000612\u000f^1siRKW.Z:uC6\u0004h*\u00198p?\u0012*\u0017\u000f\u0006\u0003\u0002$\u000e%\u0006\"CAVO\u0005\u0005\t\u0019AAM\u0003M\u0019H/\u0019:u)&lWm\u001d;b[Bt\u0015M\\8!\u0003\r9W\r\u001e\u000b\u000b\u0007c\u001bYma4\u0004T\u000e]\u0007\u0003CBZ\u0007w\u001byla0\u000e\u0005\rU&b\u0001@\u00048*!1\u0011XA\u001d\u0003\u001d\u0019G.[3oiNLAa!0\u00046\nq1i\u001c8tk6,'OU3d_J$\u0007CBA\f\u0007\u0003\u001c)-\u0003\u0003\u0004D\u0006e!!B!se\u0006L\b\u0003BA\f\u0007\u000fLAa!3\u0002\u001a\t!!)\u001f;f\u0011\u001d\u0019i-\u000ba\u0001\u00033\u000baa\u001c4gg\u0016$\bbBBiS\u0001\u0007\u0011\u0011T\u0001\fk:$\u0018\u000e\\(gMN,G\u000fC\u0004\u0004V&\u0002\r!!'\u0002\u001bA|G\u000e\u001c+j[\u0016|W\u000f^'t\u0011\u001d\u00199&\u000ba\u0001\u0003{\u000bqcZ3u\u0003Z\f\u0017\u000e\\1cY\u0016|eMZ:fiJ\u000bgnZ3\u0015\u0005\ru\u0007c\u0001B\u0004\u0001\u00061r-\u001a;Ok6|eMZ:fi>+Ho\u00144SC:<W\r\u0006\u0002\u0002\u001a\u0006qq-\u001a;Ok6$\u0015\r^1M_N\u001c\u0018a\u0002:fY\u0016\f7/\u001a\u000b\u0003\u0003G\u000bqB]3mK\u0006\u001cXmQ8ogVlWM]\u0001\u0013e\u0016dW-Y:f\r\u0016$8\r[3e\t\u0006$\u0018-A\u0011hKR,\u0015M\u001d7jKN$\u0018I^1jY\u0006\u0014G.Z(gMN,GOQ3uo\u0016,g\u000e\u0006\u0005\u0002\u001a\u000eE81_B{\u0011\u0019q\b\u00071\u0001\u0002P\"91Q\u001a\u0019A\u0002\u0005e\u0005bBBia\u0001\u0007\u0011\u0011T\u0001\fM\u0016$8\r\u001b*fG>\u0014H\r\u0006\b\u0004t\rm8Q C\u0001\t\u0007!)\u0001b\u0002\t\ry\f\u0004\u0019AAh\u0011\u001d\u0019y0\ra\u0001\u0003W\f1BZ3uG\",G\rR1uC\"91QZ\u0019A\u0002\u0005e\u0005bBBic\u0001\u0007\u0011\u0011\u0014\u0005\b\u0007+\f\u0004\u0019AAM\u0011\u001d\u00199&\ra\u0001\u0003{\u000b\u0011BZ3uG\"$\u0015\r^1\u0015\u0015\u0005\rFQ\u0002C\b\t#!\u0019\u0002\u0003\u0004\u007fe\u0001\u0007\u0011q\u001a\u0005\b\u0007\u007f\u0014\u0004\u0019AAv\u0011\u001d\u0019iM\ra\u0001\u00033Cqa!63\u0001\u0004\tI*A\u000bhKR|%OU3ue&,g/Z\"p]N,X.\u001a:\u0015\u0005\u0005=\u0017\u0001\u0005:fiJLWM^3D_:\u001cX/\\3s\u0003a9W\r^(s%\u0016$(/[3wK\u001a+Go\u00195fI\u0012\u000bG/\u0019\u000b\u0005\u0003W$y\u0002C\u0004\u0004NV\u0002\r!!'\u0002#\u0005$G-\u001b;j_:\fG.T3tg\u0006<W\r\u0006\u0005\u0002T\u0011\u0015Bq\u0005C\u0015\u0011\u001d\tiC\u000ea\u0001\u0003cAq!a?7\u0001\u0004\t\u0019\u0006C\u0004\u0004XY\u0002\r!!0\u0002\u001dI,\u0007o\u001c:u\t\u0006$\u0018\rT8tgRa\u00111\u0015C\u0018\tc!\u0019\u0004\"\u000e\u0005:!9\u0011QF\u001cA\u0002\u0005E\u0002bBA~o\u0001\u0007\u00111\u000b\u0005\b\u0007/:\u0004\u0019AA_\u0011\u001d!9d\u000ea\u0001\u0003'\nq!\\3tg\u0006<W\rC\u0005\u0004`]\u0002\n\u00111\u0001\u0004b\u0005A\"/\u001a9peR$\u0015\r^1M_N\u001cH\u0005Z3gCVdG\u000fJ\u001b\u00029I,h.\u00168j]R,'O];qi&\u0014G._%g!>\u001c8/\u001b2mKV!A\u0011\tC$)\u0011!\u0019\u0005b\u0015\u0011\t\u0011\u0015Cq\t\u0007\u0001\t\u001d!I%\u000fb\u0001\t\u0017\u0012\u0011\u0001V\t\u0005\t\u001b\u0012Y\b\u0005\u0003\u0002\u0018\u0011=\u0013\u0002\u0002C)\u00033\u0011qAT8uQ&tw\r\u0003\u0005\u0005Ve\"\t\u0019\u0001C,\u0003\u0011\u0011w\u000eZ=\u0011\r\u0005]A\u0011\fC\"\u0013\u0011!Y&!\u0007\u0003\u0011q\u0012\u0017P\\1nKz\n\u0011\u0002^5nK:\u000bgn\\:\u0016\t\u0011\u0005DQ\r\u000b\u0005\tG\"9\u0007\u0005\u0003\u0005F\u0011\u0015Da\u0002C%u\t\u0007A1\n\u0005\t\t+RD\u00111\u0001\u0005jA1\u0011q\u0003C-\tG\u0002")
public class KafkaDataConsumer
implements Logging {
    private final TopicPartition topicPartition;
    private final Map<String, Object> kafkaParams;
    private final InternalKafkaConsumerPool consumerPool;
    private final FetchedDataPool fetchedDataPool;
    private long offsetOutOfRange;
    private long dataLoss;
    private final boolean isTokenProviderEnabled;
    private volatile Option<InternalKafkaConsumer> _consumer;
    private volatile Option<FetchedData> _fetchedData;
    private final String groupId;
    private final CacheKey cacheKey;
    private final FetchedRecord fetchedRecord;
    private long totalTimeReadNanos;
    private long numPolls;
    private long numRecordsPolled;
    private long totalRecordsRead;
    private long startTimestampNano;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KafkaDataConsumer acquire(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
        return KafkaDataConsumer$.MODULE$.acquire(topicPartition, kafkaParams);
    }

    public static long UNKNOWN_OFFSET() {
        return KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long offsetOutOfRange() {
        return this.offsetOutOfRange;
    }

    private void offsetOutOfRange_$eq(long x$1) {
        this.offsetOutOfRange = x$1;
    }

    private long dataLoss() {
        return this.dataLoss;
    }

    private void dataLoss_$eq(long x$1) {
        this.dataLoss = x$1;
    }

    private boolean isTokenProviderEnabled() {
        return this.isTokenProviderEnabled;
    }

    public Option<InternalKafkaConsumer> _consumer() {
        return this._consumer;
    }

    public void _consumer_$eq(Option<InternalKafkaConsumer> x$1) {
        this._consumer = x$1;
    }

    private Option<FetchedData> _fetchedData() {
        return this._fetchedData;
    }

    private void _fetchedData_$eq(Option<FetchedData> x$1) {
        this._fetchedData = x$1;
    }

    private String groupId() {
        return this.groupId;
    }

    private CacheKey cacheKey() {
        return this.cacheKey;
    }

    private FetchedRecord fetchedRecord() {
        return this.fetchedRecord;
    }

    private long totalTimeReadNanos() {
        return this.totalTimeReadNanos;
    }

    private void totalTimeReadNanos_$eq(long x$1) {
        this.totalTimeReadNanos = x$1;
    }

    private long numPolls() {
        return this.numPolls;
    }

    private void numPolls_$eq(long x$1) {
        this.numPolls = x$1;
    }

    private long numRecordsPolled() {
        return this.numRecordsPolled;
    }

    private void numRecordsPolled_$eq(long x$1) {
        this.numRecordsPolled = x$1;
    }

    private long totalRecordsRead() {
        return this.totalRecordsRead;
    }

    private void totalRecordsRead_$eq(long x$1) {
        this.totalRecordsRead = x$1;
    }

    private long startTimestampNano() {
        return this.startTimestampNano;
    }

    private void startTimestampNano_$eq(long x$1) {
        this.startTimestampNano = x$1;
    }

    public ConsumerRecord<byte[], byte[]> get(long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        return (ConsumerRecord)this.runUninterruptiblyIfPossible((Function0 & Serializable)() -> {
            ConsumerRecord<byte[], byte[]> consumerRecord;
            Predef$.MODULE$.require(offset < untilOffset, (Function0 & Serializable)() -> new StringBuilder(69).append("offset must always be less than untilOffset [offset: ").append(offset).append(", untilOffset: ").append(untilOffset).append("]").toString());
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            FetchedData fetchedData = this.getOrRetrieveFetchedData(offset);
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(18).append("Get ").append(this.groupId()).append(" ").append($this.topicPartition).append(" nextOffset ").append(fetchedData.nextOffsetInFetchedData()).append(" ").toString()).append(new StringBuilder(10).append("requested ").append(offset).toString()).toString());
            LongRef toFetchOffset = LongRef.create((long)offset);
            FetchedRecord fetchedRecord = null;
            boolean isFetchComplete = false;
            while (toFetchOffset.elem != KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET() && !isFetchComplete) {
                try {
                    fetchedRecord = this.fetchRecord(consumer, fetchedData, toFetchOffset.elem, untilOffset, pollTimeoutMs, failOnDataLoss);
                    if (fetchedRecord.record() != null) {
                        isFetchComplete = true;
                        continue;
                    }
                    toFetchOffset.elem = fetchedRecord.nextOffsetToFetch();
                    if (toFetchOffset.elem >= untilOffset) {
                        fetchedData.reset();
                        toFetchOffset.elem = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
                        continue;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Skipped offsets [").append(offset).append(", ").append(toFetchOffset$1.elem).append("]").toString());
                }
                catch (OffsetOutOfRangeException e) {
                    this.releaseConsumer();
                    fetchedData.reset();
                    this.reportDataLoss($this.topicPartition, this.groupId(), failOnDataLoss, new StringBuilder(20).append("Cannot fetch offset ").append(toFetchOffset.elem).toString(), e);
                    long oldToFetchOffsetd = toFetchOffset.elem;
                    toFetchOffset.elem = this.getEarliestAvailableOffsetBetween(consumer, toFetchOffset.elem, untilOffset);
                    if (toFetchOffset.elem == KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET()) {
                        this.offsetOutOfRange_$eq(this.offsetOutOfRange() + (untilOffset - oldToFetchOffsetd));
                        continue;
                    }
                    this.offsetOutOfRange_$eq(this.offsetOutOfRange() + (toFetchOffset.elem - oldToFetchOffsetd));
                }
            }
            if (isFetchComplete) {
                this.totalRecordsRead_$eq(this.totalRecordsRead() + 1L);
                consumerRecord = fetchedRecord.record();
            } else {
                fetchedData.reset();
                consumerRecord = null;
            }
            return consumerRecord;
        });
    }

    public AvailableOffsetRange getAvailableOffsetRange() {
        return (AvailableOffsetRange)this.runUninterruptiblyIfPossible((Function0 & Serializable)() -> {
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            return (AvailableOffsetRange)this.timeNanos((Function0 & Serializable)() -> consumer.getAvailableOffsetRange());
        });
    }

    public long getNumOffsetOutOfRange() {
        return this.offsetOutOfRange();
    }

    public long getNumDataLoss() {
        return this.dataLoss();
    }

    public void release() {
        String kafkaMeta = (String)this._consumer().map((Function1 & Serializable)c -> new StringBuilder(24).append("topicPartition=").append(c.topicPartition()).append(" groupId=").append(c.groupId()).toString()).getOrElse((Function0 & Serializable)() -> "");
        long walTime = System.nanoTime() - this.startTimestampNano();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(49).append("From Kafka ").append(kafkaMeta).append(" read ").append(this.totalRecordsRead()).append(" records through ").append(this.numPolls()).append(" polls (polled ").toString()).append(new StringBuilder(51).append(" out ").append(this.numRecordsPolled()).append(" records), taking ").append(this.totalTimeReadNanos()).append(" nanos, during time span of ").toString()).append(new StringBuilder(7).append(walTime).append(" nanos.").toString()).toString());
        this.releaseConsumer();
        this.releaseFetchedData();
    }

    private void releaseConsumer() {
        block0: {
            if (!this._consumer().isDefined()) break block0;
            this.consumerPool.returnObject((InternalKafkaConsumer)this._consumer().get());
            this._consumer_$eq((Option<InternalKafkaConsumer>)None$.MODULE$);
        }
    }

    private void releaseFetchedData() {
        block0: {
            if (!this._fetchedData().isDefined()) break block0;
            this.fetchedDataPool.release(this.cacheKey(), (FetchedData)this._fetchedData().get());
            this._fetchedData_$eq((Option<FetchedData>)None$.MODULE$);
        }
    }

    private long getEarliestAvailableOffsetBetween(InternalKafkaConsumer consumer, long offset, long untilOffset) {
        long l;
        AvailableOffsetRange range = (AvailableOffsetRange)this.timeNanos((Function0 & Serializable)() -> consumer.getAvailableOffsetRange());
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Some data may be lost. Recovering from the earliest offset: ").append(range.earliest()).toString());
        TopicPartition topicPartition = consumer.topicPartition();
        String groupId = consumer.groupId();
        if (offset >= range.latest() || range.earliest() >= untilOffset) {
            String warningMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(untilOffset).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString()));
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> warningMessage);
            l = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
        } else if (offset >= range.earliest()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(51).append("Found a disappeared offset ").append(offset).append(". Some data may be lost ").toString()).append(String.valueOf(this.additionalMessage(topicPartition, groupId, false))).toString());
            l = offset;
        } else {
            String warningMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(range.earliest()).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString()));
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> warningMessage);
            l = range.earliest();
        }
        return l;
    }

    private FetchedRecord fetchRecord(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        FetchedRecord fetchedRecord;
        if (offset != fetchedData.nextOffsetInFetchedData()) {
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        } else if (!fetchedData.hasNext()) {
            if (offset < fetchedData.offsetAfterPoll()) {
                long nextOffsetToFetch = fetchedData.offsetAfterPoll();
                fetchedData.reset();
                return this.fetchedRecord().withRecord(null, nextOffsetToFetch);
            }
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        }
        if (!fetchedData.hasNext()) {
            Predef$.MODULE$.assert(offset <= fetchedData.offsetAfterPoll(), (Function0 & Serializable)() -> new StringBuilder(46).append("seek to ").append(offset).append(" and poll but the offset was reset to ").append(fetchedData.offsetAfterPoll()).toString());
            fetchedRecord = this.fetchedRecord().withRecord(null, fetchedData.offsetAfterPoll());
        } else {
            ConsumerRecord<byte[], byte[]> record = fetchedData.next();
            if (record.offset() > offset) {
                long earliestOffset;
                Tuple2<Object, Object> tuple2 = fetchedData.availableOffsetRange();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long l = earliestOffset = tuple2._1$mcJ$sp();
                long earliestOffset2 = l;
                if (earliestOffset2 <= offset) {
                    fetchedData.previous();
                    return this.fetchedRecord().withRecord(null, record.offset());
                }
                if (failOnDataLoss) {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), true, new StringBuilder(28).append("Cannot fetch records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                    throw new IllegalStateException("reportDataLoss didn't throw an exception when 'failOnDataLoss' is true");
                }
                if (record.offset() >= untilOffset) {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(untilOffset).append(")").toString(), this.reportDataLoss$default$5());
                    fetchedRecord = this.fetchedRecord().withRecord(null, untilOffset);
                } else {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                    fetchedRecord = this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
                }
            } else {
                if (record.offset() < offset) {
                    throw new IllegalStateException(new StringBuilder(51).append("Tried to fetch ").append(offset).append(" but the returned record offset was ").append(record.offset()).toString());
                }
                fetchedRecord = this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
            }
        }
        return fetchedRecord;
    }

    private void fetchData(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long pollTimeoutMs) {
        Tuple3 tuple3 = (Tuple3)this.timeNanos((Function0 & Serializable)() -> consumer.fetch(offset, pollTimeoutMs));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        List records = (List)tuple3._1();
        long offsetAfterPoll = BoxesRunTime.unboxToLong((Object)tuple3._2());
        AvailableOffsetRange range = (AvailableOffsetRange)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)records, (Object)BoxesRunTime.boxToLong((long)offsetAfterPoll), (Object)range);
        Tuple3 tuple33 = tuple32;
        List records2 = (List)tuple33._1();
        long offsetAfterPoll2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
        AvailableOffsetRange range2 = (AvailableOffsetRange)tuple33._3();
        this.numPolls_$eq(this.numPolls() + 1L);
        this.numRecordsPolled_$eq(this.numRecordsPolled() + (long)records2.size());
        fetchedData.withNewPoll(records2.listIterator(), offsetAfterPoll2, range2);
    }

    public InternalKafkaConsumer getOrRetrieveConsumer() {
        block1: {
            if (!this._consumer().isDefined()) {
                this.retrieveConsumer();
            }
            Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable)() -> "Consumer must be defined");
            if (!this.isTokenProviderEnabled() || !KafkaTokenUtil$.MODULE$.needTokenUpdate(((InternalKafkaConsumer)this._consumer().get()).kafkaParamsWithSecurity(), ((InternalKafkaConsumer)this._consumer().get()).clusterConfig())) break block1;
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Cached consumer uses an old delegation token, invalidating.");
            this.releaseConsumer();
            this.consumerPool.invalidateKey(this.cacheKey());
            this.fetchedDataPool.invalidate(this.cacheKey());
            this.retrieveConsumer();
        }
        return (InternalKafkaConsumer)this._consumer().get();
    }

    private void retrieveConsumer() {
        this._consumer_$eq((Option<InternalKafkaConsumer>)((Option)this.timeNanos((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)$this.consumerPool.borrowObject(this.cacheKey(), $this.kafkaParams)))));
        this.startTimestampNano_$eq(System.nanoTime());
        this.totalTimeReadNanos_$eq(0L);
        this.numPolls_$eq(0L);
        this.numRecordsPolled_$eq(0L);
        this.totalRecordsRead_$eq(0L);
        Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable)() -> "borrowing consumer from pool must always succeed.");
    }

    private FetchedData getOrRetrieveFetchedData(long offset) {
        FetchedData fetchedData;
        Option<FetchedData> option = this._fetchedData();
        if (None$.MODULE$.equals(option)) {
            this._fetchedData_$eq((Option<FetchedData>)Option$.MODULE$.apply((Object)this.fetchedDataPool.acquire(this.cacheKey(), offset)));
            Predef$.MODULE$.require(this._fetchedData().isDefined(), (Function0 & Serializable)() -> "acquiring fetched data from cache must always succeed.");
            fetchedData = (FetchedData)this._fetchedData().get();
        } else if (option instanceof Some) {
            FetchedData fetchedData2;
            Some some = (Some)option;
            fetchedData = fetchedData2 = (FetchedData)some.value();
        } else {
            throw new MatchError(option);
        }
        return fetchedData;
    }

    private String additionalMessage(TopicPartition topicPartition, String groupId, boolean failOnDataLoss) {
        return failOnDataLoss ? new StringBuilder(0).append(new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").toString()).append(String.valueOf(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE())).toString() : new StringBuilder(0).append(new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").toString()).append(String.valueOf(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE())).toString();
    }

    private void reportDataLoss(TopicPartition topicPartition, String groupId, boolean failOnDataLoss, String message, Throwable cause) {
        String finalMessage = new StringBuilder(1).append(message).append(" ").append(this.additionalMessage(topicPartition, groupId, failOnDataLoss)).toString();
        this.dataLoss_$eq(this.dataLoss() + 1L);
        KafkaDataConsumer$.MODULE$.org$apache$spark$sql$kafka010$consumer$KafkaDataConsumer$$reportDataLoss0(failOnDataLoss, finalMessage, cause);
    }

    private Throwable reportDataLoss$default$5() {
        return null;
    }

    private <T> T runUninterruptiblyIfPossible(Function0<T> body) {
        Object object;
        Thread thread = Thread.currentThread();
        if (thread instanceof UninterruptibleThread) {
            UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
            object = uninterruptibleThread.runUninterruptibly(body);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "KafkaDataConsumer is not running in UninterruptibleThread. It may hang when KafkaDataConsumer's methods are interrupted because of KAFKA-1894");
            object = body.apply();
        }
        return (T)object;
    }

    private <T> T timeNanos(Function0<T> body) {
        long startTime = System.nanoTime();
        Object result = body.apply();
        this.totalTimeReadNanos_$eq(this.totalTimeReadNanos() + (System.nanoTime() - startTime));
        return (T)result;
    }

    public KafkaDataConsumer(TopicPartition topicPartition, Map<String, Object> kafkaParams, InternalKafkaConsumerPool consumerPool, FetchedDataPool fetchedDataPool) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        this.consumerPool = consumerPool;
        this.fetchedDataPool = fetchedDataPool;
        Logging.$init$((Logging)this);
        this.offsetOutOfRange = 0L;
        this.dataLoss = 0L;
        this.isTokenProviderEnabled = HadoopDelegationTokenManager$.MODULE$.isServiceEnabled(SparkEnv$.MODULE$.get().conf(), "kafka");
        this._consumer = None$.MODULE$;
        this._fetchedData = None$.MODULE$;
        this.groupId = (String)kafkaParams.get("group.id");
        this.cacheKey = new CacheKey(this.groupId(), topicPartition);
        this.fetchedRecord = new FetchedRecord(null, KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET());
        this.totalTimeReadNanos = 0L;
        this.numPolls = 0L;
        this.numRecordsPolled = 0L;
        this.totalRecordsRead = 0L;
        this.startTimestampNano = System.nanoTime();
    }

    public static class AvailableOffsetRange
    implements Product,
    Serializable {
        private final long earliest;
        private final long latest;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long earliest() {
            return this.earliest;
        }

        public long latest() {
            return this.latest;
        }

        public AvailableOffsetRange copy(long earliest, long latest) {
            return new AvailableOffsetRange(earliest, latest);
        }

        public long copy$default$1() {
            return this.earliest();
        }

        public long copy$default$2() {
            return this.latest();
        }

        public String productPrefix() {
            return "AvailableOffsetRange";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.earliest());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.latest());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AvailableOffsetRange;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "earliest";
                    break;
                }
                case 1: {
                    string = "latest";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.earliest()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.latest()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AvailableOffsetRange)) return false;
            boolean bl = true;
            if (!bl) return false;
            AvailableOffsetRange availableOffsetRange = (AvailableOffsetRange)x$1;
            if (this.earliest() != availableOffsetRange.earliest()) return false;
            if (this.latest() != availableOffsetRange.latest()) return false;
            if (!availableOffsetRange.canEqual(this)) return false;
            return true;
        }

        public AvailableOffsetRange(long earliest, long latest) {
            this.earliest = earliest;
            this.latest = latest;
            Product.$init$((Product)this);
        }
    }

    public static class CacheKey
    implements Product,
    Serializable {
        private final String groupId;
        private final TopicPartition topicPartition;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String groupId() {
            return this.groupId;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public CacheKey copy(String groupId, TopicPartition topicPartition) {
            return new CacheKey(groupId, topicPartition);
        }

        public String copy$default$1() {
            return this.groupId();
        }

        public TopicPartition copy$default$2() {
            return this.topicPartition();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.groupId();
                    break;
                }
                case 1: {
                    object = this.topicPartition();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "groupId";
                    break;
                }
                case 1: {
                    string = "topicPartition";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            String string = this.groupId();
            String string2 = cacheKey.groupId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            TopicPartition topicPartition = this.topicPartition();
            TopicPartition topicPartition2 = cacheKey.topicPartition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            if (!cacheKey.canEqual(this)) return false;
            return true;
        }

        public CacheKey(String groupId, TopicPartition topicPartition) {
            this.groupId = groupId;
            this.topicPartition = topicPartition;
            Product.$init$((Product)this);
        }

        public CacheKey(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
            this((String)kafkaParams.get("group.id"), topicPartition);
        }
    }
}

