/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.GeneralAggregateFunc;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class MySQLDialect$
extends JdbcDialect
implements SQLConfHelper,
Product {
    public static final MySQLDialect$ MODULE$ = new MySQLDialect$();

    static {
        SQLConfHelper.$init$((SQLConfHelper)MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:mysql");
    }

    @Override
    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return super.compileAggregate(aggFunction).orElse((Function0 & Serializable)() -> {
            boolean bl = false;
            GeneralAggregateFunc generalAggregateFunc = null;
            AggregateFunc aggregateFunc = aggFunction;
            if (aggregateFunc instanceof GeneralAggregateFunc) {
                bl = true;
                generalAggregateFunc = (GeneralAggregateFunc)aggregateFunc;
                String string = generalAggregateFunc.name();
                String string2 = "VAR_POP";
                if (!(string != null ? !string.equals(string2) : string2 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    return new Some((Object)new StringBuilder(9).append("VAR_POP(").append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string3 = "VAR_SAMP";
                if (!(string != null ? !string.equals(string3) : string3 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    return new Some((Object)new StringBuilder(10).append("VAR_SAMP(").append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string4 = "STDDEV_POP";
                if (!(string != null ? !string.equals(string4) : string4 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    return new Some((Object)new StringBuilder(12).append("STDDEV_POP(").append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(")").toString());
                }
            }
            if (!bl) return None$.MODULE$;
            String string = generalAggregateFunc.name();
            String string5 = "STDDEV_SAMP";
            if (string == null) {
                if (string5 != null) {
                    return None$.MODULE$;
                }
            } else if (!string.equals(string5)) return None$.MODULE$;
            if (generalAggregateFunc.isDistinct()) return None$.MODULE$;
            Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
            return new Some((Object)new StringBuilder(13).append("STDDEV_SAMP(").append(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children()))).append(")").toString());
        });
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        Object object;
        if (sqlType == -3 && typeName.equals("BIT") && size != 1) {
            md.putLong("binarylong", 1L);
            object = Option$.MODULE$.apply((Object)LongType$.MODULE$);
        } else {
            object = sqlType == -7 && typeName.equals("TINYINT") ? Option$.MODULE$.apply((Object)BooleanType$.MODULE$) : None$.MODULE$;
        }
        return object;
    }

    @Override
    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("`").append(colName).append("`").toString();
    }

    @Override
    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])this.listSchemas(conn, options)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MySQLDialect$.$anonfun$schemasExists$1(schema, x$1)));
    }

    @Override
    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, "SHOW SCHEMAS", (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect$.$anonfun$listSchemas$1(schemaBuilder, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot show schemas.");
        }
        return (String[][])schemaBuilder.result();
    }

    @Override
    public String getTableExistsQuery(String table) {
        return new StringBuilder(22).append("SELECT 1 FROM ").append(table).append(" LIMIT 1").toString();
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(28).append("ALTER TABLE ").append(tableName).append(" MODIFY COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        if (dbMajorVersion < 8) {
            throw QueryExecutionErrors$.MODULE$.renameColumnUnsupportedForOlderMySQLError();
        }
        return new StringBuilder(0).append(new StringBuilder(30).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").toString()).append(new StringBuilder(1).append(" ").append(this.quoteIdentifier(newName)).toString()).toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(25).append("ALTER TABLE ").append(table).append(" COMMENT = '").append(comment).append("'").toString();
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        Option option = FloatType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("FLOAT", 6)) : JdbcUtils$.MODULE$.getCommonJDBCType(dt);
        return option;
    }

    @Override
    public String getSchemaCommentQuery(String schema, String comment) {
        throw QueryExecutionErrors$.MODULE$.unsupportedCreateNamespaceCommentError();
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        throw QueryExecutionErrors$.MODULE$.unsupportedRemoveNamespaceCommentError();
    }

    @Override
    public String createIndex(String indexName, String tableName, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (Function1 & Serializable)col -> MODULE$.quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames()))), ClassTag$.MODULE$.apply(String.class));
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "mysql");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String[] indexPropertyList = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)indexPropertyList);
        Tuple2 tuple23 = tuple22;
        String indexType2 = (String)tuple23._1();
        String[] indexPropertyList2 = (String[])tuple23._2();
        return new StringBuilder(0).append(new StringBuilder(17).append("CREATE INDEX ").append(this.quoteIdentifier(indexName)).append(" ").append(indexType2).append(" ON").toString()).append(new StringBuilder(4).append(" ").append(this.quoteIdentifier(tableName)).append(" (").append(Predef$.MODULE$.wrapRefArray((Object[])columnList).mkString(", ")).append(")").toString()).append(new StringBuilder(1).append(" ").append(Predef$.MODULE$.wrapRefArray((Object[])indexPropertyList2).mkString(" ")).toString()).toString();
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, String tableName, JDBCOptions options) {
        String sql = new StringBuilder(38).append("SHOW INDEXES FROM ").append(this.quoteIdentifier(tableName)).append(" WHERE key_name = '").append(indexName).append("'").toString();
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, String tableName) {
        return new StringBuilder(15).append("DROP INDEX ").append(this.quoteIdentifier(indexName)).append(" ON ").append(tableName).toString();
    }

    @Override
    public TableIndex[] listIndexes(Connection conn, String tableName, JDBCOptions options) {
        String sql = new StringBuilder(18).append("SHOW INDEXES FROM ").append(tableName).toString();
        ObjectRef indexMap = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        try {
            JdbcUtils$.MODULE$.executeQuery(conn, options, sql, (Function1<ResultSet, BoxedUnit>)(Function1 & Serializable)rs -> {
                MySQLDialect$.$anonfun$listIndexes$1(indexMap, rs);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Cannot retrieved index info.");
        }
        return (TableIndex[])((scala.collection.immutable.Map)indexMap.elem).values().toArray(ClassTag$.MODULE$.apply(TableIndex.class));
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        AnalysisException analysisException;
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 1061: {
                    throw new IndexAlreadyExistsException(message, (Option)new Some((Object)e));
                }
                case 1091: {
                    throw new NoSuchIndexException(message, (Option)new Some((Object)e));
                }
            }
            analysisException = super.classifyException(message, e);
        } else {
            if (throwable instanceof UnsupportedOperationException) {
                UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
                throw unsupportedOperationException;
            }
            analysisException = super.classifyException(message, e);
        }
        return analysisException;
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        if (!cascade) {
            throw QueryExecutionErrors$.MODULE$.unsupportedDropNamespaceRestrictError();
        }
        return new StringBuilder(12).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).toString();
    }

    public String productPrefix() {
        return "MySQLDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        Object object = Statics.ioobe((int)x$1);
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MySQLDialect$;
    }

    public int hashCode() {
        return 1790277476;
    }

    public String toString() {
        return "MySQLDialect";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MySQLDialect$.class);
    }

    public static final /* synthetic */ boolean $anonfun$schemasExists$1(String schema$1, String[] x$1) {
        Object object = ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$1));
        String string = schema$1;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$listSchemas$1(ArrayBuilder schemaBuilder$1, ResultSet rs) {
        while (rs.next()) {
            schemaBuilder$1.$plus$eq((Object)new String[]{rs.getString("Database")});
        }
    }

    public static final /* synthetic */ void $anonfun$listIndexes$1(ObjectRef indexMap$1, ResultSet rs) {
        while (rs.next()) {
            String indexName = rs.getString("key_name");
            String colName = rs.getString("column_name");
            String indexType = rs.getString("index_type");
            String indexComment = rs.getString("Index_comment");
            if (((scala.collection.immutable.Map)indexMap$1.elem).contains((Object)indexName)) {
                TableIndex index = (TableIndex)((scala.collection.immutable.Map)indexMap$1.elem).get((Object)indexName).get();
                TableIndex newIndex = new TableIndex(indexName, indexType, (NamedReference[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])index.columns()), (Object)FieldReference$.MODULE$.apply(colName), ClassTag$.MODULE$.apply(NamedReference.class)), index.columnProperties(), index.properties());
                indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)newIndex));
                continue;
            }
            Properties properties = new Properties();
            Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(indexComment)) ? properties.put("COMMENT", indexComment) : BoxedUnit.UNIT;
            TableIndex index = new TableIndex(indexName, indexType, (NamedReference[])((Object[])new NamedReference[]{FieldReference$.MODULE$.apply(colName)}), new HashMap(), properties);
            indexMap$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)indexMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)indexName), (Object)index));
        }
    }

    private MySQLDialect$() {
    }
}

