/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.PartitionStatistics;
import org.apache.spark.sql.execution.command.RepairTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.immutable.ParVector;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tug\u0001B\u0016-\u0001fB\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\tA\u0002\u0011\t\u0012)A\u00059\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005g\u0001\tE\t\u0015!\u0003d\u0011!9\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011B2\t\u0011%\u0004!Q3A\u0005\u0002)D\u0001b\u001d\u0001\u0003\u0012\u0003\u0006Ia\u001b\u0005\u0006i\u0002!\t!\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0011\u001d\tI\u0001\u0001Q\u0001\nuD\u0001\"a\u0003\u0001\u0005\u0004%\t\u0001 \u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003~\u0011!\ty\u0001\u0001b\u0001\n\u0003a\bbBA\t\u0001\u0001\u0006I! \u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\t9\u0004\u0001C!\u0003sAq!!\u0015\u0001\t\u0013\t\u0019\u0006C\u0004\u0002`\u0002!I!!9\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\"9!1\u0004\u0001\u0005\n\tu\u0001\"\u0003B\u0015\u0001\u0005\u0005I\u0011\u0001B\u0016\u0011%\u0011)\u0004AI\u0001\n\u0003\u00119\u0004C\u0005\u0003N\u0001\t\n\u0011\"\u0001\u0003P!I!1\u000b\u0001\u0012\u0002\u0013\u0005!q\n\u0005\n\u0005+\u0002\u0011\u0013!C\u0001\u0005/B\u0001Ba\u0017\u0001\u0003\u0003%\t\u0005 \u0005\n\u0005;\u0002\u0011\u0011!C\u0001\u0005?B\u0011B!\u0019\u0001\u0003\u0003%\tAa\u0019\t\u0013\t=\u0004!!A\u0005B\tE\u0004\"\u0003B>\u0001\u0005\u0005I\u0011\u0001B?\u0011%\u0011\t\tAA\u0001\n\u0003\u0012\u0019\tC\u0005\u0003\b\u0002\t\t\u0011\"\u0011\u0003\n\u001eI!Q\u0012\u0017\u0002\u0002#\u0005!q\u0012\u0004\tW1\n\t\u0011#\u0001\u0003\u0012\"1Ao\tC\u0001\u0005SC\u0011Ba+$\u0003\u0003%)E!,\t\u0013\t=6%!A\u0005\u0002\nE\u0006\"\u0003B^GE\u0005I\u0011\u0001B,\u0011%\u0011ilIA\u0001\n\u0003\u0013y\fC\u0005\u0003R\u000e\n\n\u0011\"\u0001\u0003X!I!1[\u0012\u0002\u0002\u0013%!Q\u001b\u0002\u0013%\u0016\u0004\u0018-\u001b:UC\ndWmQ8n[\u0006tGM\u0003\u0002.]\u000591m\\7nC:$'BA\u00181\u0003%)\u00070Z2vi&|gN\u0003\u00022e\u0005\u00191/\u001d7\u000b\u0005M\"\u0014!B:qCJ\\'BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001u\u0011Ce\n\u0005\u0002<\u00056\tAH\u0003\u0002>}\u00059An\\4jG\u0006d'BA A\u0003\u0015\u0001H.\u00198t\u0015\t\t\u0005'\u0001\u0005dCR\fG._:u\u0013\t\u0019EHA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA#G\u001b\u0005a\u0013BA$-\u0005MaU-\u00194Sk:t\u0017M\u00197f\u0007>lW.\u00198e!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u001d\u0001&o\u001c3vGR\u0004\"aT,\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*9\u0003\u0019a$o\\8u}%\t1*\u0003\u0002W\u0015\u00069\u0001/Y2lC\u001e,\u0017B\u0001-Z\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t1&*A\u0005uC\ndWMT1nKV\tA\f\u0005\u0002^=6\t\u0001)\u0003\u0002`\u0001\nyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u0006uC\ndWMT1nK\u0002\n1#\u001a8bE2,\u0017\t\u001a3QCJ$\u0018\u000e^5p]N,\u0012a\u0019\t\u0003\u0013\u0012L!!\u001a&\u0003\u000f\t{w\u000e\\3b]\u0006!RM\\1cY\u0016\fE\r\u001a)beRLG/[8og\u0002\nA#\u001a8bE2,GI]8q!\u0006\u0014H/\u001b;j_:\u001c\u0018!F3oC\ndW\r\u0012:paB\u000b'\u000f^5uS>t7\u000fI\u0001\u0004G6$W#A6\u0011\u00051\u0004hBA7o!\t\t&*\u0003\u0002p\u0015\u00061\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\ty'*\u0001\u0003d[\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0003wobL(\u0010\u0005\u0002F\u0001!)!,\u0003a\u00019\")\u0011-\u0003a\u0001G\")q-\u0003a\u0001G\"9\u0011.\u0003I\u0001\u0002\u0004Y\u0017!\u0003(V\u001b~3\u0015\nT#T+\u0005i\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00027b]\u001eT!!!\u0002\u0002\t)\fg/Y\u0005\u0003c~\f!BT+N?\u001aKE*R*!\u0003)!v\nV!M?NK%,R\u0001\f)>#\u0016\tT0T\u0013j+\u0005%\u0001\u0005E\t2{F+S'F\u0003%!E\tT0U\u00136+\u0005%A\u0007hKR\u0004\u0016\r\u001e5GS2$XM\u001d\u000b\u0005\u0003/\t9\u0003\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0005\u0019\u001c(bAA\u0011i\u00051\u0001.\u00193p_BLA!!\n\u0002\u001c\tQ\u0001+\u0019;i\r&dG/\u001a:\t\u000f\u0005%\u0002\u00031\u0001\u0002,\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u00055\u00121G\u0007\u0003\u0003_QA!!\r\u0002 \u0005!1m\u001c8g\u0013\u0011\t)$a\f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\r\u0011XO\u001c\u000b\u0005\u0003w\tI\u0005E\u0003P\u0003{\t\t%C\u0002\u0002@e\u00131aU3r!\u0011\t\u0019%!\u0012\u000e\u0003AJ1!a\u00121\u0005\r\u0011vn\u001e\u0005\u0007gE\u0001\r!a\u0013\u0011\t\u0005\r\u0013QJ\u0005\u0004\u0003\u001f\u0002$\u0001D*qCJ\\7+Z:tS>t\u0017AD:dC:\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0015\u0003+\ni)a$\u0002\u0018\u0006m\u0015qTAR\u0003S\u000b\u0019,a3\u0011\u000b=\u000bi$a\u0016\u0011\u000f%\u000bI&!\u0018\u0002\b&\u0019\u00111\f&\u0003\rQ+\b\u000f\\33!\u0011\ty&!!\u000f\t\u0005\u0005\u00141\u0010\b\u0005\u0003G\n9H\u0004\u0003\u0002f\u0005Ud\u0002BA4\u0003grA!!\u001b\u0002r9!\u00111NA8\u001d\r\t\u0016QN\u0005\u0002o%\u0011QGN\u0005\u0003gQJ!!\r\u001a\n\u0005\u0005\u0003\u0014bAA=\u0001\u000691-\u0019;bY><\u0017\u0002BA?\u0003\u007f\nAbQ1uC2|w\rV=qKNT1!!\u001fA\u0013\u0011\t\u0019)!\"\u0003%Q\u000b'\r\\3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0006\u0005\u0003{\ny\b\u0005\u0003\u0002\u001a\u0005%\u0015\u0002BAF\u00037\u0011A\u0001U1uQ\"11G\u0005a\u0001\u0003\u0017Bq!!\b\u0013\u0001\u0004\t\t\n\u0005\u0003\u0002\u001a\u0005M\u0015\u0002BAK\u00037\u0011!BR5mKNK8\u000f^3n\u0011\u001d\tIJ\u0005a\u0001\u0003/\taAZ5mi\u0016\u0014\bbBAO%\u0001\u0007\u0011qQ\u0001\u0005a\u0006$\b\u000eC\u0004\u0002\"J\u0001\r!!\u0018\u0002\tM\u0004Xm\u0019\u0005\b\u0003K\u0013\u0002\u0019AAT\u00039\u0001\u0018M\u001d;ji&|gNT1nKN\u0004BaTA\u001fW\"9\u00111\u0016\nA\u0002\u00055\u0016!\u0003;ie\u0016\u001c\bn\u001c7e!\rI\u0015qV\u0005\u0004\u0003cS%aA%oi\"9\u0011Q\u0017\nA\u0002\u0005]\u0016\u0001\u0003:fg>dg/\u001a:\u0011\t\u0005e\u0016Q\u0019\b\u0005\u0003w\u000b\tM\u0004\u0003\u0002d\u0005u\u0016bAA`\u0001\u0006A\u0011M\\1msNL7/C\u0002W\u0003\u0007T1!a0A\u0013\u0011\t9-!3\u0003\u0011I+7o\u001c7wKJT1AVAb\u0011\u001d\tiM\u0005a\u0001\u0003\u001f\fq\"\u001a<bYR\u000b7o[*vaB|'\u000f\u001e\t\u0005\u0003#\fY.\u0004\u0002\u0002T*!\u0011Q[Al\u0003!\u0001\u0018M]1mY\u0016d'bAAm\u0015\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u00171\u001b\u0002\u0014\r>\u00148NS8j]R\u000b7o[*vaB|'\u000f^\u0001\u0015O\u0006$\b.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^:\u0015\u0019\u0005\r\u0018q^Ay\u0003k\f90a?\u0011\r1\f)o[Au\u0013\r\t9O\u001d\u0002\u0004\u001b\u0006\u0004\bcA#\u0002l&\u0019\u0011Q\u001e\u0017\u0003'A\u000b'\u000f^5uS>t7\u000b^1uSN$\u0018nY:\t\rM\u001a\u0002\u0019AA&\u0011\u001d\t\u0019p\u0005a\u0001\u0003+\nQ\u0003]1si&$\u0018n\u001c8Ta\u0016\u001c7/\u00118e\u0019>\u001c7\u000fC\u0004\u0002\u001eM\u0001\r!!%\t\u000f\u0005e8\u00031\u0001\u0002\u0018\u0005Q\u0001/\u0019;i\r&dG/\u001a:\t\u000f\u0005-6\u00031\u0001\u0002.\u0006i\u0011\r\u001a3QCJ$\u0018\u000e^5p]N$\"B!\u0001\u0003\b\t%!Q\u0003B\f!\rI%1A\u0005\u0004\u0005\u000bQ%\u0001B+oSRDaa\r\u000bA\u0002\u0005-\u0003b\u0002B\u0006)\u0001\u0007!QB\u0001\u0006i\u0006\u0014G.\u001a\t\u0005\u0005\u001f\u0011\t\"\u0004\u0002\u0002\u0000%!!1CA@\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0011\u001d\t\u0019\u0010\u0006a\u0001\u0003+BqA!\u0007\u0015\u0001\u0004\t\u0019/\u0001\bqCJ$\u0018\u000e^5p]N#\u0018\r^:\u0002\u001d\u0011\u0014x\u000e\u001d)beRLG/[8ogR1\u0011Q\u0016B\u0010\u0005OAq!!\u001f\u0016\u0001\u0004\u0011\t\u0003\u0005\u0003\u0003\u0010\t\r\u0012\u0002\u0002B\u0013\u0003\u007f\u0012abU3tg&|gnQ1uC2|w\rC\u0004\u0002\u001eU\u0001\r!!%\u0002\t\r|\u0007/\u001f\u000b\nm\n5\"q\u0006B\u0019\u0005gAqA\u0017\f\u0011\u0002\u0003\u0007A\fC\u0004b-A\u0005\t\u0019A2\t\u000f\u001d4\u0002\u0013!a\u0001G\"9\u0011N\u0006I\u0001\u0002\u0004Y\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005sQ3\u0001\u0018B\u001eW\t\u0011i\u0004\u0005\u0003\u0003@\t%SB\u0001B!\u0015\u0011\u0011\u0019E!\u0012\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B$\u0015\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-#\u0011\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005#R3a\u0019B\u001e\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003Z)\u001a1Na\u000f\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti+\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t\u0015$1\u000e\t\u0004\u0013\n\u001d\u0014b\u0001B5\u0015\n\u0019\u0011I\\=\t\u0013\t5T$!AA\u0002\u00055\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003tA1!Q\u000fB<\u0005Kj!!a6\n\t\te\u0014q\u001b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002d\u0005\u007fB\u0011B!\u001c \u0003\u0003\u0005\rA!\u001a\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004{\n\u0015\u0005\"\u0003B7A\u0005\u0005\t\u0019AAW\u0003\u0019)\u0017/^1mgR\u00191Ma#\t\u0013\t5\u0014%!AA\u0002\t\u0015\u0014A\u0005*fa\u0006L'\u000fV1cY\u0016\u001cu.\\7b]\u0012\u0004\"!R\u0012\u0014\u000b\r\u0012\u0019Ja(\u0011\u0013\tU%1\u0014/dG.4XB\u0001BL\u0015\r\u0011IJS\u0001\beVtG/[7f\u0013\u0011\u0011iJa&\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0005\u0003\u0003\"\n\u001dVB\u0001BR\u0015\u0011\u0011)+a\u0001\u0002\u0005%|\u0017b\u0001-\u0003$R\u0011!qR\u0001\ti>\u001cFO]5oOR\tQ0A\u0003baBd\u0017\u0010F\u0005w\u0005g\u0013)La.\u0003:\")!L\na\u00019\")\u0011M\na\u0001G\")qM\na\u0001G\"9\u0011N\nI\u0001\u0002\u0004Y\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0019Bg!\u0015I%1\u0019Bd\u0013\r\u0011)M\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f%\u0013I\rX2dW&\u0019!1\u001a&\u0003\rQ+\b\u000f\\35\u0011!\u0011y\rKA\u0001\u0002\u00041\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa6\u0011\u0007y\u0014I.C\u0002\u0003\\~\u0014aa\u00142kK\u000e$\b")
public class RepairTableCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final boolean enableAddPartitions;
    private final boolean enableDropPartitions;
    private final String cmd;
    private final String NUM_FILES;
    private final String TOTAL_SIZE;
    private final String DDL_TIME;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$4() {
        return RepairTableCommand$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<TableIdentifier, Object, Object, String>> unapply(RepairTableCommand x$0) {
        return RepairTableCommand$.MODULE$.unapply(x$0);
    }

    public static String apply$default$4() {
        return RepairTableCommand$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, String>, RepairTableCommand> tupled() {
        return RepairTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<String, RepairTableCommand>>>> curried() {
        return RepairTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        RepairTableCommand repairTableCommand = this;
        synchronized (repairTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public boolean enableAddPartitions() {
        return this.enableAddPartitions;
    }

    public boolean enableDropPartitions() {
        return this.enableDropPartitions;
    }

    public String cmd() {
        return this.cmd;
    }

    public String NUM_FILES() {
        return this.NUM_FILES;
    }

    public String TOTAL_SIZE() {
        return this.TOTAL_SIZE;
    }

    public String DDL_TIME() {
        return this.DDL_TIME;
    }

    private PathFilter getPathFilter(Configuration hadoopConf) {
        JobConf jobConf = new JobConf(hadoopConf, this.getClass());
        PathFilter pathFilter = FileInputFormat.getInputPathFilter((JobConf)jobConf);
        return path -> {
            String name;
            String string = name = path.getName();
            String string2 = "_SUCCESS";
            if (string == null) {
                if (string2 == null) return false;
            } else if (string.equals(string2)) return false;
            String string3 = name;
            String string4 = "_temporary";
            if (string3 == null) {
                if (string4 == null) return false;
            } else if (string3.equals(string4)) return false;
            if (name.startsWith(".")) return false;
            if (pathFilter == null) return true;
            if (!pathFilter.accept(path)) return false;
            return true;
        };
    }

    @Override
    public Seq<Row> run(SparkSession spark) {
        int n;
        int droppedAmount;
        SessionCatalog catalog = spark.sessionState().catalog();
        CatalogTable table = catalog.getTableRawMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        if (table.partitionColumnNames().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.cmdOnlyWorksOnPartitionedTablesError(this.cmd(), tableIdentWithDB);
        }
        if (table.storage().locationUri().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.cmdOnlyWorksOnTableWithLocationError(this.cmd(), tableIdentWithDB);
        }
        Path root = new Path(table.location());
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(30).append("Recover all the partitions in ").append(root).toString());
        Configuration hadoopConf = spark.sessionState().newHadoopConf();
        FileSystem fs = root.getFileSystem(hadoopConf);
        int n2 = droppedAmount = this.enableDropPartitions() ? this.dropPartitions(catalog, fs) : 0;
        if (this.enableAddPartitions()) {
            Seq seq;
            int threshold = BoxesRunTime.unboxToInt((Object)spark.sparkContext().conf().get(org.apache.spark.internal.config.package$.MODULE$.RDD_PARALLEL_LISTING_THRESHOLD()));
            PathFilter pathFilter = this.getPathFilter(hadoopConf);
            ForkJoinPool evalPool = ThreadUtils$.MODULE$.newForkJoinPool("RepairTableCommand", 8);
            try {
                seq = (Seq)this.scanPartitions(spark, fs, pathFilter, root, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Seq<String>)table.partitionColumnNames(), threshold, (Function2<String, String, Object>)spark.sessionState().conf().resolver(), new ForkJoinTaskSupport(evalPool)).seq();
            }
            finally {
                evalPool.shutdown();
            }
            Seq partitionSpecsAndLocs = seq;
            int total = partitionSpecsAndLocs.length();
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(21).append("Found ").append(total).append(" partitions in ").append(root).toString());
            Map<String, PartitionStatistics> partitionStats = spark.sqlContext().conf().gatherFastStats() ? this.gatherPartitionStats(spark, (Seq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, fs, pathFilter, threshold) : Predef$.MODULE$.Map().empty();
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(54).append("Finished to gather the fast stats for all ").append(total).append(" partitions.").toString());
            this.addPartitions(spark, table, (Seq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, partitionStats);
            n = total;
        } else {
            n = 0;
        }
        int addedAmount = n;
        boolean x$1 = true;
        TableIdentifier x$2 = table.copy$default$1();
        CatalogTableType x$3 = table.copy$default$2();
        CatalogStorageFormat x$4 = table.copy$default$3();
        StructType x$5 = table.copy$default$4();
        Option x$6 = table.copy$default$5();
        Seq x$7 = table.copy$default$6();
        Option x$8 = table.copy$default$7();
        String x$9 = table.copy$default$8();
        long x$10 = table.copy$default$9();
        long x$11 = table.copy$default$10();
        String x$12 = table.copy$default$11();
        Map x$13 = table.copy$default$12();
        Option x$14 = table.copy$default$13();
        Option x$15 = table.copy$default$14();
        Option x$16 = table.copy$default$15();
        Seq x$17 = table.copy$default$16();
        boolean x$18 = table.copy$default$18();
        Map x$19 = table.copy$default$19();
        Option x$20 = table.copy$default$20();
        spark.sessionState().catalog().alterTable(table.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, true, x$18, x$19, x$20));
        try {
            spark.catalog().refreshTable(tableIdentWithDB);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0 & Serializable)() -> new StringBuilder(183).append(new StringBuilder(50).append("Cannot refresh the table '").append(tableIdentWithDB).append("'. A query of the table ").toString()).append("might return wrong result if the table was cached. To avoid such issue, you should ").append("uncache the table manually via the UNCACHE TABLE command after table recovering will ").append("complete fully.").toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        this.logInfo((Function0 & Serializable)() -> new StringBuilder(47).append("Recovered all partitions: added (").append(addedAmount).append("), dropped (").append(droppedAmount).append(").").toString());
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private Seq<Tuple2<Map<String, String>, Path>> scanPartitions(SparkSession spark, FileSystem fs, PathFilter filter, Path path, Map<String, String> spec, Seq<String> partitionNames, int threshold, Function2<String, String, Object> resolver, ForkJoinTaskSupport evalTaskSupport) {
        IndexedSeq indexedSeq;
        if (partitionNames.isEmpty()) {
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(spec), (Object)path)}));
        }
        FileStatus[] statuses = fs.listStatus(path, filter);
        if (partitionNames.length() > 1 && statuses.length > threshold || partitionNames.length() > 2) {
            ParVector parArray = new ParVector(Predef$.MODULE$.wrapRefArray((Object[])statuses).toVector());
            parArray.tasksupport_$eq((TaskSupport)evalTaskSupport);
            indexedSeq = parArray.seq();
        } else {
            indexedSeq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)statuses);
        }
        IndexedSeq statusPar = indexedSeq;
        return (Seq)statusPar.flatMap((Function1 & Serializable)st -> {
            Seq<Tuple2<Map<String, String>, Path>> seq;
            String name = st.getPath().getName();
            if (st.isDirectory() && name.contains("=")) {
                String[] ps = name.split("=", 2);
                String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[0]);
                String value = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[1]);
                if (BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)columnName, partitionNames.head()))) {
                    seq = this.scanPartitions(spark, fs, filter, st.getPath(), (Map<String, String>)((Map)spec.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partitionNames.head()), (Object)value)})))), (Seq<String>)((Seq)partitionNames.drop(1)), threshold, resolver, evalTaskSupport);
                } else {
                    this.logWarning((Function0 & Serializable)() -> new StringBuilder(49).append("expected partition column ").append(partitionNames.head()).append(", but got ").append(ps[0]).append(", ignoring it").toString());
                    seq = package$.MODULE$.Seq().empty();
                }
            } else {
                this.logWarning((Function0 & Serializable)() -> new StringBuilder(7).append("ignore ").append(new Path(path, name)).toString());
                seq = package$.MODULE$.Seq().empty();
            }
            return seq;
        });
    }

    private Map<String, PartitionStatistics> gatherPartitionStats(SparkSession spark, Seq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, FileSystem fs, PathFilter pathFilter, int threshold) {
        Map map;
        if (partitionSpecsAndLocs.length() > threshold) {
            Configuration hadoopConf = spark.sessionState().newHadoopConf();
            SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
            String[] serializedPaths = (String[])((IterableOnceOps)partitionSpecsAndLocs.map((Function1 & Serializable)x$3 -> ((Path)x$3._2()).toString())).toArray(ClassTag$.MODULE$.apply(String.class));
            int numParallelism = Math.min(serializedPaths.length, Math.min(spark.sparkContext().defaultParallelism(), 10000));
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(47).append("Gather the fast stats in parallel using ").append(numParallelism).append(" tasks.").toString());
            RDD qual$1 = spark.sparkContext().parallelize((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)serializedPaths), numParallelism, ClassTag$.MODULE$.apply(String.class));
            Function1 & Serializable x$1 = (Function1 & Serializable)paths -> {
                PathFilter pathFilter = this.getPathFilter(serializableConfiguration.value());
                return paths.map((Function1 & Serializable)x$4 -> new Path(x$4)).map((Function1 & Serializable)path -> {
                    FileSystem fs = path.getFileSystem(serializableConfiguration.value());
                    FileStatus[] statuses = fs.listStatus(path, pathFilter);
                    return new Tuple2((Object)path.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])statuses), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getLen()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                });
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            map = RDD$.MODULE$.rddToPairRDDFunctions(qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PartitionStatistics.class), (Ordering)Ordering.String$.MODULE$).collectAsMap().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        } else {
            map = ((IterableOnceOps)partitionSpecsAndLocs.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Path location = (Path)tuple2._2();
                FileStatus[] statuses = fs.listStatus(location, pathFilter);
                Tuple2 tuple22 = new Tuple2((Object)location.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])statuses), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.getLen()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                return tuple22;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return map;
    }

    private void addPartitions(SparkSession spark, CatalogTable table, Seq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, Map<String, PartitionStatistics> partitionStats) {
        int total = partitionSpecsAndLocs.length();
        LongRef done = LongRef.create((long)0L);
        int batchSize = BoxesRunTime.unboxToInt(spark.conf().get(SQLConf$.MODULE$.ADD_PARTITION_BATCH_SIZE()));
        partitionSpecsAndLocs.iterator().grouped(batchSize).foreach((Function1 & Serializable)batch -> {
            RepairTableCommand.$anonfun$addPartitions$1(this, partitionStats, table, spark, done, total, batch);
            return BoxedUnit.UNIT;
        });
    }

    private int dropPartitions(SessionCatalog catalog, FileSystem fs) {
        Seq dropPartSpecs = (Seq)ThreadUtils$.MODULE$.parmap(catalog.listPartitions(this.tableName(), catalog.listPartitions$default$2()), "RepairTableCommand: non-existing partitions", 8, (Function1 & Serializable)partition -> partition.storage().locationUri().flatMap((Function1 & Serializable)uri -> fs.exists(new Path(uri)) ? None$.MODULE$ : new Some((Object)partition.spec()))).flatten(Predef$.MODULE$.$conforms());
        catalog.dropPartitions(this.tableName(), dropPartSpecs, true, false, true);
        return dropPartSpecs.length();
    }

    public RepairTableCommand copy(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        return new RepairTableCommand(tableName, enableAddPartitions, enableDropPartitions, cmd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.enableAddPartitions();
    }

    public boolean copy$default$3() {
        return this.enableDropPartitions();
    }

    public String copy$default$4() {
        return this.cmd();
    }

    public String productPrefix() {
        return "RepairTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.enableAddPartitions());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.enableDropPartitions());
                break;
            }
            case 3: {
                object = this.cmd();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RepairTableCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "tableName";
                break;
            }
            case 1: {
                string = "enableAddPartitions";
                break;
            }
            case 2: {
                string = "enableDropPartitions";
                break;
            }
            case 3: {
                string = "cmd";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RepairTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        RepairTableCommand repairTableCommand = (RepairTableCommand)x$1;
        if (this.enableAddPartitions() != repairTableCommand.enableAddPartitions()) return false;
        if (this.enableDropPartitions() != repairTableCommand.enableDropPartitions()) return false;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = repairTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.cmd();
        String string2 = repairTableCommand.cmd();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!repairTableCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(RepairTableCommand $this, Map partitionStats$1, CatalogTable table$6, SparkSession spark$2, LongRef done$1, int total$2, Seq batch) {
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        Seq parts = (Seq)batch.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map spec = (Map)tuple2._1();
            Path location = (Path)tuple2._2();
            Map params = (Map)partitionStats$1.get((Object)location.toString()).map((Function1 & Serializable)x0$2 -> {
                PartitionStatistics partitionStatistics = x0$2;
                if (partitionStatistics == null) {
                    throw new MatchError((Object)partitionStatistics);
                }
                int numFiles = partitionStatistics.numFiles();
                long totalSize = partitionStatistics.totalSize();
                Map map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.NUM_FILES()), (Object)Integer.toString(numFiles)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.TOTAL_SIZE()), (Object)Long.toString(totalSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.DDL_TIME()), (Object)Long.toString(now))}));
                return map;
            }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
            CatalogTablePartition catalogTablePartition = new CatalogTablePartition(spec, table$6.storage().copy((Option)new Some((Object)location.toUri()), table$6.storage().copy$default$2(), table$6.storage().copy$default$3(), table$6.storage().copy$default$4(), table$6.storage().copy$default$5(), table$6.storage().copy$default$6()), params, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            return catalogTablePartition;
        });
        spark$2.sessionState().catalog().createPartitions($this.tableName(), parts, true);
        done$1.elem += (long)parts.length();
        $this.logDebug((Function0 & Serializable)() -> new StringBuilder(32).append("Recovered ").append(parts.length()).append(" partitions (").append(done$1.elem).append("/").append(total$2).append(" so far)").toString());
    }

    public RepairTableCommand(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        this.tableName = tableName;
        this.enableAddPartitions = enableAddPartitions;
        this.enableDropPartitions = enableDropPartitions;
        this.cmd = cmd;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        this.NUM_FILES = "numFiles";
        this.TOTAL_SIZE = "totalSize";
        this.DDL_TIME = "transient_lastDdlTime";
        Statics.releaseFence();
    }
}

