/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.AsyncCommitLog;
import org.apache.spark.sql.execution.streaming.AsyncOffsetSeqLog;
import org.apache.spark.sql.execution.streaming.AsyncProgressTrackingMicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.AvailableNowTrigger$;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001\u0002\u0017.\u0001iB\u0011b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011#\t\u0013\u001d\u0003!\u0011!Q\u0001\n!k\u0005\"\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(V\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u000b=\u0004A\u0011\u00019\t\u000f]\u0004!\u0019!C\tq\"1Q\u0010\u0001Q\u0001\neDqA \u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\u0001\u0011%\tY\u0002\u0001b\u0001\n\u0013\ti\u0002\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\u0010\u0011%\ti\u0003\u0001b\u0001\n\u0003\ny\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0011BA\u0019\u0011%\tI\u0004\u0001a\u0001\n\u0013\tY\u0004C\u0005\u0002D\u0001\u0001\r\u0011\"\u0003\u0002F!A\u0011\u0011\u000b\u0001!B\u0013\ti\u0004C\u0005\u0002T\u0001\u0011\r\u0011\"\u0005\u0002V!A\u0011Q\f\u0001!\u0002\u0013\t9\u0006C\u0005\u0002`\u0001\u0011\r\u0011\"\u0011\u0002b!A\u0011\u0011\u000e\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002l\u0001\u0011\r\u0011\"\u0011\u0002n!A\u0011Q\u000f\u0001!\u0002\u0013\ty\u0007C\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\"9\u0011\u0011\u0012\u0001\u0005B\u0005\u001d\u0005bBAF\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003\u001b\u0003A\u0011IAD\u0011\u001d\ty\t\u0001C!\u0003#Cq!a&\u0001\t\u0003\n9\tC\u0004\u0002\u001a\u0002!\t!a'\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"9\u0011\u0011\u0015\u0001\u0005\n\u0005\rvaBAS[!\u0005\u0011q\u0015\u0004\u0007Y5B\t!!+\t\r=\u001cC\u0011AAY\u0011%\t\u0019l\tb\u0001\n\u0003\t)\f\u0003\u0005\u0002B\u000e\u0002\u000b\u0011BA\\\u0011%\t\u0019m\tb\u0001\n\u0003\t)\f\u0003\u0005\u0002F\u000e\u0002\u000b\u0011BA\\\u0011%\t9m\tb\u0001\n\u0003\t)\f\u0003\u0005\u0002J\u000e\u0002\u000b\u0011BA\\\u0011\u001d\tYm\tC\u0005\u0003\u001b\u0014\u0001&Q:z]\u000e\u0004&o\\4sKN\u001cHK]1dW&tw-T5de>\u0014\u0015\r^2i\u000bb,7-\u001e;j_:T!AL\u0018\u0002\u0013M$(/Z1nS:<'B\u0001\u00192\u0003%)\u00070Z2vi&|gN\u0003\u00023g\u0005\u00191/\u001d7\u000b\u0005Q*\u0014!B:qCJ\\'B\u0001\u001c8\u0003\u0019\t\u0007/Y2iK*\t\u0001(A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001wA\u0011A(P\u0007\u0002[%\u0011a(\f\u0002\u0014\u001b&\u001c'o\u001c\"bi\u000eDW\t_3dkRLwN\\\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003\u0003\nk\u0011!M\u0005\u0003\u0007F\u0012Ab\u00159be.\u001cVm]:j_:L!aP#\n\u0005\u0019k#aD*ue\u0016\fW.\u0012=fGV$\u0018n\u001c8\u0002\u000fQ\u0014\u0018nZ4feB\u0011\u0011jS\u0007\u0002\u0015*\u0011a&M\u0005\u0003\u0019*\u0013q\u0001\u0016:jO\u001e,'/\u0003\u0002H\u000b\u0006aAO]5hO\u0016\u00148\t\\8dWB\u0011\u0001kU\u0007\u0002#*\u0011!kM\u0001\u0005kRLG.\u0003\u0002U#\n)1\t\\8dW&\u0011a*R\u0001\rKb$(/Y(qi&|gn\u001d\t\u00051\u0006$GM\u0004\u0002Z?B\u0011!,X\u0007\u00027*\u0011A,O\u0001\u0007yI|w\u000e\u001e \u000b\u0003y\u000bQa]2bY\u0006L!\u0001Y/\u0002\rA\u0013X\rZ3g\u0013\t\u00117MA\u0002NCBT!\u0001Y/\u0011\u0005a+\u0017B\u00014d\u0005\u0019\u0019FO]5oO\u0006!\u0001\u000f\\1o!\tIW.D\u0001k\u0015\tq3N\u0003\u0002mc\u0005A1-\u0019;bYf\u001cH/\u0003\u0002oU\niqK]5uKR{7\u000b\u001e:fC6\fa\u0001P5oSRtDCB9sgR,h\u000f\u0005\u0002=\u0001!)qH\u0002a\u0001\u0001\")qI\u0002a\u0001\u0011\")aJ\u0002a\u0001\u001f\")aK\u0002a\u0001/\")qM\u0002a\u0001Q\u0006a\u0013m]=oGB\u0013xn\u001a:fgN$&/Y2lS:<7\t[3dWB|\u0017N\u001c;j]\u001eLe\u000e^3sm\u0006dWj]\u000b\u0002sB\u0011!p_\u0007\u0002;&\u0011A0\u0018\u0002\u0005\u0019>tw-A\u0017bgft7\r\u0015:pOJ,7o\u001d+sC\u000e\\\u0017N\\4DQ\u0016\u001c7\u000e]8j]RLgnZ%oi\u0016\u0014h/\u00197Ng\u0002\n\u0011c]8ve\u000e,7i\\7nSR\fV/Z;f+\t\t\t\u0001\u0005\u0004\u0002\u0004\u0005=\u00111C\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007I\u000bYA\u0003\u0002\u0002\u000e\u0005!!.\u0019<b\u0013\u0011\t\t\"!\u0002\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$\u0017+^3vKB\u0019A(!\u0006\n\u0007\u0005]QFA\u0005PM\u001a\u001cX\r^*fc\u0006\u00112o\\;sG\u0016\u001cu.\\7jiF+X-^3!\u0003\tb\u0017m\u001d;CCR\u001c\u0007\u000eU3sg&\u001cH/\u001a3U_\u0012+(/\u00192mKN#xN]1hKV\u0011\u0011q\u0004\t\u0005\u0003C\t9#\u0004\u0002\u0002$)!\u0011QEA\u0003\u0003\u0019\tGo\\7jG&!\u0011\u0011FA\u0012\u0005)\tEo\\7jG2{gnZ\u0001$Y\u0006\u001cHOQ1uG\"\u0004VM]:jgR,G\rV8EkJ\f'\r\\3Ti>\u0014\u0018mZ3!\u0003=!(/[4hKJ,\u00050Z2vi>\u0014XCAA\u0019!\ra\u00141G\u0005\u0004\u0003ki#a\u0004+sS\u001e<WM]#yK\u000e,Ho\u001c:\u0002!Q\u0014\u0018nZ4fe\u0016CXmY;u_J\u0004\u0013\u0001D5t\r&\u00148\u000f\u001e\"bi\u000eDWCAA\u001f!\rQ\u0018qH\u0005\u0004\u0003\u0003j&a\u0002\"p_2,\u0017M\\\u0001\u0011SN4\u0015N]:u\u0005\u0006$8\r[0%KF$B!a\u0012\u0002NA\u0019!0!\u0013\n\u0007\u0005-SL\u0001\u0003V]&$\b\"CA(!\u0005\u0005\t\u0019AA\u001f\u0003\rAH%M\u0001\u000eSN4\u0015N]:u\u0005\u0006$8\r\u001b\u0011\u00025\u0005\u001c\u0018P\\2Xe&$Xm]#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0016\u0005\u0005]\u0003\u0003BA\u0002\u00033JA!a\u0017\u0002\u0006\t\u0011B\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u0003m\t7/\u001f8d/JLG/Z:Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2fA\u0005IqN\u001a4tKRdunZ\u000b\u0003\u0003G\u00022\u0001PA3\u0013\r\t9'\f\u0002\u0012\u0003NLhnY(gMN,GoU3r\u0019><\u0017AC8gMN,G\u000fT8hA\u0005I1m\\7nSRdunZ\u000b\u0003\u0003_\u00022\u0001PA9\u0013\r\t\u0019(\f\u0002\u000f\u0003NLhnY\"p[6LG\u000fT8h\u0003)\u0019w.\\7ji2{w\rI\u0001\"m\u0006d\u0017\u000eZ1uK>3gm]3u\u0019><\u0017I\u001c3HKR\u0004&/\u001a<PM\u001a\u001cX\r\u001e\u000b\u0005\u0003w\n\t\tE\u0003{\u0003{\n\u0019\"C\u0002\u0002\u0000u\u0013aa\u00149uS>t\u0007BBAB1\u0001\u0007\u00110A\u0007mCR,7\u000f\u001e\"bi\u000eD\u0017\nZ\u0001\u001d[\u0006\u00148.T5de>\u0014\u0015\r^2i\u000bb,7-\u001e;j_:\u001cF/\u0019:u)\t\t9%A\u000fdY\u0016\fg.\u00169MCN$X\t_3dkR,G-T5de>\u0014\u0015\r^2i\u0003Mi\u0017M]6NS\u000e\u0014xNQ1uG\"\u001cF/\u0019:u\u0003Ei\u0017M]6NS\u000e\u0014xNQ1uG\",e\u000eZ\u0001\u0006aV\u0014x-\u001a\u000b\u0005\u0003\u000f\n\u0019\n\u0003\u0004\u0002\u0016v\u0001\r!_\u0001\ni\"\u0014Xm\u001d5pY\u0012\fqa\u00197fC:,\b/\u0001\u000fbe\u0016<&/\u001b;fgB+g\u000eZ5oO>\u0013\u0018J\u001c)s_\u001e\u0014Xm]:\u0015\u0005\u0005u\u0012!\u0006<bY&$\u0017\r^3B]\u0012<U\r\u001e+sS\u001e<WM\u001d\u000b\u0003\u0003c\tad\u00195fG.tu\u000e^*uCR,g-\u001e7TiJ,\u0017-\\5oOF+XM]=\u0016\u0005\u0005\u001d\u0013\u0001K!ts:\u001c\u0007K]8he\u0016\u001c8\u000f\u0016:bG.LgnZ'jGJ|')\u0019;dQ\u0016CXmY;uS>t\u0007C\u0001\u001f$'\r\u0019\u00131\u0016\t\u0004u\u00065\u0016bAAX;\n1\u0011I\\=SK\u001a$\"!a*\u0002?\u0005\u001b\u0016LT\"`!J{uIU#T'~#&+Q\"L\u0013:;u,\u0012(B\u00052+E)\u0006\u0002\u00028B!\u0011\u0011XA`\u001b\t\tYL\u0003\u0003\u0002>\u0006-\u0011\u0001\u00027b]\u001eL1AZA^\u0003\u0001\n5+\u0017(D?B\u0013vj\u0012*F'N{FKU!D\u0017&suiX#O\u0003\ncU\t\u0012\u0011\u0002c\u0005\u001b\u0016LT\"`!J{uIU#T'~#&+Q\"L\u0013:;ul\u0011%F\u0007.\u0003v*\u0013(U\u0013:;u,\u0013(U\u000bJ3\u0016\tT0N'\u0006\u0011\u0014iU-O\u0007~\u0003&kT$S\u000bN\u001bv\f\u0016*B\u0007.KejR0D\u0011\u0016\u001b5\nU(J\u001dRKejR0J\u001dR+%KV!M?6\u001b\u0006%A\u001aB'fs5i\u0018)S\u001f\u001e\u0013ViU*`)J\u000b5iS%O\u000f~{e+\u0012*S\u0013\u0012+ulU%O\u0017~\u001bV\u000b\u0015)P%R{6\tS#D\u0017\u0006!\u0014iU-O\u0007~\u0003&kT$S\u000bN\u001bv\f\u0016*B\u0007.KejR0P-\u0016\u0013&+\u0013#F?NKejS0T+B\u0003vJ\u0015+`\u0007\"+5i\u0013\u0011\u0002_\u001d,G/Q:z]\u000e\u0004&o\\4sKN\u001cHK]1dW&twm\u00115fG.\u0004x.\u001b8uS:<\u0017J\u001c;feZ\fG.T:\u0015\u0007e\fy\rC\u0003WW\u0001\u0007q\u000b")
public class AsyncProgressTrackingMicroBatchExecution
extends MicroBatchExecution {
    private final Map<String, String> extraOptions;
    private final WriteToStream plan;
    private final long asyncProgressTrackingCheckpointingIntervalMs;
    private final ConcurrentLinkedQueue<OffsetSeq> sourceCommitQueue;
    private final AtomicLong lastBatchPersistedToDurableStorage;
    private final TriggerExecutor triggerExecutor;
    private boolean isFirstBatch;
    private final ThreadPoolExecutor asyncWritesExecutorService;
    private final AsyncOffsetSeqLog offsetLog;
    private final AsyncCommitLog commitLog;

    public static String ASYNC_PROGRESS_TRACKING_OVERRIDE_SINK_SUPPORT_CHECK() {
        return AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_OVERRIDE_SINK_SUPPORT_CHECK();
    }

    public static String ASYNC_PROGRESS_TRACKING_CHECKPOINTING_INTERVAL_MS() {
        return AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_CHECKPOINTING_INTERVAL_MS();
    }

    public static String ASYNC_PROGRESS_TRACKING_ENABLED() {
        return AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_ENABLED();
    }

    public long asyncProgressTrackingCheckpointingIntervalMs() {
        return this.asyncProgressTrackingCheckpointingIntervalMs;
    }

    private ConcurrentLinkedQueue<OffsetSeq> sourceCommitQueue() {
        return this.sourceCommitQueue;
    }

    private AtomicLong lastBatchPersistedToDurableStorage() {
        return this.lastBatchPersistedToDurableStorage;
    }

    @Override
    public TriggerExecutor triggerExecutor() {
        return this.triggerExecutor;
    }

    private boolean isFirstBatch() {
        return this.isFirstBatch;
    }

    private void isFirstBatch_$eq(boolean x$1) {
        this.isFirstBatch = x$1;
    }

    public ThreadPoolExecutor asyncWritesExecutorService() {
        return this.asyncWritesExecutorService;
    }

    @Override
    public AsyncOffsetSeqLog offsetLog() {
        return this.offsetLog;
    }

    @Override
    public AsyncCommitLog commitLog() {
        return this.commitLog;
    }

    @Override
    public Option<OffsetSeq> validateOffsetLogAndGetPrevOffset(long latestBatchId) {
        Option<Object> prevBatchId = this.offsetLog().getPrevBatchFromStorage(latestBatchId);
        return latestBatchId != 0L && prevBatchId.isDefined() ? new Some(this.offsetLog().get(BoxesRunTime.unboxToLong((Object)prevBatchId.get())).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(26).append("Offset metadata for batch ").append(prevBatchId).toString()).append(" cannot be found.  This should not happen.").toString());
        })) : None$.MODULE$;
    }

    @Override
    public void markMicroBatchExecutionStart() {
        this.checkNotStatefulStreamingQuery();
    }

    @Override
    public void cleanUpLastExecutedMicroBatch() {
    }

    @Override
    public void markMicroBatchStart() {
        Object object = new Object();
        try {
            ((CompletableFuture)this.offsetLog().addAsync(this.currentBatchId(), this.availableOffsets().toOffsetSeq(this.sources(), this.offsetSeqMetadata())).thenAccept(tuple -> {
                block5: {
                    Object object;
                    Tuple2 tuple2 = tuple;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    long batchId = tuple2._1$mcJ$sp();
                    boolean persistedToDurableStorage = tuple2._2$mcZ$sp();
                    Tuple2.mcJZ.sp sp2 = new Tuple2.mcJZ.sp(batchId, persistedToDurableStorage);
                    Tuple2.mcJZ.sp sp3 = sp2;
                    long batchId2 = sp3._1$mcJ$sp();
                    boolean persistedToDurableStorage2 = sp3._2$mcZ$sp();
                    if (!persistedToDurableStorage2) break block5;
                    if (this.lastBatchPersistedToDurableStorage().get() == -1L) {
                        this.lastBatchPersistedToDurableStorage().set(BoxesRunTime.unboxToLong((Object)this.offsetLog().getPrevBatchFromStorage(batchId2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
                    }
                    if (batchId2 != 0L && this.lastBatchPersistedToDurableStorage().get() != -1L) {
                        Predef$.MODULE$.assert(this.lastBatchPersistedToDurableStorage().get() < batchId2);
                        Option prevBatchOff = this.offsetLog().get(this.lastBatchPersistedToDurableStorage().get());
                        if (!prevBatchOff.isDefined()) {
                            throw new IllegalStateException(new StringBuilder(0).append("Failed to commit processed data in the source because batch ").append(new StringBuilder(33).append(this.lastBatchPersistedToDurableStorage().get()).append(" doesn't exist in the offset log.").toString()).append("  This should not happen.").toString());
                        }
                        object = BoxesRunTime.boxToBoolean((boolean)this.sourceCommitQueue().add((OffsetSeq)prevBatchOff.get()));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.lastBatchPersistedToDurableStorage().set(batchId2);
                }
            })).exceptionally(th -> {
                this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Encountered error while performing").append(new StringBuilder(30).append(" async offset write for batch ").append(this.currentBatchId()).toString()).toString(), (Throwable)th);
                this.errorNotifier().markError((Throwable)th);
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            });
            OffsetSeq offset = this.sourceCommitQueue().poll();
            while (offset != null) {
                this.commitSources(offset);
                offset = this.sourceCommitQueue().poll();
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    @Override
    public void markMicroBatchEnd() {
        Object object = new Object();
        try {
            this.watermarkTracker().updateWatermark(this.lastExecution().executedPlan());
            this.reportTimeTaken("commitOffsets", (JFunction0.mcV.sp & Serializable)() -> {
                Object object;
                if (this.offsetLog().getAsyncOffsetWrite(this.currentBatchId()).nonEmpty() || this.isFirstBatch()) {
                    this.isFirstBatch_$eq(false);
                    object = this.commitLog().addAsync(this.currentBatchId(), new CommitMetadata(this.watermarkTracker().currentWatermark())).exceptionally(th -> BoxesRunTime.boxToLong((long)AsyncProgressTrackingMicroBatchExecution.$anonfun$markMicroBatchEnd$2(this, object, th)));
                } else {
                    if (!this.commitLog().addInMemory(this.currentBatchId(), new CommitMetadata(this.watermarkTracker().currentWatermark()))) {
                        throw new IllegalStateException(new StringBuilder(67).append("Concurrent update to the log. Multiple streaming jobs detected for ").append(this.currentBatchId()).toString());
                    }
                    object = BoxedUnit.UNIT;
                }
                this.offsetLog().removeAsyncOffsetWrite(this.currentBatchId());
            });
            this.committedOffsets_$eq((StreamProgress)this.committedOffsets().$plus$plus((IterableOnce)this.availableOffsets()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    @Override
    public void purge(long threshold) {
        while (this.offsetLog().writtenToDurableStorage().size() > this.minLogEntriesToMaintain()) {
            this.offsetLog().writtenToDurableStorage().poll();
        }
        this.offsetLog().purge(BoxesRunTime.unboxToLong((Object)this.offsetLog().writtenToDurableStorage().peek()));
        while (this.commitLog().writtenToDurableStorage().size() > this.minLogEntriesToMaintain()) {
            this.commitLog().writtenToDurableStorage().poll();
        }
        this.commitLog().purge(BoxesRunTime.unboxToLong((Object)this.commitLog().writtenToDurableStorage().peek()));
    }

    @Override
    public void cleanup() {
        super.cleanup();
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.asyncWritesExecutorService(), ThreadUtils$.MODULE$.shutdown$default$2());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Async progress tracking executor pool for query ").append(this.prettyIdString()).append(" has been shutdown").toString());
    }

    public boolean areWritesPendingOrInProgress() {
        return this.asyncWritesExecutorService().getQueue().size() > 0 || this.asyncWritesExecutorService().getActiveCount() > 0;
    }

    private TriggerExecutor validateAndGetTrigger() {
        Trigger trigger;
        block13: {
            if (!StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)this.extraOptions.get((Object)AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_OVERRIDE_SINK_SUPPORT_CHECK()).getOrElse((Function0 & Serializable)() -> "false")))) {
                try {
                    String string = this.plan.sink().name();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1007587933: {
                            if (!"noop-table".equals(string)) break;
                            break block13;
                        }
                        case -373802904: {
                            if (!"KafkaTable".equals(string)) break;
                            break block13;
                        }
                        case -316439724: {
                            if (!"MemorySink".equals(string)) break;
                            break block13;
                        }
                        case 951510359: {
                            if (!"console".equals(string)) break;
                            break block13;
                        }
                    }
                    throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(5).append("Sink ").append(this.plan.sink().name()).toString()).append(" does not support async progress tracking").toString());
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().equals("should not be called.")) {
                        throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(5).append("Sink ").append(this.plan.sink()).toString()).append(" does not support async progress tracking").toString());
                    }
                    throw e;
                }
            }
        }
        if (!((trigger = super.trigger()) instanceof ProcessingTimeTrigger)) {
            if (OneTimeTrigger$.MODULE$.equals(trigger)) {
                throw new IllegalArgumentException("Async progress tracking cannot be used with Once trigger");
            }
            if (AvailableNowTrigger$.MODULE$.equals(trigger)) {
                throw new IllegalArgumentException("Async progress tracking cannot be used with AvailableNow trigger");
            }
            throw new IllegalStateException(new StringBuilder(25).append("Unknown type of trigger: ").append(super.trigger()).toString());
        }
        ProcessingTimeTrigger processingTimeTrigger = (ProcessingTimeTrigger)trigger;
        ProcessingTimeExecutor processingTimeExecutor = new ProcessingTimeExecutor(processingTimeTrigger, super.triggerClock());
        return processingTimeExecutor;
    }

    private void checkNotStatefulStreamingQuery() {
        block0: {
            if (!this.isFirstBatch()) break block0;
            this.lastExecution().executedPlan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof StateStoreWriter) {
                        throw new IllegalArgumentException("Stateful streaming queries does not support async progress tracking at this moment.");
                    }
                    Object object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x1) {
                    SparkPlan sparkPlan = x1;
                    boolean bl = sparkPlan instanceof StateStoreWriter;
                    return bl;
                }
            });
        }
    }

    public static final /* synthetic */ long $anonfun$markMicroBatchEnd$2(AsyncProgressTrackingMicroBatchExecution $this, Object nonLocalReturnKey2$1, Throwable th) {
        $this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Got exception during async write to commit log").append(new StringBuilder(11).append(" for batch ").append($this.currentBatchId()).toString()).toString(), th);
        $this.errorNotifier().markError(th);
        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
    }

    public AsyncProgressTrackingMicroBatchExecution(SparkSession sparkSession, Trigger trigger, Clock triggerClock, Map<String, String> extraOptions, WriteToStream plan) {
        this.extraOptions = extraOptions;
        this.plan = plan;
        super(sparkSession, trigger, triggerClock, extraOptions, plan);
        this.asyncProgressTrackingCheckpointingIntervalMs = AsyncProgressTrackingMicroBatchExecution$.MODULE$.org$apache$spark$sql$execution$streaming$AsyncProgressTrackingMicroBatchExecution$$getAsyncProgressTrackingCheckpointingIntervalMs(extraOptions);
        this.sourceCommitQueue = new ConcurrentLinkedQueue();
        this.lastBatchPersistedToDurableStorage = new AtomicLong(-1L);
        this.triggerExecutor = this.validateAndGetTrigger();
        this.isFirstBatch = true;
        this.asyncWritesExecutorService = ThreadUtils$.MODULE$.newDaemonSingleThreadExecutorWithRejectedExecutionHandler("async-log-write", 2, new RejectedExecutionHandler(this){
            private final /* synthetic */ AsyncProgressTrackingMicroBatchExecution $outer;

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                block3: {
                    try {
                        if (executor.isShutdown()) break block3;
                        long start = System.currentTimeMillis();
                        executor.getQueue().put(r);
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Async write paused execution for ").append(new StringBuilder(30).append(System.currentTimeMillis() - start).append(" due to task queue being full.").toString()).toString());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RejectedExecutionException("Producer interrupted", e);
                    }
                    catch (Throwable e) {
                        this.$outer.logError((Function0<String>)(Function0 & Serializable)() -> "Encountered error in async write executor service", e);
                        this.$outer.errorNotifier().markError(e);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$rejectedExecution$1(long ), $anonfun$rejectedExecution$2()}, serializedLambda);
            }
        });
        this.offsetLog = new AsyncOffsetSeqLog(super.sparkSession(), this.checkpointFile("offsets"), this.asyncWritesExecutorService(), this.asyncProgressTrackingCheckpointingIntervalMs(), super.triggerClock());
        this.commitLog = new AsyncCommitLog(super.sparkSession(), this.checkpointFile("commits"), this.asyncWritesExecutorService());
    }
}

