/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.QueryContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.util.V2ExpressionSQLBuilder;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.connection.ConnectionProvider$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005\u0011\rc!\u0002\u001c8\u0003\u0003\u0011\u0005\"B.\u0001\t\u0003a\u0006\"B0\u0001\r\u0003\u0001\u0007\"\u00028\u0001\t\u0003y\u0007bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\ty\u0006\u0001C\u0001\u0003CBq!a\u001a\u0001\t\u0003\tI\u0007C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u00111\u0010\u0001\u0005\u0002\u0005\u001d\u0005\"CAL\u0001E\u0005I\u0011AAM\u0011\u001d\ti\u000b\u0001C\u0001\u0003_C\u0001\"!2\u0001\t#9\u0014q\u0019\u0005\b\u0003\u001f\u0004A\u0011AAi\r\u001d\ti\u000e\u0001\u00018\u0003?DaaW\b\u0005\u0002\u0005E\bbBA|\u001f\u0011\u0005\u0013\u0011 \u0005\b\u0005;yA\u0011\tB\u0010\u0011\u001d\u0011Yc\u0004C!\u0005[AqAa\u000e\u0010\t\u0003\u0012I\u0004C\u0004\u0003J=!\tEa\u0013\t\u000f\tUs\u0002\"\u0005\u0003X!9!1L\b\u0005B\tu\u0003b\u0002B1\u001f\u0011\u0005#1\r\u0005\u000f\u0005Wz\u0001\u0013aA\u0001\u0002\u0013%!Q\u000eBH\u0011\u001d\u0011\t\n\u0001C\u0001\u0005'CqA!'\u0001\t\u0003\u0011Y\nC\u0004\u0003,\u0002!\tA!,\t\u000f\tU\u0007\u0001\"\u0001\u0003X\"9!1\u001f\u0001\u0005\u0002\tU\bbBB\u0005\u0001\u0011\u000511\u0002\u0005\b\u0007+\u0001A\u0011AB\f\u0011\u001d\u0019y\u0002\u0001C\u0001\u0007CAqaa\t\u0001\t\u0003\u0019)\u0003C\u0004\u00040\u0001!\ta!\r\t\u000f\r%\u0003\u0001\"\u0001\u0004L!91Q\u000b\u0001\u0005\u0002\r]\u0003bBB2\u0001\u0011\u00051Q\r\u0005\b\u0007W\u0002A\u0011AB7\u0011\u001d\u00199\b\u0001C\u0001\u0007sBqaa!\u0001\t\u0003\u0019)\tC\u0004\u0004\f\u0002!\ta!$\t\u000f\rM\u0005\u0001\"\u0001\u0004\u0016\"91\u0011\u0014\u0001\u0005\u0002\rm\u0005bBBQ\u0001\u0011\u000511\u0015\u0005\b\u0007\u0013\u0004A\u0011ABf\u0011\u001d\u0019)\u000e\u0001C\u0001\u0007/Dqa!8\u0001\t\u0003\u0019y\u000eC\u0004\u0004v\u0002!\taa>\t\u000f\u00115\u0001\u0001\"\u0001\u0005\u0010!9A1\u0004\u0001\u0005\u0002\u0011u\u0001b\u0002C\u0012\u0001\u0011\u0005AQ\u0005\u0005\b\tO\u0001A\u0011\u0001C\u0015\u0005-QEMY2ES\u0006dWm\u0019;\u000b\u0005aJ\u0014\u0001\u00026eE\u000eT!AO\u001e\u0002\u0007M\fHN\u0003\u0002={\u0005)1\u000f]1sW*\u0011ahP\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\u000b1a\u001c:h\u0007\u0001\u0019B\u0001A\"J+B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n1\u0011I\\=SK\u001a\u0004\"A\u0013*\u000f\u0005-\u0003fB\u0001'P\u001b\u0005i%B\u0001(B\u0003\u0019a$o\\8u}%\ta)\u0003\u0002R\u000b\u00069\u0001/Y2lC\u001e,\u0017BA*U\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\tV\t\u0005\u0002W36\tqK\u0003\u0002Yw\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002[/\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001^!\tq\u0006!D\u00018\u0003%\u0019\u0017M\u001c%b]\u0012dW\r\u0006\u0002bIB\u0011AIY\u0005\u0003G\u0016\u0013qAQ8pY\u0016\fg\u000eC\u0003f\u0005\u0001\u0007a-A\u0002ve2\u0004\"aZ6\u000f\u0005!L\u0007C\u0001'F\u0013\tQW)\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016F\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,Gc\u00029z}\u0006\u0005\u0011Q\u0001\t\u0004\tF\u001c\u0018B\u0001:F\u0005\u0019y\u0005\u000f^5p]B\u0011Ao^\u0007\u0002k*\u0011a/O\u0001\u0006if\u0004Xm]\u0005\u0003qV\u0014\u0001\u0002R1uCRK\b/\u001a\u0005\u0006u\u000e\u0001\ra_\u0001\bgFdG+\u001f9f!\t!E0\u0003\u0002~\u000b\n\u0019\u0011J\u001c;\t\u000b}\u001c\u0001\u0019\u00014\u0002\u0011QL\b/\u001a(b[\u0016Da!a\u0001\u0004\u0001\u0004Y\u0018\u0001B:ju\u0016Dq!a\u0002\u0004\u0001\u0004\tI!\u0001\u0002nIB\u0019A/a\u0003\n\u0007\u00055QOA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u0003-9W\r\u001e&E\u0005\u000e#\u0016\u0010]3\u0015\t\u0005M\u00111\u0004\t\u0005\tF\f)\u0002E\u0002_\u0003/I1!!\u00078\u0005!QEMY2UsB,\u0007BBA\u000f\t\u0001\u00071/\u0001\u0002ei\u000692M]3bi\u0016\u001cuN\u001c8fGRLwN\u001c$bGR|'/\u001f\u000b\u0005\u0003G\t9\u0004\u0005\u0004E\u0003KY\u0018\u0011F\u0005\u0004\u0003O)%!\u0003$v]\u000e$\u0018n\u001c82!\u0011\tY#a\r\u000e\u0005\u00055\"b\u0001\u001e\u00020)\u0011\u0011\u0011G\u0001\u0005U\u00064\u0018-\u0003\u0003\u00026\u00055\"AC\"p]:,7\r^5p]\"9\u0011\u0011H\u0003A\u0002\u0005m\u0012aB8qi&|gn\u001d\t\u0005\u0003{\tI%\u0004\u0002\u0002@)\u0019\u0001(!\u0011\u000b\t\u0005\r\u0013QI\u0001\fI\u0006$\u0018m]8ve\u000e,7OC\u0002\u0002He\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\u0005-\u0013q\b\u0002\f\u0015\u0012\u00135i\u00149uS>t7\u000fK\u0003\u0006\u0003\u001f\nY\u0006\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)fO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA-\u0003'\u0012QaU5oG\u0016\f#!!\u0018\u0002\u000bMr3G\f\u0019\u0002\u001fE,x\u000e^3JI\u0016tG/\u001b4jKJ$2AZA2\u0011\u0019\t)G\u0002a\u0001M\u000691m\u001c7OC6,\u0017aE4fiR\u000b'\r\\3Fq&\u001cHo])vKJLHc\u00014\u0002l!1\u0011QN\u0004A\u0002\u0019\fQ\u0001^1cY\u0016\fabZ3u'\u000eDW-\\1Rk\u0016\u0014\u0018\u0010F\u0002g\u0003gBa!!\u001c\t\u0001\u00041\u0007&\u0002\u0005\u0002P\u0005]\u0014EAA=\u0003\u0015\u0011d&\r\u00181\u0003A9W\r\u001e+sk:\u001c\u0017\r^3Rk\u0016\u0014\u0018\u0010F\u0002g\u0003\u007fBa!!\u001c\n\u0001\u00041\u0007&B\u0005\u0002P\u0005\r\u0015EAAC\u0003\u0015\u0011df\r\u00181)\u00151\u0017\u0011RAF\u0011\u0019\tiG\u0003a\u0001M\"I\u0011Q\u0012\u0006\u0011\u0002\u0003\u0007\u0011qR\u0001\bG\u0006\u001c8-\u00193f!\r!\u0015/\u0019\u0015\u0006\u0015\u0005=\u00131S\u0011\u0003\u0003+\u000bQA\r\u00185]A\n!dZ3u)J,hnY1uKF+XM]=%I\u00164\u0017-\u001e7uII*\"!a'+\t\u0005=\u0015QT\u0016\u0003\u0003?\u0003B!!)\u0002*6\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+A\u0005v]\u000eDWmY6fI*\u0019\u0011QK#\n\t\u0005-\u00161\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00032fM>\u0014XMR3uG\"$b!!-\u00028\u0006m\u0006c\u0001#\u00024&\u0019\u0011QW#\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003sc\u0001\u0019AA\u0015\u0003)\u0019wN\u001c8fGRLwN\u001c\u0005\b\u0003{c\u0001\u0019AA`\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0006O\u0006\u0005gMZ\u0005\u0004\u0003\u0007l'aA'ba\u0006IQm]2ba\u0016\u001c\u0016\u000f\u001c\u000b\u0004M\u0006%\u0007BBAf\u001b\u0001\u0007a-A\u0003wC2,X\rK\u0003\u000e\u0003\u001f\n\u0019)\u0001\u0007d_6\u0004\u0018\u000e\\3WC2,X\r\u0006\u0003\u0002T\u0006e\u0007c\u0001#\u0002V&\u0019\u0011q[#\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002L:\u0001\r!a5)\u000b9\ty%a!\u0003\u001d)#%iQ*R\u0019\n+\u0018\u000e\u001c3feN\u0019q\"!9\u0011\t\u0005\r\u0018Q^\u0007\u0003\u0003KTA!a:\u0002j\u0006!Q\u000f^5m\u0015\r\tY/O\u0001\nG>tg.Z2u_JLA!a<\u0002f\n1bKM#yaJ,7o]5p]N\u000bFJQ;jY\u0012,'\u000f\u0006\u0002\u0002tB\u0019\u0011Q_\b\u000e\u0003\u0001\tAB^5tSRd\u0015\u000e^3sC2$2AZA~\u0011\u001d\ti0\u0005a\u0001\u0003\u007f\fq\u0001\\5uKJ\fG\u000e\r\u0003\u0003\u0002\tE\u0001C\u0002B\u0002\u0005\u0013\u0011i!\u0004\u0002\u0003\u0006)!!qAAu\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\t-!Q\u0001\u0002\b\u0019&$XM]1m!\u0011\u0011yA!\u0005\r\u0001\u0011a!1CA~\u0003\u0003\u0005\tQ!\u0001\u0003\u0016\t\u0019q\fJ\u0019\u0012\t\t]\u00111\u001b\t\u0004\t\ne\u0011b\u0001B\u000e\u000b\n9aj\u001c;iS:<\u0017a\u0005<jg&$h*Y7fIJ+g-\u001a:f]\u000e,Gc\u00014\u0003\"!9!1\u0005\nA\u0002\t\u0015\u0012\u0001\u00038b[\u0016$'+\u001a4\u0011\t\t\r!qE\u0005\u0005\u0005S\u0011)A\u0001\bOC6,GMU3gKJ,gnY3\u0002\u0013YL7/\u001b;DCN$H#\u00024\u00030\tM\u0002B\u0002B\u0019'\u0001\u0007a-A\u0001m\u0011\u0019\u0011)d\u0005a\u0001g\u0006AA-\u0019;b)f\u0004X-\u0001\twSNLGoU)M\rVt7\r^5p]R)aMa\u000f\u0003@!1!Q\b\u000bA\u0002\u0019\f\u0001BZ;oG:\u000bW.\u001a\u0005\b\u0005\u0003\"\u0002\u0019\u0001B\"\u0003\u0019Ig\u000e];ugB!AI!\u0012g\u0013\r\u00119%\u0012\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0017m&\u001c\u0018\u000e^!hOJ,w-\u0019;f\rVt7\r^5p]R9aM!\u0014\u0003P\tM\u0003B\u0002B\u001f+\u0001\u0007a\r\u0003\u0004\u0003RU\u0001\r!Y\u0001\u000bSN$\u0015n\u001d;j]\u000e$\bb\u0002B!+\u0001\u0007!1I\u0001\u0014I&\fG.Z2u\rVt7\r^5p]:\u000bW.\u001a\u000b\u0004M\ne\u0003B\u0002B\u001f-\u0001\u0007a-\u0001\u0007wSNLGo\u0014<fe2\f\u0017\u0010F\u0002g\u0005?BqA!\u0011\u0018\u0001\u0004\u0011\u0019%A\u0005wSNLG\u000f\u0016:j[R)aM!\u001a\u0003j!1!q\r\rA\u0002\u0019\f\u0011\u0002Z5sK\u000e$\u0018n\u001c8\t\u000f\t\u0005\u0003\u00041\u0001\u0003D\u0005\u00112/\u001e9fe\u00122\u0018n]5u\u0019&$XM]1m)\u0011\u0011yG!\u001f\u0011\t\tE$qO\u0007\u0003\u0005gRAA!\u001e\u00020\u0005!A.\u00198h\u0013\ra'1\u000f\u0005\n\u0005wJ\u0012\u0011!a\u0001\u0005{\n1\u0001\u001f\u00132a\u0011\u0011yHa!\u0011\r\t\r!\u0011\u0002BA!\u0011\u0011yAa!\u0005\u0019\t\u0015%\u0011PA\u0001\u0002\u0003\u0015\tAa\"\u0003\u0005}\u0002\u0014\u0003\u0002B\f\u0005\u0013\u0003BA!\u001d\u0003\f&!!Q\u0012B:\u0005\u0019y%M[3di&!\u0011q_Aw\u0003MI7oU;qa>\u0014H/\u001a3Gk:\u001cG/[8o)\r\t'Q\u0013\u0005\u0007\u0005{Q\u0002\u0019\u00014)\u000bi\ty%a\u0017\u0002#\r|W\u000e]5mK\u0016C\bO]3tg&|g\u000e\u0006\u0003\u0003\u001e\n}\u0005c\u0001#rM\"9!\u0011U\u000eA\u0002\t\r\u0016\u0001B3yaJ\u0004BAa\u0001\u0003&&!!q\u0015B\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0015\u00067\u0005=\u00131L\u0001\u0011G>l\u0007/\u001b7f\u0003\u001e<'/Z4bi\u0016$BA!(\u00030\"9!\u0011\u0017\u000fA\u0002\tM\u0016aC1hO\u001a+hn\u0019;j_:\u0004BA!.\u0003<6\u0011!q\u0017\u0006\u0005\u0005s\u0013)!A\u0005bO\u001e\u0014XmZ1uK&!!Q\u0018B\\\u00055\tum\u001a:fO\u0006$XMR;oG\"ZAD!1\u0003H\n%'Q\u001aBh!\r!%1Y\u0005\u0004\u0005\u000b,%A\u00033faJ,7-\u0019;fI\u00069Q.Z:tC\u001e,\u0017E\u0001Bf\u0003\u0011+8/\u001a\u0011pe\u001et\u0013\r]1dQ\u0016t3\u000f]1sW:\u001a\u0018\u000f\u001c\u0018kI\n\u001cgF\u00133cG\u0012K\u0017\r\\3di:\u001aw.\u001c9jY\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0011j]N$X-\u00193/\u0003\u0015\u0019\u0018N\\2fC\t\u0011\t.A\u00034]Qr\u0003\u0007K\u0003\u001d\u0003\u001f\nY&A\u0005gk:\u001cG/[8ogV\u0011!\u0011\u001c\t\u0006\u0015\nm'q\\\u0005\u0004\u0005;$&aA*fcB1AI!9g\u0005KL1Aa9F\u0005\u0019!V\u000f\u001d7feA!!q\u001dBx\u001b\t\u0011IO\u0003\u0003\u0003V\n-(\u0002\u0002Bw\u0003S\fqaY1uC2|w-\u0003\u0003\u0003r\n%(aD+oE>,h\u000e\u001a$v]\u000e$\u0018n\u001c8\u0002\u0019\r\u0014X-\u0019;f'\u000eDW-\\1\u0015\u0011\u0005E&q_B\u0001\u0007\u000bAqA!?\u001f\u0001\u0004\u0011Y0A\u0005ti\u0006$X-\\3oiB!\u00111\u0006B\u007f\u0013\u0011\u0011y0!\f\u0003\u0013M#\u0018\r^3nK:$\bBBB\u0002=\u0001\u0007a-\u0001\u0004tG\",W.\u0019\u0005\u0007\u0007\u000fq\u0002\u0019\u00014\u0002\u000f\r|W.\\3oi\u0006i1o\u00195f[\u0006\u001cX\t_5tiN$r!YB\u0007\u0007#\u0019\u0019\u0002C\u0004\u0004\u0010}\u0001\r!!\u000b\u0002\t\r|gN\u001c\u0005\b\u0003sy\u0002\u0019AA\u001e\u0011\u0019\u0019\u0019a\ba\u0001M\u0006YA.[:u'\u000eDW-\\1t)\u0019\u0019Iba\u0007\u0004\u001eA)AI!\u0012\u0003D!91q\u0002\u0011A\u0002\u0005%\u0002bBA\u001dA\u0001\u0007\u00111H\u0001\u0019SN\u001c\u0015m]2bI&tw\r\u0016:v]\u000e\fG/\u001a+bE2,GCAAH\u0003-\u0011XM\\1nKR\u000b'\r\\3\u0015\u000b\u0019\u001c9ca\u000b\t\r\r%\"\u00051\u0001g\u0003!yG\u000e\u001a+bE2,\u0007BBB\u0017E\u0001\u0007a-\u0001\u0005oK^$\u0016M\u00197f\u0003)\tG\u000e^3s)\u0006\u0014G.\u001a\u000b\t\u0005\u0007\u001a\u0019da\u000e\u0004F!11QG\u0012A\u0002\u0019\f\u0011\u0002^1cY\u0016t\u0015-\\3\t\u000f\re2\u00051\u0001\u0004<\u000591\r[1oO\u0016\u001c\b#\u0002&\u0003\\\u000eu\u0002\u0003BB \u0007\u0003j!Aa;\n\t\r\r#1\u001e\u0002\f)\u0006\u0014G.Z\"iC:<W\r\u0003\u0004\u0004H\r\u0002\ra_\u0001\u000fI\nl\u0015M[8s-\u0016\u00148/[8o\u0003E9W\r^!eI\u000e{G.^7o#V,'/\u001f\u000b\bM\u000e53qJB*\u0011\u0019\u0019)\u0004\na\u0001M\"11\u0011\u000b\u0013A\u0002\u0019\f!bY8mk6tg*Y7f\u0011\u0019\u0011)\u0004\na\u0001M\u0006!r-\u001a;SK:\fW.Z\"pYVlg.U;fef$\u0012BZB-\u00077\u001aif!\u0019\t\r\rUR\u00051\u0001g\u0011\u0019\u0019\t&\na\u0001M\"11qL\u0013A\u0002\u0019\fqA\\3x\u001d\u0006lW\r\u0003\u0004\u0004H\u0015\u0002\ra_\u0001\u0015O\u0016$H)\u001a7fi\u0016\u001cu\u000e\\;n]F+XM]=\u0015\u000b\u0019\u001c9g!\u001b\t\r\rUb\u00051\u0001g\u0011\u0019\u0019\tF\na\u0001M\u0006Ar-\u001a;Va\u0012\fG/Z\"pYVlg\u000eV=qKF+XM]=\u0015\u000f\u0019\u001cyg!\u001d\u0004t!11QG\u0014A\u0002\u0019Daa!\u0015(\u0001\u00041\u0007BBB;O\u0001\u0007a-A\u0006oK^$\u0015\r^1UsB,\u0017aH4fiV\u0003H-\u0019;f\u0007>dW/\u001c8Ok2d\u0017MY5mSRL\u0018+^3ssR9ama\u001f\u0004~\r}\u0004BBB\u001bQ\u0001\u0007a\r\u0003\u0004\u0004R!\u0002\rA\u001a\u0005\u0007\u0007\u0003C\u0003\u0019A1\u0002\u0015%\u001ch*\u001e7mC\ndW-\u0001\u000bhKR$\u0016M\u00197f\u0007>lW.\u001a8u#V,'/\u001f\u000b\u0006M\u000e\u001d5\u0011\u0012\u0005\u0007\u0003[J\u0003\u0019\u00014\t\r\r\u001d\u0011\u00061\u0001g\u0003U9W\r^*dQ\u0016l\u0017mQ8n[\u0016tG/U;fef$RAZBH\u0007#Caaa\u0001+\u0001\u00041\u0007BBB\u0004U\u0001\u0007a-\u0001\rsK6|g/Z*dQ\u0016l\u0017mQ8n[\u0016tG/U;fef$2AZBL\u0011\u0019\u0019\u0019a\u000ba\u0001M\u0006QAM]8q'\u000eDW-\\1\u0015\u000b\u0019\u001cija(\t\r\r\rA\u00061\u0001g\u0011\u0019\ti\t\fa\u0001C\u0006Y1M]3bi\u0016Le\u000eZ3y)-17QUBU\u0007g\u001bIla2\t\r\r\u001dV\u00061\u0001g\u0003%Ig\u000eZ3y\u001d\u0006lW\rC\u0004\u0004,6\u0002\ra!,\u0002\u0015Q\f'\r\\3JI\u0016tG\u000f\u0005\u0003\u0004@\r=\u0016\u0002BBY\u0005W\u0014!\"\u00133f]RLg-[3s\u0011\u001d\u0019),\fa\u0001\u0007o\u000bqaY8mk6t7\u000fE\u0003E\u0005\u000b\u0012)\u0003C\u0004\u0004<6\u0002\ra!0\u0002#\r|G.^7ogB\u0013x\u000e]3si&,7\u000f\u0005\u0005\u0004@\u000e\r'QEBc\u001b\t\u0019\tM\u0003\u0003\u0002h\u0006=\u0012\u0002BAb\u0007\u0003\u0004baa0\u0004D\u001a4\u0007bBA_[\u0001\u00071QY\u0001\fS:$W\r_#ySN$8\u000fF\u0005b\u0007\u001b\u001cym!5\u0004T\"91q\u0002\u0018A\u0002\u0005%\u0002BBBT]\u0001\u0007a\rC\u0004\u0004,:\u0002\ra!,\t\u000f\u0005eb\u00061\u0001\u0002<\u0005IAM]8q\u0013:$W\r\u001f\u000b\u0006M\u000ee71\u001c\u0005\u0007\u0007O{\u0003\u0019\u00014\t\u000f\r-v\u00061\u0001\u0004.\u0006YA.[:u\u0013:$W\r_3t)!\u0019\toa<\u0004r\u000eM\b#\u0002#\u0003F\r\r\b\u0003BBs\u0007Wl!aa:\u000b\t\r%(1^\u0001\u0006S:$W\r_\u0005\u0005\u0007[\u001c9O\u0001\u0006UC\ndW-\u00138eKbDqaa\u00041\u0001\u0004\tI\u0003C\u0004\u0004,B\u0002\ra!,\t\u000f\u0005e\u0002\u00071\u0001\u0002<\u0005\t2\r\\1tg&4\u00170\u0012=dKB$\u0018n\u001c8\u0015\r\reH\u0011\u0001C\u0002!\u0011\u0019Yp!@\u000e\u0003eJ1aa@:\u0005E\te.\u00197zg&\u001cX\t_2faRLwN\u001c\u0005\u0007\u0005\u000f\f\u0004\u0019\u00014\t\u000f\u0011\u0015\u0011\u00071\u0001\u0005\b\u0005\tQ\rE\u0002K\t\u0013I1\u0001b\u0003U\u0005%!\u0006N]8xC\ndW-\u0001\bhKRd\u0015.\\5u\u00072\fWo]3\u0015\u0007\u0019$\t\u0002C\u0004\u0005\u0014I\u0002\r\u0001\"\u0006\u0002\u000b1LW.\u001b;\u0011\t\tEDqC\u0005\u0005\t3\u0011\u0019HA\u0004J]R,w-\u001a:\u0002\u001f\u001d,Go\u00144gg\u0016$8\t\\1vg\u0016$2A\u001aC\u0010\u0011\u001d!\tc\ra\u0001\t+\taa\u001c4gg\u0016$\u0018aE:vaB|'\u000f^:UC\ndWmU1na2,W#A1\u0002\u001d\u001d,G\u000fV1cY\u0016\u001c\u0016-\u001c9mKR\u0019a\rb\u000b\t\u000f\u00115R\u00071\u0001\u00050\u000511/Y7qY\u0016\u0004B\u0001\"\r\u000585\u0011A1\u0007\u0006\u0005\tk\t\t%\u0001\u0002we%!A\u0011\bC\u001a\u0005=!\u0016M\u00197f'\u0006l\u0007\u000f\\3J]\u001a|\u0007f\u0001\u0001\u0005>A!\u0011\u0011\u000bC \u0013\u0011!\t%a\u0015\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5")
public abstract class JdbcDialect
implements Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract boolean canHandle(String var1);

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return None$.MODULE$;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        return None$.MODULE$;
    }

    public Function1<Object, Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return (Function1 & Serializable)partitionId -> JdbcDialect.$anonfun$createConnectionFactory$1(driverClass, options, BoxesRunTime.unboxToInt((Object)partitionId));
    }

    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("\"").append(colName).append("\"").toString();
    }

    public String getTableExistsQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getSchemaQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getTruncateQuery(String table) {
        return this.getTruncateQuery(table, this.isCascadingTruncateTable());
    }

    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
    }

    public String escapeSql(String value) {
        return value == null ? null : StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public Object compileValue(Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder(2).append("'").append(timestamp).append("'").toString();
        } else if (object2 instanceof Instant) {
            Instant instant = (Instant)object2;
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            object = new StringBuilder(2).append("'").append(timestampFormatter.format(instant)).append("'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder(2).append("'").append(date).append("'").toString();
        } else if (object2 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object2;
            object = new StringBuilder(2).append("'").append(DateFormatter$.MODULE$.apply().format(localDate)).append("'").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)value -> this.compileValue(value), ClassTag$.MODULE$.Any())).mkString(", ");
        } else {
            object = value2;
        }
        return object;
    }

    public boolean isSupportedFunction(String funcName) {
        return false;
    }

    public Option<String> compileExpression(Expression expr) {
        Some some;
        JDBCSQLBuilder jdbcSQLBuilder = new JDBCSQLBuilder();
        try {
            some = new Some((Object)jdbcSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", e);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return this.compileExpression((Expression)aggFunction);
    }

    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return package$.MODULE$.Nil();
    }

    public void createSchema(Statement statement, String schema, String comment) {
        block0: {
            String schemaCommentQuery = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(comment)) ? this.getSchemaCommentQuery(schema, comment) : comment;
            statement.executeUpdate(new StringBuilder(14).append("CREATE SCHEMA ").append(this.quoteIdentifier(schema)).toString());
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(comment))) break block0;
            statement.executeUpdate(schemaCommentQuery);
        }
    }

    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        ResultSet rs = conn.getMetaData().getSchemas(null, schema);
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        ResultSet rs = conn.getMetaData().getSchemas();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public Option<Object> isCascadingTruncateTable() {
        return None$.MODULE$;
    }

    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(oldTable).append(" RENAME TO ").append(newTable).toString();
    }

    public String[] alterTable(String tableName, Seq<TableChange> changes, int dbMajorVersion) {
        ArrayBuilder updateClause = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        changes.foreach((Function1 & Serializable)change -> {
            TableChange.UpdateColumnNullability updateColumnNullability;
            TableChange.UpdateColumnType updateColumnType;
            TableChange.DeleteColumn deleteColumn;
            TableChange.RenameColumn renameColumn;
            ArrayBuilder arrayBuilder;
            TableChange.AddColumn addColumn;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn && (addColumn = (TableChange.AddColumn)tableChange).fieldNames().length == 1) {
                String dataType = JdbcUtils$.MODULE$.getJdbcType(addColumn.dataType(), this).databaseTypeDefinition();
                String[] name = addColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getAddColumnQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.RenameColumn && (renameColumn = (TableChange.RenameColumn)tableChange).fieldNames().length == 1) {
                String[] name = renameColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getRenameColumnQuery(tableName, name[0], renameColumn.newName(), dbMajorVersion));
            } else if (tableChange instanceof TableChange.DeleteColumn && (deleteColumn = (TableChange.DeleteColumn)tableChange).fieldNames().length == 1) {
                String[] name = deleteColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getDeleteColumnQuery(tableName, name[0]));
            } else if (tableChange instanceof TableChange.UpdateColumnType && (updateColumnType = (TableChange.UpdateColumnType)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnType.fieldNames();
                String dataType = JdbcUtils$.MODULE$.getJdbcType(updateColumnType.newDataType(), this).databaseTypeDefinition();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnTypeQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.UpdateColumnNullability && (updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnNullability.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnNullabilityQuery(tableName, name[0], updateColumnNullability.nullable()));
            } else {
                throw QueryCompilationErrors$.MODULE$.unsupportedTableChangeInJDBCCatalogError(change);
            }
            return arrayBuilder;
        });
        return (String[])updateClause.result();
    }

    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(0).append(new StringBuilder(30).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").toString()).append(new StringBuilder(1).append(" ").append(this.quoteIdentifier(newName)).toString()).toString();
    }

    public String getDeleteColumnQuery(String tableName, String columnName) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(this.quoteIdentifier(columnName)).toString();
    }

    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET ").append(nullable).toString();
    }

    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(23).append("COMMENT ON TABLE ").append(table).append(" IS '").append(comment).append("'").toString();
    }

    public String getSchemaCommentQuery(String schema, String comment) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS '").append(comment).append("'").toString();
    }

    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(26).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS NULL").toString();
    }

    public String dropSchema(String schema, boolean cascade) {
        return cascade ? new StringBuilder(20).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" CASCADE").toString() : new StringBuilder(12).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).toString();
    }

    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        throw new UnsupportedOperationException("createIndex is not supported");
    }

    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("indexExists is not supported");
    }

    public String dropIndex(String indexName, Identifier tableIdent) {
        throw new UnsupportedOperationException("dropIndex is not supported");
    }

    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("listIndexes is not supported");
    }

    public AnalysisException classifyException(String message, Throwable e) {
        String x$1 = message;
        Some x$2 = new Some((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        Option x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        scala.collection.immutable.Map x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        QueryContext[] x$8 = AnalysisException$.MODULE$.$lessinit$greater$default$8();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option)x$2, x$6, x$7, x$8);
    }

    public String getLimitClause(Integer limit) {
        return Predef$.MODULE$.Integer2int(limit) > 0 ? new StringBuilder(6).append("LIMIT ").append(limit).toString() : "";
    }

    public String getOffsetClause(Integer offset) {
        return Predef$.MODULE$.Integer2int(offset) > 0 ? new StringBuilder(7).append("OFFSET ").append(offset).toString() : "";
    }

    public boolean supportsTableSample() {
        return false;
    }

    public String getTableSample(TableSampleInfo sample) {
        throw new UnsupportedOperationException("TableSample is not supported by this data source");
    }

    public static final /* synthetic */ Connection $anonfun$createConnectionFactory$1(String driverClass$1, JDBCOptions options$1, int partitionId) {
        DriverRegistry$.MODULE$.register(driverClass$1);
        Driver driver = DriverRegistry$.MODULE$.get(driverClass$1);
        Connection connection = ConnectionProvider$.MODULE$.create(driver, (scala.collection.immutable.Map<String, String>)options$1.parameters(), options$1.connectionProviderName());
        Predef$.MODULE$.require(connection != null, (Function0 & Serializable)() -> new StringBuilder(60).append("The driver could not open a JDBC connection. Check the URL: ").append(options$1.url()).toString());
        return connection;
    }

    public JdbcDialect() {
        Logging.$init$((Logging)this);
    }

    public class JDBCSQLBuilder
    extends V2ExpressionSQLBuilder {
        private /* synthetic */ String super$visitLiteral(Literal x$1) {
            return super.visitLiteral(x$1);
        }

        public String visitLiteral(Literal<?> literal) {
            return (String)Option$.MODULE$.apply(literal.value()).map((Function1 & Serializable)v -> this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().compileValue(CatalystTypeConverters$.MODULE$.convertToScala(v, literal.dataType())).toString()).getOrElse((Function0 & Serializable)() -> this.super$visitLiteral(literal));
        }

        public String visitNamedReference(NamedReference namedRef) {
            if (namedRef.fieldNames().length > 1) {
                throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("Filter push down", namedRef.toString());
            }
            return this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namedRef.fieldNames())));
        }

        public String visitCast(String l, DataType dataType) {
            String databaseTypeDefinition = (String)this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().getJDBCType(dataType).map((Function1 & Serializable)x$1 -> x$1.databaseTypeDefinition()).getOrElse((Function0 & Serializable)() -> dataType.typeName());
            return new StringBuilder(10).append("CAST(").append(l).append(" AS ").append(databaseTypeDefinition).append(")").toString();
        }

        public String visitSQLFunction(String funcName, String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                throw new UnsupportedOperationException(new StringBuilder(28).append(this.getClass().getSimpleName()).append(" does not support function: ").append(funcName).toString());
            }
            return new StringBuilder(2).append(this.dialectFunctionName(funcName)).append("(").append(Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(", ")).append(")").toString();
        }

        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                throw new UnsupportedOperationException(new StringBuilder(38).append(this.getClass().getSimpleName()).append(" does not support aggregate function: ").append(funcName).toString());
            }
            return super.visitAggregateFunction(this.dialectFunctionName(funcName), isDistinct, inputs);
        }

        public String dialectFunctionName(String funcName) {
            return funcName;
        }

        public String visitOverlay(String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("OVERLAY")) {
                throw new UnsupportedOperationException(new StringBuilder(35).append(this.getClass().getSimpleName()).append(" does not support function: OVERLAY").toString());
            }
            return super.visitOverlay(inputs);
        }

        public String visitTrim(String direction, String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("TRIM")) {
                throw new UnsupportedOperationException(new StringBuilder(32).append(this.getClass().getSimpleName()).append(" does not support function: TRIM").toString());
            }
            return super.visitTrim(direction, inputs);
        }

        public /* synthetic */ JdbcDialect org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer() {
            return JdbcDialect.this;
        }

        public JDBCSQLBuilder() {
            if (JdbcDialect.this == null) {
                throw null;
            }
        }
    }
}

