/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.LongDelta$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t]qA\u0002\u0015*\u0011\u0003[sG\u0002\u0004:S!\u00055F\u000f\u0005\u0006)\u0006!\t!\u0016\u0005\u0006-\u0006!\te\u0016\u0005\u00067\u0006!\t\u0005\u0018\u0005\b\u0003\u0007\tA\u0011IA\u0003\u0011\u001d\t9\"\u0001C!\u000331a!!\u0004\u0002\u0001\u0005e\u0002B\u0002+\b\t\u0003\t\u0019\u0005\u0003\u0005\u0002J\u001d\u0001\r\u0011\"\u0005X\u0011%\tYe\u0002a\u0001\n#\ti\u0005C\u0004\u0002Z\u001d\u0001\u000b\u0015\u0002-\t\u0011\u0005ms\u00011A\u0005\u0012]C\u0011\"!\u0018\b\u0001\u0004%\t\"a\u0018\t\u000f\u0005\rt\u0001)Q\u00051\"1\u0011QM\u0004\u0005B]Ca!a\u001a\b\t\u0003:\u0006bCA5\u000f\u0001\u0007\t\u0019!C\u0005\u0003WB1\"a\u001d\b\u0001\u0004\u0005\r\u0011\"\u0003\u0002v!Y\u0011\u0011P\u0004A\u0002\u0003\u0005\u000b\u0015BA7\u0011\u001d\tYh\u0002C!\u0003{Bq!a$\b\t\u0003\n\tJB\u0003a\u0003\u0001\tY\n\u0003\u0005s-\t\u0005\t\u0015!\u0003t\u0011%ahC!A!\u0002\u0013\ty\n\u0003\u0004U-\u0011\u0005\u0011\u0011\u0015\u0005\f\u0003S3\u0002\u0019!a\u0001\n\u0013\tY\u0007C\u0006\u0002,Z\u0001\r\u00111A\u0005\n\u00055\u0006bCAY-\u0001\u0007\t\u0011)Q\u0005\u0003[Bq!a-\u0017\t\u0003\n)\fC\u0004\u00028Z!\t%!/\t\u000f\u0005}f\u0003\"\u0011\u0002B\"I\u0011q[\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u001c\u0005\t\u0003O\f\u0011\u0011!C\u0001/\"I\u0011\u0011^\u0001\u0002\u0002\u0013\u0005\u00111\u001e\u0005\n\u0003_\f\u0011\u0011!C!\u0003cD\u0011\"a@\u0002\u0003\u0003%\tA!\u0001\t\u0013\t\u0015\u0011!!A\u0005B\t\u001d\u0001\"\u0003B\u0005\u0003\u0005\u0005I\u0011\tB\u0006\u0011%\u0011i!AA\u0001\n\u0013\u0011y!A\u0005M_:<G)\u001a7uC*\u0011!fK\u0001\fG>l\u0007O]3tg&|gN\u0003\u0002-[\u0005A1m\u001c7v[:\f'O\u0003\u0002/_\u0005IQ\r_3dkRLwN\u001c\u0006\u0003aE\n1a]9m\u0015\t\u00114'A\u0003ta\u0006\u00148N\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<\u0007C\u0001\u001d\u0002\u001b\u0005I#!\u0003'p]\u001e$U\r\u001c;b'\u0015\t1(\u0011#H!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0019\te.\u001f*fMB\u0011\u0001HQ\u0005\u0003\u0007&\u0012\u0011cQ8naJ,7o]5p]N\u001b\u0007.Z7f!\taT)\u0003\u0002G{\t9\u0001K]8ek\u000e$\bC\u0001%R\u001d\tIuJ\u0004\u0002K\u001d6\t1J\u0003\u0002M\u001b\u00061AH]8piz\u001a\u0001!C\u0001?\u0013\t\u0001V(A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001b&\u0001D*fe&\fG.\u001b>bE2,'B\u0001)>\u0003\u0019a\u0014N\\5u}Q\tq'\u0001\u0004usB,\u0017\nZ\u000b\u00021B\u0011A(W\u0005\u00035v\u00121!\u00138u\u0003\u001d!WmY8eKJ,\"!X2\u0015\u0007y\u000b8\u0010E\u00029?\u0006L!\u0001Y\u0015\u0003\u000f\u0011+7m\u001c3feB\u0011!m\u0019\u0007\u0001\t\u0015!GA1\u0001f\u0005\u0005!\u0016C\u00014j!\tat-\u0003\u0002i{\t9aj\u001c;iS:<\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003\u0015!\u0018\u0010]3t\u0015\tqw&\u0001\u0005dCR\fG._:u\u0013\t\u00018N\u0001\tQQf\u001c\u0018nY1m\t\u0006$\u0018\rV=qK\")!\u000f\u0002a\u0001g\u00061!-\u001e4gKJ\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\u00079LwNC\u0001y\u0003\u0011Q\u0017M^1\n\u0005i,(A\u0003\"zi\u0016\u0014UO\u001a4fe\")A\u0010\u0002a\u0001{\u0006Q1m\u001c7v[:$\u0016\u0010]3\u0011\u0007y|\u0018-D\u0001,\u0013\r\t\ta\u000b\u0002\u0011\u001d\u0006$\u0018N^3D_2,XN\u001c+za\u0016\fq!\u001a8d_\u0012,'/\u0006\u0003\u0002\b\u0005EA\u0003BA\u0005\u0003'\u0001R\u0001OA\u0006\u0003\u001fI1!!\u0004*\u0005\u001d)enY8eKJ\u00042AYA\t\t\u0015!WA1\u0001f\u0011\u0019aX\u00011\u0001\u0002\u0016A!ap`A\b\u0003!\u0019X\u000f\u001d9peR\u001cH\u0003BA\u000e\u0003C\u00012\u0001PA\u000f\u0013\r\ty\"\u0010\u0002\b\u0005>|G.Z1o\u0011\u0019ah\u00011\u0001\u0002$A\"\u0011QEA\u0017!\u0015q\u0018qEA\u0016\u0013\r\tIc\u000b\u0002\u000b\u0007>dW/\u001c8UsB,\u0007c\u00012\u0002.\u0011a\u0011qFA\u0011\u0003\u0003\u0005\tQ!\u0001\u00022\t\u0019q\f\n\u001c\u0012\u0007\u0019\f\u0019\u0004E\u0002=\u0003kI1!a\u000e>\u0005\r\te._\n\u0005\u000fm\nY\u0004E\u00039\u0003\u0017\tiDD\u0002k\u0003\u007fI1!!\u0011l\u0003A\u0001\u0006._:jG\u0006dGj\u001c8h)f\u0004X\r\u0006\u0002\u0002FA\u0019\u0011qI\u0004\u000e\u0003\u0005\tqbX2p[B\u0014Xm]:fINK'0Z\u0001\u0014?\u000e|W\u000e\u001d:fgN,GmU5{K~#S-\u001d\u000b\u0005\u0003\u001f\n)\u0006E\u0002=\u0003#J1!a\u0015>\u0005\u0011)f.\u001b;\t\u0011\u0005]#\"!AA\u0002a\u000b1\u0001\u001f\u00132\u0003Ay6m\\7qe\u0016\u001c8/\u001a3TSj,\u0007%A\t`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\fQcX;oG>l\u0007O]3tg\u0016$7+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002P\u0005\u0005\u0004\u0002CA,\u001b\u0005\u0005\t\u0019\u0001-\u0002%}+hnY8naJ,7o]3e'&TX\rI\u0001\u000fG>l\u0007O]3tg\u0016$7+\u001b>f\u0003A)hnY8naJ,7o]3e'&TX-A\u0005qe\u00164h+\u00197vKV\u0011\u0011Q\u000e\t\u0004y\u0005=\u0014bAA9{\t!Aj\u001c8h\u00035\u0001(/\u001a<WC2,Xm\u0018\u0013fcR!\u0011qJA<\u0011%\t9FEA\u0001\u0002\u0004\ti'\u0001\u0006qe\u00164h+\u00197vK\u0002\n!dZ1uQ\u0016\u00148i\\7qe\u0016\u001c8/\u001b2jY&$\u0018p\u0015;biN$b!a\u0014\u0002\u0000\u0005-\u0005bBAA)\u0001\u0007\u00111Q\u0001\u0004e><\b\u0003BAC\u0003\u000fk\u0011!\\\u0005\u0004\u0003\u0013k'aC%oi\u0016\u0014h.\u00197S_^Da!!$\u0015\u0001\u0004A\u0016aB8sI&t\u0017\r\\\u0001\tG>l\u0007O]3tgR)1/a%\u0002\u0018\"1\u0011QS\u000bA\u0002M\fAA\u001a:p[\"1\u0011\u0011T\u000bA\u0002M\f!\u0001^8\u0014\tYY\u0014Q\u0014\t\u0005q}\u000bi\u0004\u0005\u0003\u007f\u007f\u0006uBCBAR\u0003K\u000b9\u000bE\u0002\u0002HYAQA]\rA\u0002MDa\u0001`\rA\u0002\u0005}\u0015\u0001\u00029sKZ\f\u0001\u0002\u001d:fm~#S-\u001d\u000b\u0005\u0003\u001f\ny\u000bC\u0005\u0002Xm\t\t\u00111\u0001\u0002n\u0005)\u0001O]3wA\u00059\u0001.Y:OKb$XCAA\u000e\u0003\u0011qW\r\u001f;\u0015\r\u0005=\u00131XA_\u0011\u001d\t\tI\ba\u0001\u0003\u0007Ca!!$\u001f\u0001\u0004A\u0016A\u00033fG>l\u0007O]3tgR1\u0011qJAb\u0003'Dq!!2 \u0001\u0004\t9-\u0001\u0007d_2,XN\u001c,fGR|'\u000f\u0005\u0003\u0002J\u0006=WBAAf\u0015\r\ti-L\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$\u0017\u0002BAi\u0003\u0017\u0014Ac\u0016:ji\u0006\u0014G.Z\"pYVlgNV3di>\u0014\bBBAk?\u0001\u0007\u0001,\u0001\u0005dCB\f7-\u001b;z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u001c\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*\u0019\u0011\u0011]<\u0002\t1\fgnZ\u0005\u0005\u0003K\fyN\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019$!<\t\u0011\u0005]#%!AA\u0002a\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003g\u0004b!!>\u0002|\u0006MRBAA|\u0015\r\tI0P\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u007f\u0003o\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111\u0004B\u0002\u0011%\t9\u0006JA\u0001\u0002\u0004\t\u0019$\u0001\u0005iCND7i\u001c3f)\u0005A\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0017\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\t!\u0011\tiNa\u0005\n\t\tU\u0011q\u001c\u0002\u0007\u001f\nTWm\u0019;")
public final class LongDelta {
    public static String toString() {
        return LongDelta$.MODULE$.toString();
    }

    public static int hashCode() {
        return LongDelta$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object x$1) {
        return LongDelta$.MODULE$.canEqual(x$1);
    }

    public static Iterator<Object> productIterator() {
        return LongDelta$.MODULE$.productIterator();
    }

    public static Object productElement(int x$1) {
        return LongDelta$.MODULE$.productElement(x$1);
    }

    public static int productArity() {
        return LongDelta$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return LongDelta$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return LongDelta$.MODULE$.supports(columnType);
    }

    public static <T extends PhysicalDataType> org.apache.spark.sql.execution.columnar.compression.Encoder<T> encoder(NativeColumnType<T> columnType) {
        return LongDelta$.MODULE$.encoder(columnType);
    }

    public static <T extends PhysicalDataType> org.apache.spark.sql.execution.columnar.compression.Decoder<T> decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
        return LongDelta$.MODULE$.decoder(buffer, columnType);
    }

    public static int typeId() {
        return LongDelta$.MODULE$.typeId();
    }

    public static Iterator<String> productElementNames() {
        return LongDelta$.MODULE$.productElementNames();
    }

    public static String productElementName(int n) {
        return LongDelta$.MODULE$.productElementName(n);
    }

    public static class Decoder
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<PhysicalLongType$> {
        private final ByteBuffer buffer;
        private long prev;

        private long prev() {
            return this.prev;
        }

        private void prev_$eq(long x$1) {
            this.prev = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            byte delta = this.buffer.get();
            this.prev_$eq(delta > -128 ? this.prev() + (long)delta : ByteBufferHelper$.MODULE$.getLong(this.buffer));
            row.setLong(ordinal, this.prev());
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            long prevLocal = 0L;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            for (int pos = 0; pos < capacity; ++pos) {
                if (pos != nextNullIndex) {
                    byte delta = this.buffer.get();
                    prevLocal = delta > -128 ? prevLocal + (long)delta : ByteBufferHelper$.MODULE$.getLong(this.buffer);
                    columnVector.putLong(pos, prevLocal);
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<PhysicalLongType$> columnType) {
            this.buffer = buffer;
        }
    }

    public static class Encoder
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<PhysicalLongType$> {
        private int _compressedSize;
        private int _uncompressedSize;
        private long prevValue;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        public int _compressedSize() {
            return this._compressedSize;
        }

        public void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        public int _uncompressedSize() {
            return this._uncompressedSize;
        }

        public void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        private long prevValue() {
            return this.prevValue;
        }

        private void prevValue_$eq(long x$1) {
            this.prevValue = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            long value = row.getLong(ordinal);
            long delta = value - this.prevValue();
            this._compressedSize_$eq(this._compressedSize() + 1);
            if (this._uncompressedSize() == 0 || delta <= (long)-128 || delta > (long)127) {
                this._compressedSize_$eq(this._compressedSize() + LONG$.MODULE$.defaultSize());
            }
            this._uncompressedSize_$eq(this._uncompressedSize() + LONG$.MODULE$.defaultSize());
            this.prevValue_$eq(value);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(LongDelta$.MODULE$.typeId());
            if (from.hasRemaining()) {
                long prev = from.getLong();
                to.put((byte)-128);
                to.putLong(prev);
                while (from.hasRemaining()) {
                    ByteBuffer byteBuffer;
                    long current = from.getLong();
                    long delta = current - prev;
                    prev = current;
                    if ((long)-128 < delta && delta <= (long)127) {
                        byteBuffer = to.put((byte)delta);
                        continue;
                    }
                    to.put((byte)-128);
                    byteBuffer = to.putLong(current);
                }
            }
            return (ByteBuffer)to.rewind();
        }

        public Encoder() {
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._compressedSize = 0;
            this._uncompressedSize = 0;
        }
    }
}

