/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CommitLog;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005Y4Aa\u0003\u0007\u00013!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\"\u0002\u001f\u0001\t\u0003i\u0004b\u0002\"\u0001\u0005\u0004%\ta\u0011\u0005\u0007\u0017\u0002\u0001\u000b\u0011\u0002#\t\u000b1\u0003A\u0011A'\t\u000ba\u0003A\u0011A-\t\u000b}\u0003A\u0011\t1\t\u000b\u0019\u0004A\u0011B4\u0003\u001d\u0005\u001b\u0018P\\2D_6l\u0017\u000e\u001e'pO*\u0011QBD\u0001\ngR\u0014X-Y7j]\u001eT!a\u0004\t\u0002\u0013\u0015DXmY;uS>t'BA\t\u0013\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011C\u0001\u0001\u001b!\tYB$D\u0001\r\u0013\tiBBA\u0005D_6l\u0017\u000e\u001e'pO\u0006a1\u000f]1sWN+7o]5p]B\u0011\u0001%I\u0007\u0002!%\u0011!\u0005\u0005\u0002\r'B\f'o[*fgNLwN\\\u0001\u0005a\u0006$\b\u000e\u0005\u0002&]9\u0011a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0003Sa\ta\u0001\u0010:p_Rt$\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R\u0013A\u0002)sK\u0012,g-\u0003\u00020a\t11\u000b\u001e:j]\u001eT!!\f\u0016\u0002\u001f\u0015DXmY;u_J\u001cVM\u001d<jG\u0016\u0004\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00028q\u0005!Q\u000f^5m\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001b\u0003%QC'/Z1e!>|G.\u0012=fGV$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tyz\u0004)\u0011\t\u00037\u0001AQA\b\u0003A\u0002}AQa\t\u0003A\u0002\u0011BQ!\r\u0003A\u0002I\nqc\u001e:jiR,g\u000eV8EkJ\f'\r\\3Ti>\u0014\u0018mZ3\u0016\u0003\u0011\u00032aM#H\u0013\t1EGA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fI\u0012+\u0017/^3\u0011\u0005!KU\"\u0001\u0016\n\u0005)S#\u0001\u0002'p]\u001e\f\u0001d\u001e:jiR,g\u000eV8EkJ\f'\r\\3Ti>\u0014\u0018mZ3!\u0003!\tG\rZ!ts:\u001cGc\u0001(R'B\u00191gT$\n\u0005A#$!E\"p[BdW\r^1cY\u00164U\u000f^;sK\")!k\u0002a\u0001\u000f\u00069!-\u0019;dQ&#\u0007\"\u0002+\b\u0001\u0004)\u0016\u0001C7fi\u0006$\u0017\r^1\u0011\u0005m1\u0016BA,\r\u00059\u0019u.\\7ji6+G/\u00193bi\u0006\f1\"\u00193e\u0013:lU-\\8ssR\u0019!,\u00180\u0011\u0005![\u0016B\u0001/+\u0005\u001d\u0011un\u001c7fC:DQA\u0015\u0005A\u0002\u001dCQ\u0001\u0016\u0005A\u0002U\u000bQ\u0001];sO\u0016$\"!\u00193\u0011\u0005!\u0013\u0017BA2+\u0005\u0011)f.\u001b;\t\u000b\u0015L\u0001\u0019A$\u0002!QD'/Z:i_2$')\u0019;dQ&#\u0017\u0001G1eI:+wOQ1uG\"\u0014\u0015p\u0015;sK\u0006l\u0017i]=oGR\u0011\u0001.\u001e\u000b\u0003S*\u00042aM([\u0011\u0015Y'\u00021\u0001m\u0003\t1g\u000e\u0005\u0003I[>\f\u0017B\u00018+\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002qg6\t\u0011O\u0003\u0002sq\u0005\u0011\u0011n\\\u0005\u0003iF\u0014AbT;uaV$8\u000b\u001e:fC6DQA\u0015\u0006A\u0002\u001d\u0003")
public class AsyncCommitLog
extends CommitLog {
    private final ThreadPoolExecutor executorService;
    private final ConcurrentLinkedDeque<Object> writtenToDurableStorage;

    public ConcurrentLinkedDeque<Object> writtenToDurableStorage() {
        return this.writtenToDurableStorage;
    }

    public CompletableFuture<Object> addAsync(long batchId, CommitMetadata metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable)() -> "'null' metadata cannot be written to a metadata log");
        CompletionStage future = this.addNewBatchByStreamAsync(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)output -> {
            this.serialize(metadata, output);
            return BoxedUnit.UNIT;
        }).thenApply(ret -> BoxesRunTime.boxToLong((long)AsyncCommitLog.$anonfun$addAsync$3(batchId, BoxesRunTime.unboxToBoolean((Object)ret))));
        this.batchCache().put(BoxesRunTime.boxToLong((long)batchId), metadata);
        return future;
    }

    public boolean addInMemory(long batchId, CommitMetadata metadata) {
        boolean bl;
        if (this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId))) {
            bl = false;
        } else {
            this.batchCache().put(BoxesRunTime.boxToLong((long)batchId), metadata);
            bl = true;
        }
        return bl;
    }

    @Override
    public void purge(long thresholdBatchId) {
        super.purge(thresholdBatchId);
    }

    private CompletableFuture<Object> addNewBatchByStreamAsync(long batchId, Function1<OutputStream, BoxedUnit> fn) {
        CompletableFuture<Object> completableFuture;
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId))) {
            future.complete(BoxesRunTime.boxToBoolean((boolean)false));
            completableFuture = future;
        } else {
            this.executorService.submit(new Runnable(this, batchMetadataFile, future, fn, batchId){
                private final /* synthetic */ AsyncCommitLog $outer;
                private final Path batchMetadataFile$1;
                private final CompletableFuture future$1;
                private final Function1 fn$1;
                private final long batchId$2;

                public void run() {
                    block3: {
                        try {
                            if (this.$outer.fileManager().exists(this.batchMetadataFile$1)) {
                                this.future$1.complete(BoxesRunTime.boxToBoolean((boolean)false));
                                break block3;
                            }
                            long start = System.currentTimeMillis();
                            this.$outer.write(this.batchMetadataFile$1, (Function1<OutputStream, BoxedUnit>)this.fn$1);
                            this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(33).append("Completion commit for batch ").append($this.batchId$2).append(" took").toString()).append(new StringBuilder(39).append(" ").append(System.currentTimeMillis() - start).append(" ms to be persisted to durable storage").toString()).toString());
                            this.$outer.writtenToDurableStorage().add(BoxesRunTime.boxToLong((long)this.batchId$2));
                            this.future$1.complete(BoxesRunTime.boxToBoolean((boolean)true));
                        }
                        catch (Throwable e) {
                            this.$outer.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Encountered error while writing batch ").append($this.batchId$2).append(" to commit log").toString(), e);
                            this.future$1.completeExceptionally(e);
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchMetadataFile$1 = batchMetadataFile$1;
                    this.future$1 = future$1;
                    this.fn$1 = fn$1;
                    this.batchId$2 = batchId$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.sql.execution.streaming.AsyncCommitLog$$anon$1 long ), $anonfun$run$2(org.apache.spark.sql.execution.streaming.AsyncCommitLog$$anon$1 )}, serializedLambda);
                }
            });
            completableFuture = future;
        }
        return completableFuture;
    }

    public static final /* synthetic */ long $anonfun$addAsync$3(long batchId$1, boolean ret) {
        if (!ret) {
            throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(batchId$1);
        }
        return batchId$1;
    }

    public AsyncCommitLog(SparkSession sparkSession, String path, ThreadPoolExecutor executorService) {
        this.executorService = executorService;
        super(sparkSession, path);
        Predef$.MODULE$.assert(this.metadataCacheEnabled());
        this.writtenToDurableStorage = new ConcurrentLinkedDeque(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.wrapLongArray(this.listBatchesOnDisk()).toList()).asJavaCollection());
    }
}

