/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.jdbc.DB2Dialect;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.SetOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class DB2Dialect$
extends JdbcDialect {
    public static final DB2Dialect$ MODULE$ = new DB2Dialect$();
    private static final Set<String> org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COVAR_POP", "COVAR_SAMP", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
    private static final Set<String> supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}))).$plus$plus(MODULE$.org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions());
    private static final Set<String> supportedFunctions = MODULE$.supportedAggregateFunctions();

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:db2");
    }

    public Set<String> org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions() {
        return org$apache$spark$sql$jdbc$DB2Dialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        DB2Dialect.DB2SQLBuilder db2SQLBuilder = new DB2Dialect.DB2SQLBuilder();
        try {
            some = new Some((Object)db2SQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", e);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        var6_5 = sqlType;
        switch (var6_5) {
            case 7: {
                v0 = Option$.MODULE$.apply((Object)FloatType$.MODULE$);
                break;
            }
            case 1111: {
                var7_6 = typeName;
                switch (var7_6 == null ? 0 : var7_6.hashCode()) {
                    case 87031: {
                        if (!"XML".equals(var7_6)) break;
                        var5_7 = Option$.MODULE$.apply((Object)StringType$.MODULE$);
                        ** GOTO lbl18
                    }
                    case 1345372058: {
                        if (!"DECFLOAT".equals(var7_6)) break;
                        var5_7 = Option$.MODULE$.apply((Object)new DecimalType(38, 18));
                        ** GOTO lbl18
                    }
                }
                var5_7 = var7_6.startsWith("TIMESTAMP") != false ? Option$.MODULE$.apply((Object)TimestampType$.MODULE$) : None$.MODULE$;
lbl18:
                // 3 sources

                v0 = var5_7;
                break;
            }
            default: {
                v0 = None$.MODULE$;
                break;
            }
        }
        return v0;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        boolean bl;
        DataType dataType = dt;
        Object object = StringType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("CLOB", 2005)) : (BooleanType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1)) : ((bl = ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) ? new Some((Object)new JdbcType("SMALLINT", 5)) : None$.MODULE$));
        return object;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(25).append("TRUNCATE TABLE ").append(table).append(" IMMEDIATE").toString();
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        return new StringBuilder(0).append(new StringBuilder(17).append("RENAME TABLE ").append(this.getFullyQualifiedQuotedTableName(oldTable)).append(" TO ").toString()).append(String.valueOf(this.getFullyQualifiedQuotedTableName(newTable))).toString();
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(0).append(new StringBuilder(26).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).toString()).append(new StringBuilder(15).append(" SET DATA TYPE ").append(newDataType).toString()).toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(nullable).toString();
    }

    @Override
    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS ''").toString();
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        AnalysisException analysisException;
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            AnalysisException analysisException2;
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            switch (string == null ? 0 : string.hashCode()) {
                case 49568276: {
                    if (!"42893".equals(string)) break;
                    throw new NonEmptyNamespaceException(message, (Option)new Some((Object)e));
                }
            }
            analysisException = analysisException2 = super.classifyException(message, e);
        } else {
            analysisException = super.classifyException(message, e);
        }
        return analysisException;
    }

    @Override
    public String dropSchema(String schema, boolean cascade) {
        return cascade ? new StringBuilder(20).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" CASCADE").toString() : new StringBuilder(21).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" RESTRICT").toString();
    }

    @Override
    public String getLimitClause(Integer limit) {
        return Predef$.MODULE$.Integer2int(limit) > 0 ? new StringBuilder(22).append("FETCH FIRST ").append(limit).append(" ROWS ONLY").toString() : "";
    }

    @Override
    public String getOffsetClause(Integer offset) {
        return Predef$.MODULE$.Integer2int(offset) > 0 ? new StringBuilder(12).append("OFFSET ").append(offset).append(" ROWS").toString() : "";
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new DB2Dialect.DB2SQLQueryBuilder(this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DB2Dialect$.class);
    }

    private DB2Dialect$() {
    }
}

