/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.util.HdfsUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001u4Qa\u0004\t\u0001%iA\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\")1\u000b\u0001C\u0001)\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006BB1\u0001A\u0003%1\fC\u0004c\u0001\u0001\u0007I\u0011B2\t\u000f\u001d\u0004\u0001\u0019!C\u0005Q\"1a\u000e\u0001Q!\n\u0011Dqa\u001c\u0001A\u0002\u0013%\u0001\u000fC\u0004u\u0001\u0001\u0007I\u0011B;\t\r]\u0004\u0001\u0015)\u0003r\u0011\u0015A\b\u0001\"\u0011d\u0011\u0015I\b\u0001\"\u0011{\u0011\u0015Y\b\u0001\"\u0011}\u0005q1\u0015\u000e\\3CCN,Gm\u0016:ji\u0016\f\u0005.Z1e\u0019><'+Z1eKJT!!\u0005\n\u0002\tU$\u0018\u000e\u001c\u0006\u0003'Q\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001cR\u0001A\u000e\"mq\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007c\u0001\u0012,]9\u00111%\u000b\b\u0003I!j\u0011!\n\u0006\u0003M\u001d\na\u0001\u0010:p_Rt4\u0001A\u0005\u0002=%\u0011!&H\u0001\ba\u0006\u001c7.Y4f\u0013\taSF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\tQS\u0004\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005\u0019a.[8\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bCA\u001c;\u001b\u0005A$BA\u001d3\u0003\tIw.\u0003\u0002<q\tI1\t\\8tK\u0006\u0014G.\u001a\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fQ\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0003z\u0012q\u0001T8hO&tw-\u0001\u0003qCRD\u0007C\u0001#I\u001d\t)e\t\u0005\u0002%;%\u0011q)H\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H;\u0005!1m\u001c8g!\ti\u0015+D\u0001O\u0015\tYuJ\u0003\u0002Q-\u00051\u0001.\u00193p_BL!A\u0015(\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0019Qk\u0016-\u0011\u0005Y\u0003Q\"\u0001\t\t\u000b\t\u001b\u0001\u0019A\"\t\u000b-\u001b\u0001\u0019\u0001'\u0002\u0011%t7\u000f\u001e:fC6,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=>\u000b!AZ:\n\u0005\u0001l&!\u0005$T\t\u0006$\u0018-\u00138qkR\u001cFO]3b[\u0006I\u0011N\\:ue\u0016\fW\u000eI\u0001\u0007G2|7/\u001a3\u0016\u0003\u0011\u0004\"\u0001H3\n\u0005\u0019l\"a\u0002\"p_2,\u0017M\\\u0001\u000bG2|7/\u001a3`I\u0015\fHCA5m!\ta\".\u0003\u0002l;\t!QK\\5u\u0011\u001diw!!AA\u0002\u0011\f1\u0001\u001f\u00132\u0003\u001d\u0019Gn\\:fI\u0002\n\u0001B\\3yi&#X-\\\u000b\u0002cB\u0019AD\u001d\u0018\n\u0005Ml\"AB(qi&|g.\u0001\u0007oKb$\u0018\n^3n?\u0012*\u0017\u000f\u0006\u0002jm\"9QNCA\u0001\u0002\u0004\t\u0018!\u00038fqRLE/Z7!\u0003\u001dA\u0017m\u001d(fqR\fAA\\3yiR\ta&A\u0003dY>\u001cX\rF\u0001j\u0001")
public class FileBasedWriteAheadLogReader
implements Iterator<ByteBuffer>,
Closeable,
Logging {
    private final String path;
    private final Configuration conf;
    private final FSDataInputStream instream;
    private boolean closed;
    private Option<ByteBuffer> nextItem;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Iterator<ByteBuffer> seq() {
        return Iterator.seq$((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.isEmpty$((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.isTraversableAgain$((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.hasDefiniteSize$((Iterator)this);
    }

    public Iterator<ByteBuffer> take(int n) {
        return Iterator.take$((Iterator)this, (int)n);
    }

    public Iterator<ByteBuffer> drop(int n) {
        return Iterator.drop$((Iterator)this, (int)n);
    }

    public Iterator<ByteBuffer> slice(int from, int until) {
        return Iterator.slice$((Iterator)this, (int)from, (int)until);
    }

    public Iterator<ByteBuffer> sliceIterator(int from, int until) {
        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
    }

    public <B> Iterator<B> map(Function1<ByteBuffer, B> f) {
        return Iterator.map$((Iterator)this, f);
    }

    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return Iterator.$plus$plus$((Iterator)this, that);
    }

    public <B> Iterator<B> flatMap(Function1<ByteBuffer, GenTraversableOnce<B>> f) {
        return Iterator.flatMap$((Iterator)this, f);
    }

    public Iterator<ByteBuffer> filter(Function1<ByteBuffer, Object> p) {
        return Iterator.filter$((Iterator)this, p);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<ByteBuffer, B, Object> p) {
        return Iterator.corresponds$((Iterator)this, that, p);
    }

    public Iterator<ByteBuffer> withFilter(Function1<ByteBuffer, Object> p) {
        return Iterator.withFilter$((Iterator)this, p);
    }

    public Iterator<ByteBuffer> filterNot(Function1<ByteBuffer, Object> p) {
        return Iterator.filterNot$((Iterator)this, p);
    }

    public <B> Iterator<B> collect(PartialFunction<ByteBuffer, B> pf) {
        return Iterator.collect$((Iterator)this, pf);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, ByteBuffer, B> op) {
        return Iterator.scanLeft$((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<ByteBuffer, B, B> op) {
        return Iterator.scanRight$((Iterator)this, z, op);
    }

    public Iterator<ByteBuffer> takeWhile(Function1<ByteBuffer, Object> p) {
        return Iterator.takeWhile$((Iterator)this, p);
    }

    public Tuple2<Iterator<ByteBuffer>, Iterator<ByteBuffer>> partition(Function1<ByteBuffer, Object> p) {
        return Iterator.partition$((Iterator)this, p);
    }

    public Tuple2<Iterator<ByteBuffer>, Iterator<ByteBuffer>> span(Function1<ByteBuffer, Object> p) {
        return Iterator.span$((Iterator)this, p);
    }

    public Iterator<ByteBuffer> dropWhile(Function1<ByteBuffer, Object> p) {
        return Iterator.dropWhile$((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<ByteBuffer, B>> zip(Iterator<B> that) {
        return Iterator.zip$((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.padTo$((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<ByteBuffer, Object>> zipWithIndex() {
        return Iterator.zipWithIndex$((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<ByteBuffer, U> f) {
        Iterator.foreach$((Iterator)this, f);
    }

    public boolean forall(Function1<ByteBuffer, Object> p) {
        return Iterator.forall$((Iterator)this, p);
    }

    public boolean exists(Function1<ByteBuffer, Object> p) {
        return Iterator.exists$((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.contains$((Iterator)this, (Object)elem);
    }

    public Option<ByteBuffer> find(Function1<ByteBuffer, Object> p) {
        return Iterator.find$((Iterator)this, p);
    }

    public int indexWhere(Function1<ByteBuffer, Object> p) {
        return Iterator.indexWhere$((Iterator)this, p);
    }

    public int indexWhere(Function1<ByteBuffer, Object> p, int from) {
        return Iterator.indexWhere$((Iterator)this, p, (int)from);
    }

    public <B> int indexOf(B elem) {
        return Iterator.indexOf$((Iterator)this, elem);
    }

    public <B> int indexOf(B elem, int from) {
        return Iterator.indexOf$((Iterator)this, elem, (int)from);
    }

    public BufferedIterator<ByteBuffer> buffered() {
        return Iterator.buffered$((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size) {
        return Iterator.grouped$((Iterator)this, (int)size);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
    }

    public <B> int sliding$default$2() {
        return Iterator.sliding$default$2$((Iterator)this);
    }

    public int length() {
        return Iterator.length$((Iterator)this);
    }

    public Tuple2<Iterator<ByteBuffer>, Iterator<ByteBuffer>> duplicate() {
        return Iterator.duplicate$((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.sameElements$((Iterator)this, that);
    }

    public Traversable<ByteBuffer> toTraversable() {
        return Iterator.toTraversable$((Iterator)this);
    }

    public Iterator<ByteBuffer> toIterator() {
        return Iterator.toIterator$((Iterator)this);
    }

    public Stream<ByteBuffer> toStream() {
        return Iterator.toStream$((Iterator)this);
    }

    public String toString() {
        return Iterator.toString$((Iterator)this);
    }

    public List<ByteBuffer> reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.size$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1<ByteBuffer, Object> p) {
        return TraversableOnce.count$((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<ByteBuffer, B> pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, ByteBuffer, B> op) {
        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<ByteBuffer, B, B> op) {
        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, ByteBuffer, B> op) {
        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<ByteBuffer, B, B> op) {
        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, ByteBuffer, B> op) {
        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<ByteBuffer, B, B> op) {
        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, ByteBuffer, B> op) {
        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<ByteBuffer, B, B> op) {
        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, ByteBuffer, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
    }

    public List<ByteBuffer> toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Iterable<ByteBuffer> toIterable() {
        return TraversableOnce.toIterable$((TraversableOnce)this);
    }

    public Seq<ByteBuffer> toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq<ByteBuffer> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector<ByteBuffer> toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, ByteBuffer, Col> cbf) {
        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef$.less.colon.less<ByteBuffer, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private FSDataInputStream instream() {
        return this.instream;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    private Option<ByteBuffer> nextItem() {
        return this.nextItem;
    }

    private void nextItem_$eq(Option<ByteBuffer> x$1) {
        this.nextItem = x$1;
    }

    public synchronized boolean hasNext() {
        boolean bl;
        if (this.closed()) {
            return false;
        }
        if (this.nextItem().isDefined()) {
            bl = true;
        } else {
            try {
                int length = this.instream().readInt();
                byte[] buffer = new byte[length];
                this.instream().readFully(buffer);
                this.nextItem_$eq((Option<ByteBuffer>)new Some((Object)ByteBuffer.wrap(buffer)));
                this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(15).append("Read next item ").append(this.nextItem().get()).toString());
                bl = true;
            }
            catch (EOFException e) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error reading next item, EOF reached", e);
                this.close();
                bl = false;
            }
            catch (IOException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while trying to read data. If the file was deleted, this should be okay.", e);
                this.close();
                if (HdfsUtils$.MODULE$.checkFileExists(this.path, this.conf)) {
                    throw e;
                }
                bl = false;
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while trying to read data from HDFS.", e);
                this.close();
                throw e;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized ByteBuffer next() {
        void var1_1;
        ByteBuffer data = (ByteBuffer)this.nextItem().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.close();
            throw new IllegalStateException("next called without calling hasNext or after hasNext returned false");
        });
        this.nextItem_$eq((Option<ByteBuffer>)None$.MODULE$);
        return var1_1;
    }

    @Override
    public synchronized void close() {
        if (!this.closed()) {
            this.instream().close();
        }
        this.closed_$eq(true);
    }

    public FileBasedWriteAheadLogReader(String path, Configuration conf) {
        this.path = path;
        this.conf = conf;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Iterator.$init$((Iterator)this);
        Logging.$init$((Logging)this);
        this.instream = HdfsUtils$.MODULE$.getInputStream(path, conf);
        this.closed = this.instream() == null;
        this.nextItem = None$.MODULE$;
    }
}

