/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.security.PublicKey;
import org.apache.mina.core.session.IoSession;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.client.auth.UserAuthPassword;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelSession;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.DefaultAuthFuture;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;

public class ClientSessionImpl
extends AbstractSession
implements ClientSession {
    public static final String SESSION = ClientSessionImpl.class.getName();
    private State state = State.ReceiveKexInit;
    private UserAuth userAuth;
    private AuthFuture authFuture;

    public ClientSessionImpl(SshClient client, IoSession session) throws Exception {
        super(client, session);
        this.log.info("Session created...");
        this.sendClientIdentification();
        this.sendKexInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthFuture authPassword(String username, String password) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closeFuture.isClosed()) {
                throw new IllegalStateException("Session is closed");
            }
            if (this.authed) {
                throw new IllegalStateException("User authentication has already been performed");
            }
            if (this.userAuth != null) {
                throw new IllegalStateException("A user authentication request is already pending");
            }
            this.waitFor(6, 0L);
            if (this.closeFuture.isClosed()) {
                throw new IllegalStateException("Session is closed");
            }
            this.authFuture = new DefaultAuthFuture(this.lock);
            this.userAuth = new UserAuthPassword(this, username, password);
            this.setState(State.UserAuth);
            return this.authFuture;
        }
    }

    public AuthFuture authPublicKey(String username, PublicKey key) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closeFuture.isClosed()) {
                throw new IllegalStateException("Session is closed");
            }
            if (this.authed) {
                throw new IllegalStateException("User authentication has already been performed");
            }
            if (this.userAuth != null) {
                throw new IllegalStateException("A user authentication request is already pending");
            }
            this.waitFor(6, 0L);
            if (this.closeFuture.isClosed()) {
                throw new IllegalStateException("Session is closed");
            }
            throw new UnsupportedOperationException("Not supported yet");
        }
    }

    public ClientChannel createChannel(String type) throws Exception {
        ChannelSession channel;
        if ("shell".equals(type)) {
            channel = new ChannelShell();
        } else if ("exec".equals(type)) {
            channel = new ChannelExec();
        } else {
            throw new IllegalArgumentException("Unsupported channel type " + type);
        }
        int id = ++this.nextChannelId;
        channel.init(this, id);
        this.channels.put(id, channel);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseFuture close(boolean immediately) {
        Object object = this.lock;
        synchronized (object) {
            if (this.authFuture != null && !this.authFuture.isDone()) {
                this.authFuture.setException(new SshException("Session is closed"));
            }
            return super.close(immediately);
        }
    }

    protected void handleMessage(Buffer buffer) throws Exception {
        SshConstants.Message cmd = buffer.getCommand();
        this.log.debug("Received packet {}", (Object)cmd);
        block0 : switch (cmd) {
            case SSH_MSG_DISCONNECT: {
                int code = buffer.getInt();
                String msg = buffer.getString();
                this.log.info("Received SSH_MSG_DISCONNECT (reason={}, msg={})", (Object)code, (Object)msg);
                this.close(false);
                break;
            }
            case SSH_MSG_UNIMPLEMENTED: {
                int code = buffer.getInt();
                this.log.info("Received SSH_MSG_UNIMPLEMENTED #{}", (Object)code);
                break;
            }
            case SSH_MSG_DEBUG: {
                boolean display = buffer.getBoolean();
                String msg = buffer.getString();
                this.log.info("Received SSH_MSG_DEBUG (display={}) '{}'", (Object)display, (Object)msg);
                break;
            }
            case SSH_MSG_IGNORE: {
                this.log.info("Received SSH_MSG_IGNORE");
                break;
            }
            default: {
                switch (this.state) {
                    case ReceiveKexInit: {
                        if (cmd != SshConstants.Message.SSH_MSG_KEXINIT) {
                            this.log.error("Ignoring command " + (Object)((Object)cmd) + " while waiting for " + (Object)((Object)SshConstants.Message.SSH_MSG_KEXINIT));
                            break block0;
                        }
                        this.log.info("Received SSH_MSG_KEXINIT");
                        this.receiveKexInit(buffer);
                        this.negociate();
                        this.kex = (KeyExchange)NamedFactory.Utils.create(this.factoryManager.getKeyExchangeFactories(), this.negociated[0]);
                        this.kex.init(this, this.serverVersion.getBytes(), this.clientVersion.getBytes(), this.I_S, this.I_C);
                        this.setState(State.Kex);
                        break block0;
                    }
                    case Kex: {
                        buffer.rpos(buffer.rpos() - 1);
                        if (!this.kex.next(buffer)) break block0;
                        this.checkHost();
                        this.sendNewKeys();
                        this.setState(State.ReceiveNewKeys);
                        break block0;
                    }
                    case ReceiveNewKeys: {
                        if (cmd != SshConstants.Message.SSH_MSG_NEWKEYS) {
                            this.disconnect(2, "Protocol error: expected packet SSH_MSG_NEWKEYS, got " + (Object)((Object)cmd));
                            return;
                        }
                        this.log.info("Received SSH_MSG_NEWKEYS");
                        this.receiveNewKeys(false);
                        this.sendAuthRequest();
                        this.setState(State.AuthRequestSent);
                        break block0;
                    }
                    case AuthRequestSent: {
                        if (cmd != SshConstants.Message.SSH_MSG_SERVICE_ACCEPT) {
                            this.disconnect(2, "Protocol error: expected packet SSH_MSG_SERVICE_ACCEPT, got " + (Object)((Object)cmd));
                            return;
                        }
                        this.setState(State.WaitForAuth);
                        break block0;
                    }
                    case WaitForAuth: {
                        break block0;
                    }
                    case UserAuth: {
                        if (this.userAuth == null) {
                            throw new IllegalStateException("State is userAuth, but no user auth pending!!!");
                        }
                        buffer.rpos(buffer.rpos() - 1);
                        switch (this.userAuth.next(buffer)) {
                            case Success: {
                                this.authFuture.setAuthed(true);
                                this.authed = true;
                                this.setState(State.Running);
                                break block0;
                            }
                            case Failure: {
                                this.authFuture.setAuthed(false);
                                this.userAuth = null;
                                this.setState(State.WaitForAuth);
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case Running: {
                        switch (cmd) {
                            case SSH_MSG_CHANNEL_OPEN_CONFIRMATION: {
                                this.channelOpenConfirmation(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_OPEN_FAILURE: {
                                this.channelOpenFailure(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_REQUEST: {
                                this.channelRequest(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_DATA: {
                                this.channelData(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_EXTENDED_DATA: {
                                this.channelExtendedData(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_FAILURE: {
                                this.channelFailure(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_WINDOW_ADJUST: {
                                this.channelWindowAdjust(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_EOF: {
                                this.channelEof(buffer);
                                break block0;
                            }
                            case SSH_MSG_CHANNEL_CLOSE: {
                                this.channelClose(buffer);
                            }
                        }
                    }
                }
            }
        }
    }

    public int waitFor(int mask, long timeout) {
        long t = 0L;
        Object object = this.lock;
        synchronized (object) {
            block5: while (true) {
                while (true) {
                    int cond = 0;
                    if (this.closeFuture.isClosed()) {
                        cond |= 2;
                    }
                    if (this.authed) {
                        cond |= 8;
                    }
                    if (this.state == State.WaitForAuth) {
                        cond |= 4;
                    }
                    if ((cond & mask) != 0) {
                        return cond;
                    }
                    if (timeout > 0L) {
                        if (t == 0L) {
                            t = System.currentTimeMillis() + timeout;
                        } else {
                            timeout = t - System.currentTimeMillis();
                            if (timeout <= 0L) {
                                return cond |= 1;
                            }
                        }
                    }
                    try {
                        if (timeout > 0L) {
                            this.lock.wait(timeout);
                            continue block5;
                        }
                        this.lock.wait();
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(State newState) {
        Object object = this.lock;
        synchronized (object) {
            this.state = newState;
            this.lock.notifyAll();
        }
    }

    protected boolean readIdentification(Buffer buffer) throws IOException {
        this.serverVersion = this.doReadIdentification(buffer);
        if (this.serverVersion == null) {
            return false;
        }
        this.log.info("Server version string: {}", (Object)this.serverVersion);
        if (!this.serverVersion.startsWith("SSH-2.0-")) {
            throw new SshException(8, "Unsupported protocol version: " + this.serverVersion);
        }
        return true;
    }

    private void sendClientIdentification() {
        this.clientVersion = "SSH-2.0-" + this.getFactoryManager().getVersion();
        this.sendIdentification(this.clientVersion);
    }

    private void sendKexInit() throws Exception {
        this.clientProposal = this.createProposal("ssh-rsa,ssh-dss");
        this.I_C = this.sendKexInit(this.clientProposal);
    }

    private void receiveKexInit(Buffer buffer) throws Exception {
        this.serverProposal = new String[10];
        this.I_S = this.receiveKexInit(buffer, this.serverProposal);
    }

    private void checkHost() throws Exception {
    }

    private void sendAuthRequest() throws Exception {
        this.log.info("Send SSH_MSG_SERVICE_REQUEST for ssh-userauth");
        Buffer buffer = this.createBuffer(SshConstants.Message.SSH_MSG_SERVICE_REQUEST);
        buffer.putString("ssh-userauth");
        this.writePacket(buffer);
    }

    private void channelOpenConfirmation(Buffer buffer) throws IOException {
        AbstractClientChannel channel = (AbstractClientChannel)this.getChannel(buffer);
        this.log.info("Received SSH_MSG_CHANNEL_OPEN_CONFIRMATION on channel {}", (Object)channel.getId());
        int recipient = buffer.getInt();
        int rwsize = buffer.getInt();
        int rmpsize = buffer.getInt();
        channel.internalOpenSuccess(recipient, rwsize, rmpsize);
    }

    private void channelOpenFailure(Buffer buffer) throws IOException {
        AbstractClientChannel channel = (AbstractClientChannel)this.getChannel(buffer);
        this.log.info("Received SSH_MSG_CHANNEL_OPEN_FAILURE on channel {}", (Object)channel.getId());
        this.channels.remove(channel.getId());
        channel.internalOpenFailure(buffer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ReceiveKexInit,
        Kex,
        ReceiveNewKeys,
        AuthRequestSent,
        WaitForAuth,
        UserAuth,
        Running,
        Unknown;

    }
}

