/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.util.ArrayList;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileKeyPairProvider
extends AbstractKeyPairProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FileKeyPairProvider.class);
    private String[] files;
    private PasswordFinder passwordFinder;

    public FileKeyPairProvider() {
    }

    public FileKeyPairProvider(String[] files) {
        this.files = files;
    }

    public FileKeyPairProvider(String[] files, PasswordFinder passwordFinder) {
        this.files = files;
        this.passwordFinder = passwordFinder;
    }

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }

    public PasswordFinder getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(PasswordFinder passwordFinder) {
        this.passwordFinder = passwordFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyPair[] loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>();
        for (int i = 0; i < this.files.length; ++i) {
            try {
                PEMReader r = new PEMReader((Reader)new InputStreamReader(new FileInputStream(this.files[i])), this.passwordFinder);
                try {
                    Object o = r.readObject();
                    if (!(o instanceof KeyPair)) continue;
                    keys.add((KeyPair)o);
                    continue;
                }
                finally {
                    r.close();
                }
            }
            catch (Exception e) {
                LOG.info("Unable to read key {}: {}", (Object)this.files[i], (Object)e);
            }
        }
        return keys.toArray(new KeyPair[keys.size()]);
    }
}

