/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.Compression;
import org.apache.sshd.common.Digest;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.Mac;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Random;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.session.AttributeKey;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.BufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSession {
    public static final String SESSION = "com.google.code.sshd.session";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final FactoryManager factoryManager;
    protected final IoSession ioSession;
    protected final Random random;
    protected final Object lock = new Object();
    protected final CloseFuture closeFuture = new DefaultCloseFuture(this.lock);
    protected volatile boolean closing;
    protected boolean authed;
    protected final Map<Integer, Channel> channels = new ConcurrentHashMap<Integer, Channel>();
    protected int nextChannelId;
    protected byte[] sessionId;
    protected String serverVersion;
    protected String clientVersion;
    protected String[] serverProposal;
    protected String[] clientProposal;
    protected String[] negociated;
    protected byte[] I_C;
    protected byte[] I_S;
    protected KeyExchange kex;
    protected Cipher outCipher;
    protected Cipher inCipher;
    protected int outCipherSize = 8;
    protected int inCipherSize = 8;
    protected Mac outMac;
    protected Mac inMac;
    protected byte[] inMacResult;
    protected Compression outCompression;
    protected Compression inCompression;
    protected int seqi;
    protected int seqo;
    protected Buffer decoderBuffer = new Buffer();
    protected Buffer uncompressBuffer;
    protected int decoderState;
    protected int decoderLength;
    protected final Object encodeLock = new Object();
    protected final Object decodeLock = new Object();
    protected final Map<AttributeKey<?>, Object> attributes = new ConcurrentHashMap();

    public AbstractSession(FactoryManager factoryManager, IoSession ioSession) {
        this.factoryManager = factoryManager;
        this.ioSession = ioSession;
        this.random = factoryManager.getRandomFactory().create();
    }

    public static final AbstractSession getSession(IoSession ioSession) {
        return AbstractSession.getSession(ioSession, false);
    }

    public static final AbstractSession getSession(IoSession ioSession, boolean allowNull) {
        AbstractSession session = (AbstractSession)ioSession.getAttribute((Object)SESSION);
        if (!allowNull && session == null) {
            throw new IllegalStateException("No session available");
        }
        return session;
    }

    public static final void attachSession(IoSession ioSession, AbstractSession session) {
        ioSession.setAttribute((Object)SESSION, (Object)session);
    }

    public FactoryManager getFactoryManager() {
        return this.factoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoBuffer buffer) throws Exception {
        Object object = this.decodeLock;
        synchronized (object) {
            this.decoderBuffer.putBuffer(buffer);
            if (this.clientVersion == null || this.serverVersion == null) {
                if (this.readIdentification(this.decoderBuffer)) {
                    this.decoderBuffer.compact();
                } else {
                    return;
                }
            }
            this.decode();
        }
    }

    protected abstract void handleMessage(Buffer var1) throws Exception;

    public void exceptionCaught(Throwable t) {
        this.log.warn("Exception caught", t);
        try {
            int code;
            if (t instanceof SshException && (code = ((SshException)t).getDisconnectCode()) > 0) {
                this.disconnect(code, t.getMessage());
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseFuture close(boolean immediately) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closing) {
                try {
                    this.closing = true;
                    this.log.info("Closing session");
                    Channel[] channelToClose = this.channels.values().toArray(new Channel[0]);
                    if (channelToClose.length > 0) {
                        final AtomicInteger latch = new AtomicInteger(channelToClose.length);
                        for (Channel channel : channelToClose) {
                            this.log.debug("Closing channel {}", (Object)channel.getId());
                            channel.close(immediately).addListener(new SshFutureListener(){

                                public void operationComplete(SshFuture sshFuture) {
                                    if (latch.decrementAndGet() == 0) {
                                        AbstractSession.this.log.debug("Closing IoSession");
                                        class IoSessionCloser
                                        implements IoFutureListener {
                                            IoSessionCloser() {
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public void operationComplete(IoFuture future) {
                                                Object object = AbstractSession.this.lock;
                                                synchronized (object) {
                                                    AbstractSession.this.log.debug("IoSession closed");
                                                    AbstractSession.this.closeFuture.setClosed();
                                                    AbstractSession.this.lock.notifyAll();
                                                }
                                            }
                                        }
                                        AbstractSession.this.ioSession.close(true).addListener((IoFutureListener)new IoSessionCloser());
                                    }
                                }
                            });
                        }
                    } else {
                        this.log.debug("Closing IoSession");
                        this.ioSession.close(immediately).addListener((IoFutureListener)new IoSessionCloser());
                    }
                }
                catch (Throwable t) {
                    this.log.warn("Error closing session", t);
                }
            }
            return this.closeFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture writePacket(Buffer buffer) throws IOException {
        Object object = this.encodeLock;
        synchronized (object) {
            this.encode(buffer);
            IoBuffer bb = IoBuffer.wrap((byte[])buffer.array(), (int)buffer.rpos(), (int)buffer.available());
            return this.ioSession.write((Object)bb);
        }
    }

    public Buffer createBuffer(SshConstants.Message cmd) {
        Buffer buffer = new Buffer();
        buffer.rpos(5);
        buffer.wpos(5);
        buffer.putByte(cmd.toByte());
        return buffer;
    }

    private void encode(Buffer buffer) throws IOException {
        try {
            if (buffer.rpos() < 5) {
                this.log.warn("Performance cost: when sending a packet, ensure that 5 bytes are available in front of the buffer");
                Buffer nb = new Buffer();
                nb.wpos(5);
                nb.putBuffer(buffer);
                buffer = nb;
            }
            int len = buffer.available();
            int off = buffer.rpos() - 5;
            if (this.log.isDebugEnabled()) {
                this.log.trace("Sending packet #{}: {}", (Object)this.seqo, (Object)buffer.printHex());
            }
            if (this.outCompression != null && (this.authed || !this.outCompression.isDelayed())) {
                this.outCompression.compress(buffer);
                len = buffer.available();
            }
            int bsize = this.outCipherSize;
            int oldLen = len;
            int pad = -(len += 5) & bsize - 1;
            if (pad < bsize) {
                pad += bsize;
            }
            len = len + pad - 4;
            buffer.wpos(off);
            buffer.putInt(len);
            buffer.putByte((byte)pad);
            buffer.wpos(off + oldLen + 5 + pad);
            this.random.fill(buffer.array(), buffer.wpos() - pad, pad);
            if (this.outMac != null) {
                int macSize = this.outMac.getBlockSize();
                int l = buffer.wpos();
                buffer.wpos(l + macSize);
                this.outMac.update(this.seqo);
                this.outMac.update(buffer.array(), off, l);
                this.outMac.doFinal(buffer.array(), l);
            }
            if (this.outCipher != null) {
                this.outCipher.update(buffer.array(), off, len + 4);
            }
            ++this.seqo;
            buffer.rpos(off);
        }
        catch (SshException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    protected void decode() throws Exception {
        while (true) {
            Buffer buf;
            int macSize;
            if (this.decoderState == 0) {
                assert (this.decoderBuffer.rpos() == 0);
                if (this.decoderBuffer.available() <= this.inCipherSize) break;
                if (this.inCipher != null) {
                    this.inCipher.update(this.decoderBuffer.array(), 0, this.inCipherSize);
                }
                this.decoderLength = this.decoderBuffer.getInt();
                if (this.decoderLength < 5 || this.decoderLength > 262144) {
                    this.log.info("Error decoding packet (invalid length) {}", (Object)this.decoderBuffer.printHex());
                    throw new SshException(2, "Invalid packet length: " + this.decoderLength);
                }
                this.decoderState = 1;
                continue;
            }
            if (this.decoderState != 1) continue;
            assert (this.decoderBuffer.rpos() == 4);
            int n = macSize = this.inMac != null ? this.inMac.getBlockSize() : 0;
            if (this.decoderBuffer.available() < this.decoderLength + macSize) break;
            byte[] data = this.decoderBuffer.array();
            if (this.inCipher != null) {
                this.inCipher.update(data, this.inCipherSize, this.decoderLength + 4 - this.inCipherSize);
            }
            if (this.inMac != null) {
                this.inMac.update(this.seqi);
                this.inMac.update(data, 0, this.decoderLength + 4);
                this.inMac.doFinal(this.inMacResult, 0);
                if (!BufferUtils.equals(this.inMacResult, 0, data, this.decoderLength + 4, macSize)) {
                    throw new SshException(5, "MAC Error");
                }
            }
            ++this.seqi;
            byte pad = this.decoderBuffer.getByte();
            int wpos = this.decoderBuffer.wpos();
            if (this.inCompression != null && (this.authed || !this.inCompression.isDelayed())) {
                if (this.uncompressBuffer == null) {
                    this.uncompressBuffer = new Buffer();
                } else {
                    this.uncompressBuffer.clear();
                }
                this.decoderBuffer.wpos(this.decoderBuffer.rpos() + this.decoderLength - 1 - pad);
                this.inCompression.uncompress(this.decoderBuffer, this.uncompressBuffer);
                buf = this.uncompressBuffer;
            } else {
                this.decoderBuffer.wpos(this.decoderLength + 4 - pad);
                buf = this.decoderBuffer;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received packet #{}: {}", (Object)this.seqi, (Object)buf.printHex());
            }
            this.handleMessage(buf);
            this.decoderBuffer.rpos(this.decoderLength + 4 + macSize);
            this.decoderBuffer.wpos(wpos);
            this.decoderBuffer.compact();
            this.decoderState = 0;
        }
    }

    protected void sendIdentification(String ident) {
        IoBuffer buffer = IoBuffer.allocate((int)32);
        buffer.setAutoExpand(true);
        buffer.put((ident + "\r\n").getBytes());
        buffer.flip();
        this.ioSession.write((Object)buffer);
    }

    protected abstract boolean readIdentification(Buffer var1) throws IOException;

    protected String doReadIdentification(Buffer buffer) {
        byte[] data = new byte[256];
        do {
            int rpos = buffer.rpos();
            int pos = 0;
            boolean needLf = false;
            while (true) {
                if (buffer.available() == 0) {
                    buffer.rpos(rpos);
                    return null;
                }
                byte b = buffer.getByte();
                if (b == 13) {
                    needLf = true;
                    continue;
                }
                if (b == 10) break;
                if (needLf) {
                    throw new IllegalStateException("Incorrect identification: bad line ending");
                }
                if (pos >= data.length) {
                    throw new IllegalStateException("Incorrect identification: line too long");
                }
                data[pos++] = b;
            }
            String str = new String(data, 0, pos);
            if (!str.startsWith("SSH-")) continue;
            return str;
        } while (buffer.rpos() <= 16384);
        throw new IllegalStateException("Incorrect identification: too many header lines");
    }

    protected String[] createProposal(String hostKeyTypes) {
        return new String[]{NamedFactory.Utils.getNames(this.factoryManager.getKeyExchangeFactories()), hostKeyTypes, NamedFactory.Utils.getNames(this.factoryManager.getCipherFactories()), NamedFactory.Utils.getNames(this.factoryManager.getCipherFactories()), NamedFactory.Utils.getNames(this.factoryManager.getMacFactories()), NamedFactory.Utils.getNames(this.factoryManager.getMacFactories()), NamedFactory.Utils.getNames(this.factoryManager.getCompressionFactories()), NamedFactory.Utils.getNames(this.factoryManager.getCompressionFactories()), "", ""};
    }

    protected byte[] sendKexInit(String[] proposal) throws IOException {
        Buffer buffer = this.createBuffer(SshConstants.Message.SSH_MSG_KEXINIT);
        int p = buffer.wpos();
        buffer.wpos(p + 16);
        this.random.fill(buffer.array(), p, 16);
        for (String s : proposal) {
            buffer.putString(s);
        }
        buffer.putByte((byte)0);
        buffer.putInt(0);
        byte[] data = buffer.getCompactData();
        this.writePacket(buffer);
        return data;
    }

    protected byte[] receiveKexInit(Buffer buffer, String[] proposal) {
        byte[] d = buffer.array();
        byte[] data = new byte[buffer.available() + 1];
        data[0] = SshConstants.Message.SSH_MSG_KEXINIT.toByte();
        System.arraycopy(d, buffer.rpos(), data, 1, data.length - 1);
        buffer.rpos(buffer.rpos() + 16);
        for (int i = 0; i < proposal.length; ++i) {
            proposal[i] = buffer.getString();
        }
        buffer.getByte();
        buffer.getInt();
        return data;
    }

    protected void sendNewKeys() throws IOException {
        this.log.info("Send SSH_MSG_NEWKEYS");
        Buffer buffer = this.createBuffer(SshConstants.Message.SSH_MSG_NEWKEYS);
        this.writePacket(buffer);
    }

    protected void receiveNewKeys(boolean isServer) throws Exception {
        int j;
        byte[] K = this.kex.getK();
        byte[] H = this.kex.getH();
        Digest hash = this.kex.getHash();
        if (this.sessionId == null) {
            this.sessionId = new byte[H.length];
            System.arraycopy(H, 0, this.sessionId, 0, H.length);
        }
        Buffer buffer = new Buffer();
        buffer.putMPInt(K);
        buffer.putRawBytes(H);
        buffer.putByte((byte)65);
        buffer.putRawBytes(this.sessionId);
        int pos = buffer.available();
        byte[] buf = buffer.array();
        hash.update(buf, 0, pos);
        byte[] IVc2s = hash.digest();
        int n = j = pos - this.sessionId.length - 1;
        buf[n] = (byte)(buf[n] + 1);
        hash.update(buf, 0, pos);
        byte[] IVs2c = hash.digest();
        int n2 = j;
        buf[n2] = (byte)(buf[n2] + 1);
        hash.update(buf, 0, pos);
        byte[] Ec2s = hash.digest();
        int n3 = j;
        buf[n3] = (byte)(buf[n3] + 1);
        hash.update(buf, 0, pos);
        byte[] Es2c = hash.digest();
        int n4 = j;
        buf[n4] = (byte)(buf[n4] + 1);
        hash.update(buf, 0, pos);
        byte[] MACc2s = hash.digest();
        int n5 = j;
        buf[n5] = (byte)(buf[n5] + 1);
        hash.update(buf, 0, pos);
        byte[] MACs2c = hash.digest();
        Cipher s2ccipher = (Cipher)NamedFactory.Utils.create(this.factoryManager.getCipherFactories(), this.negociated[3]);
        Es2c = this.resizeKey(Es2c, s2ccipher.getBlockSize(), hash, K, H);
        s2ccipher.init(isServer ? Cipher.Mode.Encrypt : Cipher.Mode.Decrypt, Es2c, IVs2c);
        Mac s2cmac = (Mac)NamedFactory.Utils.create(this.factoryManager.getMacFactories(), this.negociated[5]);
        s2cmac.init(MACs2c);
        Cipher c2scipher = (Cipher)NamedFactory.Utils.create(this.factoryManager.getCipherFactories(), this.negociated[2]);
        Ec2s = this.resizeKey(Ec2s, c2scipher.getBlockSize(), hash, K, H);
        c2scipher.init(isServer ? Cipher.Mode.Decrypt : Cipher.Mode.Encrypt, Ec2s, IVc2s);
        Mac c2smac = (Mac)NamedFactory.Utils.create(this.factoryManager.getMacFactories(), this.negociated[4]);
        c2smac.init(MACc2s);
        Compression s2ccomp = (Compression)NamedFactory.Utils.create(this.factoryManager.getCompressionFactories(), this.negociated[7]);
        Compression c2scomp = (Compression)NamedFactory.Utils.create(this.factoryManager.getCompressionFactories(), this.negociated[6]);
        if (isServer) {
            this.outCipher = s2ccipher;
            this.outMac = s2cmac;
            this.outCompression = s2ccomp;
            this.inCipher = c2scipher;
            this.inMac = c2smac;
            this.inCompression = c2scomp;
        } else {
            this.outCipher = c2scipher;
            this.outMac = c2smac;
            this.outCompression = c2scomp;
            this.inCipher = s2ccipher;
            this.inMac = s2cmac;
            this.inCompression = s2ccomp;
        }
        this.outCipherSize = this.outCipher.getIVSize();
        if (this.outCompression != null) {
            this.outCompression.init(Compression.Type.Deflater, -1);
        }
        this.inCipherSize = this.inCipher.getIVSize();
        this.inMacResult = new byte[this.inMac.getBlockSize()];
        if (this.inCompression != null) {
            this.inCompression.init(Compression.Type.Inflater, -1);
        }
    }

    private byte[] resizeKey(byte[] E, int blockSize, Digest hash, byte[] K, byte[] H) throws Exception {
        while (blockSize > E.length) {
            Buffer buffer = new Buffer();
            buffer.putMPInt(K);
            buffer.putRawBytes(H);
            buffer.putRawBytes(E);
            hash.update(buffer.array(), 0, buffer.available());
            byte[] foo = hash.digest();
            byte[] bar = new byte[E.length + foo.length];
            System.arraycopy(E, 0, bar, 0, E.length);
            System.arraycopy(foo, 0, bar, E.length, foo.length);
            E = bar;
        }
        return E;
    }

    public void disconnect(int reason, String msg) throws IOException {
        Buffer buffer = this.createBuffer(SshConstants.Message.SSH_MSG_DISCONNECT);
        buffer.putInt(reason);
        buffer.putString(msg);
        buffer.putString("");
        WriteFuture f = this.writePacket(buffer);
        f.addListener(new IoFutureListener(){

            public void operationComplete(IoFuture future) {
                AbstractSession.this.close(false);
            }
        });
    }

    protected void notImplemented() throws IOException {
        Buffer buffer = this.createBuffer(SshConstants.Message.SSH_MSG_UNIMPLEMENTED);
        buffer.putInt(this.seqi - 1);
        this.writePacket(buffer);
    }

    protected void negociate() {
        String[] guess = new String[10];
        for (int i = 0; i < 10; ++i) {
            String[] c = this.clientProposal[i].split(",");
            String[] s = this.serverProposal[i].split(",");
            for (String ci : c) {
                for (String si : s) {
                    if (!ci.equals(si)) continue;
                    guess[i] = ci;
                    break;
                }
                if (guess[i] != null) break;
            }
            if (guess[i] != null || i == 8 || i == 9) continue;
            throw new IllegalStateException("Unable to negociate");
        }
        this.negociated = guess;
    }

    protected void channelData(Buffer buffer) throws Exception {
        Channel channel = this.getChannel(buffer);
        channel.handleData(buffer);
    }

    protected void channelExtendedData(Buffer buffer) throws Exception {
        Channel channel = this.getChannel(buffer);
        channel.handleExtendedData(buffer);
    }

    protected void channelWindowAdjust(Buffer buffer) throws Exception {
        try {
            Channel channel = this.getChannel(buffer);
            channel.handleWindowAdjust(buffer);
        }
        catch (SshException e) {
            this.log.info(e.getMessage());
        }
    }

    protected void channelEof(Buffer buffer) throws Exception {
        Channel channel = this.getChannel(buffer);
        channel.handleEof();
    }

    protected void channelClose(Buffer buffer) throws Exception {
        Channel channel = this.getChannel(buffer);
        channel.handleClose();
        this.channelForget(channel);
    }

    public void channelForget(Channel channel) {
        this.channels.remove(channel.getId());
    }

    protected void channelRequest(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleRequest(buffer);
    }

    protected void channelFailure(Buffer buffer) throws Exception {
        Channel channel = this.getChannel(buffer);
        channel.handleFailure();
    }

    protected Channel getChannel(Buffer buffer) throws IOException {
        int recipient = buffer.getInt();
        Channel channel = this.channels.get(recipient);
        if (channel == null) {
            buffer.rpos(buffer.rpos() - 5);
            SshConstants.Message cmd = buffer.getCommand();
            throw new SshException("Received " + (Object)((Object)cmd) + " on unknown channel " + recipient);
        }
        return channel;
    }

    public int getIntProperty(String name, int defaultValue) {
        try {
            String v = this.factoryManager.getProperties().get(name);
            if (v != null) {
                return Integer.parseInt(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public <T> T getAttribute(AttributeKey<T> key) {
        return (T)this.attributes.get(key);
    }

    public <T, E extends T> T setAttribute(AttributeKey<T> key, E value) {
        return (T)this.attributes.put(key, value);
    }
}

