/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sshd.server.ShellFactory;
import org.apache.sshd.server.shell.InvertedShell;

public class InvertedShellWrapper
implements ShellFactory.Shell {
    private final InvertedShell shell;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private OutputStream shellIn;
    private InputStream shellOut;
    private InputStream shellErr;
    private ShellFactory.ExitCallback callback;
    private Thread thread;

    public InvertedShellWrapper(InvertedShell shell) {
        this.shell = shell;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ShellFactory.ExitCallback callback) {
        this.callback = callback;
    }

    public void start(ShellFactory.Environment env) throws IOException {
        this.shell.start(env.getEnv());
        this.shellIn = this.shell.getInputStream();
        this.shellOut = this.shell.getOutputStream();
        this.shellErr = this.shell.getErrorStream();
        this.thread = new Thread("inverted-shell-pump"){

            public void run() {
                InvertedShellWrapper.this.pumpStreams();
            }
        };
        this.thread.start();
    }

    public void destroy() {
        this.shell.destroy();
    }

    protected void pumpStreams() {
        try {
            byte[] buffer = new byte[512];
            while (true) {
                if (!this.shell.isAlive()) {
                    this.callback.onExit(this.shell.exitValue());
                    return;
                }
                if (this.pumpStream(this.in, this.shellIn, buffer) || this.pumpStream(this.shellOut, this.out, buffer) || this.pumpStream(this.shellErr, this.err, buffer)) continue;
                Thread.sleep(1L);
            }
        }
        catch (Exception e) {
            this.shell.destroy();
            this.callback.onExit(this.shell.exitValue());
            return;
        }
    }

    private boolean pumpStream(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int len;
        if (in.available() > 0 && (len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
            out.flush();
            return true;
        }
        return false;
    }
}

