/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.sshd.server.ShellFactory;
import org.apache.sshd.server.shell.InvertedShell;
import org.apache.sshd.server.shell.InvertedShellWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessShellFactory
implements ShellFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessShellFactory.class);
    private String[] command;

    public ProcessShellFactory() {
    }

    public ProcessShellFactory(String[] command) {
        this.command = command;
    }

    public String[] getCommand() {
        return this.command;
    }

    public void setCommand(String[] command) {
        this.command = command;
    }

    public ShellFactory.Shell createShell() {
        return new InvertedShellWrapper(new ProcessShell(this.command));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessShell
    implements InvertedShell {
        private String[] command;
        private Process process;

        public ProcessShell(String[] command) {
            this.command = command;
        }

        @Override
        public void start(Map<String, String> env) throws IOException {
            String[] cmds = new String[this.command.length];
            for (int i = 0; i < cmds.length; ++i) {
                cmds[i] = "$USER".equals(this.command[i]) ? env.get("USER") : this.command[i];
            }
            ProcessBuilder builder = new ProcessBuilder(cmds);
            if (env != null) {
                builder.environment().putAll(env);
            }
            LOG.info("Starting shell with command: '{}' and env: {}", builder.command(), builder.environment());
            this.process = builder.start();
        }

        @Override
        public OutputStream getInputStream() {
            return this.process.getOutputStream();
        }

        @Override
        public InputStream getOutputStream() {
            return this.process.getInputStream();
        }

        @Override
        public InputStream getErrorStream() {
            return this.process.getErrorStream();
        }

        @Override
        public boolean isAlive() {
            try {
                this.process.exitValue();
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }

        @Override
        public int exitValue() {
            return this.process.exitValue();
        }

        @Override
        public void destroy() {
            this.process.destroy();
        }
    }
}

