/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.password;

import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthPassword
extends AbstractUserAuth {
    public static final String NAME = "password";

    public UserAuthPassword() {
        super(NAME);
    }

    @Override
    public Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        ValidateUtils.checkTrue((boolean)init, (String)"Instance not initialized");
        boolean newPassword = buffer.getBoolean();
        String password = buffer.getString();
        if (newPassword) {
            return this.handleClientPasswordChangeRequest(buffer, this.getServerSession(), this.getUsername(), password, buffer.getString());
        }
        return this.checkPassword(buffer, this.getServerSession(), this.getUsername(), password);
    }

    protected Boolean checkPassword(Buffer buffer, ServerSession session, String username, String password) throws Exception {
        PasswordAuthenticator auth = session.getPasswordAuthenticator();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (auth == null) {
            if (debugEnabled) {
                this.log.debug("checkPassword({}) no password authenticator", (Object)session);
            }
            return false;
        }
        try {
            boolean authed;
            try {
                authed = auth.authenticate(username, password, session);
            }
            catch (Error e) {
                this.log.warn("checkPassword({}) failed ({}) to consult authenticator: {}", new Object[]{session, e.getClass().getSimpleName(), e.getMessage()});
                if (debugEnabled) {
                    this.log.debug("checkPassword(" + session + ") authenticator failure details", (Throwable)e);
                }
                throw new RuntimeSshException((Throwable)e);
            }
            if (debugEnabled) {
                this.log.debug("checkPassword({}) authentication result: {}", (Object)session, (Object)authed);
            }
            return authed;
        }
        catch (PasswordChangeRequiredException e) {
            if (debugEnabled) {
                this.log.debug("checkPassword({}) password change required: {}", (Object)session, (Object)e.getMessage());
            }
            return this.handleServerPasswordChangeRequest(buffer, session, username, password, e);
        }
    }

    protected Boolean handleClientPasswordChangeRequest(Buffer buffer, ServerSession session, String username, String oldPassword, String newPassword) throws Exception {
        throw new UnsupportedOperationException("Password change not supported");
    }

    protected Boolean handleServerPasswordChangeRequest(Buffer buffer, ServerSession session, String username, String password, PasswordChangeRequiredException e) throws Exception {
        String prompt = e.getPrompt();
        String lang = e.getLanguage();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handlePasswordChangeRequest({}) password change required - prompt={}, lang={}", new Object[]{session, prompt, lang});
        }
        buffer = session.createBuffer((byte)60, GenericUtils.length((CharSequence)prompt) + GenericUtils.length((CharSequence)lang) + 32);
        buffer.putString(prompt);
        buffer.putString(lang);
        session.writePacket(buffer);
        return null;
    }
}

