/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.BlobStoreAclHandler;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.generated.AccessControl;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.utils.NimbusClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClientBlobStoreTest {
    private ClientBlobStore client;

    @Before
    public void setUp() throws Exception {
        this.client = new TestClientBlobStore();
        HashMap conf = new HashMap();
        this.client.prepare(conf);
    }

    @After
    public void tearDown() throws Exception {
        this.client = null;
    }

    @Test(expected=AuthorizationException.class)
    public void testDuplicateACLsForCreate() throws Exception {
        SettableBlobMeta meta = new SettableBlobMeta();
        AccessControl submitterAcl = BlobStoreAclHandler.parseAccessControl((String)"u:tester:rwa");
        meta.add_to_acl(submitterAcl);
        AccessControl duplicateAcl = BlobStoreAclHandler.parseAccessControl((String)"u:tester:r--");
        meta.add_to_acl(duplicateAcl);
        String testKey = "testDuplicateACLsBlobKey";
        this.client.createBlob(testKey, meta);
    }

    @Test
    public void testGoodACLsForCreate() throws Exception {
        SettableBlobMeta meta = new SettableBlobMeta();
        AccessControl submitterAcl = BlobStoreAclHandler.parseAccessControl((String)"u:tester:rwa");
        meta.add_to_acl(submitterAcl);
        String testKey = "testBlobKey";
        this.client.createBlob(testKey, meta);
        this.validatedBlobAcls(testKey);
    }

    @Test(expected=AuthorizationException.class)
    public void testDuplicateACLsForSetBlobMeta() throws Exception {
        String testKey = "testDuplicateACLsBlobKey";
        SettableBlobMeta meta = new SettableBlobMeta();
        this.createTestBlob(testKey, meta);
        AccessControl duplicateAcl = BlobStoreAclHandler.parseAccessControl((String)"u:tester:r--");
        meta.add_to_acl(duplicateAcl);
        this.client.setBlobMeta(testKey, meta);
    }

    @Test
    public void testGoodACLsForSetBlobMeta() throws Exception {
        String testKey = "testBlobKey";
        SettableBlobMeta meta = new SettableBlobMeta();
        this.createTestBlob(testKey, meta);
        meta.add_to_acl(BlobStoreAclHandler.parseAccessControl((String)"u:nextuser:r--"));
        this.client.setBlobMeta(testKey, meta);
        this.validatedBlobAcls(testKey);
    }

    @Test
    public void testBloblStoreKeyWithUnicodesValidation() throws Exception {
        BlobStore.validateKey((String)"msg:kafka-unicodewriter\u4db5-11-1483434711-stormconf.ser");
        BlobStore.validateKey((String)"msg:kafka-ascii-11-148343436363-stormconf.ser");
    }

    private void createTestBlob(String testKey, SettableBlobMeta meta) throws AuthorizationException, KeyAlreadyExistsException {
        AccessControl submitterAcl = BlobStoreAclHandler.parseAccessControl((String)"u:tester:rwa");
        meta.add_to_acl(submitterAcl);
        this.client.createBlob(testKey, meta);
    }

    private void validatedBlobAcls(String testKey) throws KeyNotFoundException, AuthorizationException {
        ReadableBlobMeta blobMeta = this.client.getBlobMeta(testKey);
        Assert.assertNotNull((String)("The blob" + testKey + "does not have any readable blobMeta."), (Object)blobMeta);
        SettableBlobMeta settableBlob = blobMeta.get_settable();
        Assert.assertNotNull((String)("The blob" + testKey + "does not have any settable blobMeta."), (Object)settableBlob);
    }

    public class TestClientBlobStore
    extends ClientBlobStore {
        private Map<String, SettableBlobMeta> allBlobs;

        public void prepare(Map<String, Object> conf) {
            this.conf = conf;
            this.allBlobs = new HashMap<String, SettableBlobMeta>();
        }

        protected AtomicOutputStream createBlobToExtend(String key, SettableBlobMeta meta) throws AuthorizationException, KeyAlreadyExistsException {
            this.allBlobs.put(key, meta);
            return null;
        }

        public AtomicOutputStream updateBlob(String key) throws AuthorizationException, KeyNotFoundException {
            return null;
        }

        public ReadableBlobMeta getBlobMeta(String key) throws AuthorizationException, KeyNotFoundException {
            ReadableBlobMeta reableMeta = null;
            if (this.allBlobs.containsKey(key)) {
                reableMeta = new ReadableBlobMeta();
                reableMeta.set_settable(this.allBlobs.get(key));
            }
            return reableMeta;
        }

        protected void setBlobMetaToExtend(String key, SettableBlobMeta meta) throws AuthorizationException, KeyNotFoundException {
        }

        public void deleteBlob(String key) throws AuthorizationException, KeyNotFoundException {
        }

        public InputStreamWithMeta getBlob(String key) throws AuthorizationException, KeyNotFoundException {
            return null;
        }

        public Iterator<String> listKeys() {
            return null;
        }

        public void shutdown() {
        }

        public int getBlobReplication(String key) {
            return -1;
        }

        public int updateBlobReplication(String key, int replication) {
            return -1;
        }

        public boolean setClient(Map<String, Object> conf, NimbusClient client) {
            return false;
        }

        public void createStateInZookeeper(String key) {
        }
    }
}

