/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.security.auth.Subject;
import org.apache.commons.io.FileUtils;
import org.apache.storm.security.auth.AutoSSL;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSSLTest {
    static final Logger LOG = LoggerFactory.getLogger(AutoSSLTest.class);

    @Test
    public void testgetSSLFilesFromConf() throws Exception {
        AutoSSL assl = new AutoSSL();
        HashMap<String, String> conf = new HashMap<String, String>();
        Assert.assertNull((Object)assl.getSSLFilesFromConf(conf));
        conf.put("ssl.credential.files", "sslfile1.txt");
        assl.prepare(conf);
        Collection sslFiles = assl.getSSLFilesFromConf(conf);
        Assert.assertNotNull((Object)sslFiles);
        Assert.assertEquals((long)1L, (long)sslFiles.size());
        for (String file : sslFiles) {
            Assert.assertEquals((Object)"sslfile1.txt", (Object)file);
        }
    }

    @Test
    public void testgetSSLFilesFromConfMultipleComma() throws Exception {
        AutoSSL assl = new AutoSSL();
        HashMap<String, String> conf = new HashMap<String, String>();
        Assert.assertNull((Object)assl.getSSLFilesFromConf(conf));
        conf.put("ssl.credential.files", "sslfile1.txt,sslfile2.txt,sslfile3.txt");
        assl.prepare(conf);
        Collection sslFiles = assl.getSSLFilesFromConf(conf);
        Assert.assertNotNull((Object)sslFiles);
        Assert.assertEquals((long)3L, (long)sslFiles.size());
        ArrayList valid = new ArrayList();
        Collections.addAll(valid, "sslfile1.txt", "sslfile2.txt", "sslfile3.txt");
        for (String file : sslFiles) {
            Assert.assertTrue((String)("removing: " + file), (boolean)valid.remove(file));
        }
        Assert.assertEquals((long)0L, (long)valid.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testpopulateCredentials() throws Exception {
        File temp = File.createTempFile("tmp-autossl-test", ".txt");
        temp.deleteOnExit();
        List<String> lines = Arrays.asList("The first line", "The second line");
        Files.write(temp.toPath(), lines, Charset.forName("UTF-8"), new OpenOption[0]);
        File baseDir = null;
        try {
            baseDir = new File("/tmp/autossl-test-" + UUID.randomUUID());
            if (!baseDir.mkdir()) {
                throw new IOException("failed to create base directory");
            }
            TestAutoSSL assl = new TestAutoSSL(baseDir.getPath());
            LOG.debug("base dir is; " + baseDir);
            HashMap<String, String> sslconf = new HashMap<String, String>();
            sslconf.put("ssl.credential.files", temp.getPath());
            assl.prepare(sslconf);
            Collection sslFiles = assl.getSSLFilesFromConf(sslconf);
            HashMap creds = new HashMap();
            assl.populateCredentials(creds);
            Assert.assertTrue((boolean)creds.containsKey(temp.getName()));
            Subject unusedSubject = new Subject();
            assl.populateSubject(unusedSubject, creds);
            String[] outputFiles = baseDir.list();
            Assert.assertEquals((long)1L, (long)outputFiles.length);
            if (outputFiles.length > 0) {
                List linesWritten = FileUtils.readLines((File)new File(baseDir, outputFiles[0]), (Charset)Charset.forName("UTF-8"));
                for (String l : linesWritten) {
                    Assert.assertTrue((boolean)lines.contains(l));
                }
            }
            if (baseDir == null) return;
        }
        catch (Throwable throwable) {
            if (baseDir == null) throw throwable;
            FileUtils.deleteDirectory(baseDir);
            throw throwable;
        }
        FileUtils.deleteDirectory((File)baseDir);
    }

    public class TestAutoSSL
    extends AutoSSL {
        String baseDir = null;

        TestAutoSSL(String newDir) {
            this.baseDir = newDir;
        }

        protected String getSSLWriteDirFromConf(Map<String, Object> conf) {
            return this.baseDir;
        }
    }
}

