/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.serialization.GzipBridgeThriftSerializationDelegate;
import org.apache.storm.serialization.GzipThriftSerializationDelegate;
import org.apache.storm.serialization.SerializationDelegate;
import org.apache.storm.serialization.ThriftSerializationDelegate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GzipBridgeThriftSerializationDelegateTest {
    SerializationDelegate testDelegate;

    @Before
    public void setUp() throws Exception {
        this.testDelegate = new GzipBridgeThriftSerializationDelegate();
    }

    @Test
    public void testDeserialize_readingFromGzip() throws Exception {
        GlobalStreamId id = new GlobalStreamId("first", "second");
        byte[] serialized = new GzipThriftSerializationDelegate().serialize((Object)id);
        GlobalStreamId id2 = (GlobalStreamId)this.testDelegate.deserialize(serialized, GlobalStreamId.class);
        Assert.assertEquals((Object)id2.get_componentId(), (Object)id.get_componentId());
        Assert.assertEquals((Object)id2.get_streamId(), (Object)id.get_streamId());
    }

    @Test
    public void testDeserialize_readingFromGzipBridge() throws Exception {
        GlobalStreamId id = new GlobalStreamId("first", "second");
        byte[] serialized = new GzipBridgeThriftSerializationDelegate().serialize((Object)id);
        GlobalStreamId id2 = (GlobalStreamId)this.testDelegate.deserialize(serialized, GlobalStreamId.class);
        Assert.assertEquals((Object)id2.get_componentId(), (Object)id.get_componentId());
        Assert.assertEquals((Object)id2.get_streamId(), (Object)id.get_streamId());
    }

    @Test
    public void testDeserialize_readingFromDefault() throws Exception {
        GlobalStreamId id = new GlobalStreamId("A", "B");
        byte[] serialized = new ThriftSerializationDelegate().serialize((Object)id);
        GlobalStreamId id2 = (GlobalStreamId)this.testDelegate.deserialize(serialized, GlobalStreamId.class);
        Assert.assertEquals((Object)id2.get_componentId(), (Object)id.get_componentId());
        Assert.assertEquals((Object)id2.get_streamId(), (Object)id.get_streamId());
    }
}

