/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import com.esotericsoftware.kryo.Kryo;
import java.util.Map;
import org.apache.storm.security.serialization.BlowfishTupleSerializer;
import org.apache.storm.serialization.SerializationFactory;
import org.apache.storm.utils.ListDelegate;
import org.apache.storm.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class SerializationFactoryTest {
    @Test
    public void test_registers_default_when_not_in_conf() throws ClassNotFoundException {
        Map conf = Utils.readDefaultConfig();
        String className = (String)conf.get("topology.tuple.serializer");
        Class<?> configuredClass = Class.forName(className);
        Kryo kryo = SerializationFactory.getKryo((Map)conf);
        Assert.assertEquals(configuredClass, kryo.getSerializer(ListDelegate.class).getClass());
    }

    @Test(expected=RuntimeException.class)
    public void test_throws_runtimeexception_when_no_such_class() {
        Map conf = Utils.readDefaultConfig();
        conf.put("topology.tuple.serializer", "null.this.class.does.not.exist");
        SerializationFactory.getKryo((Map)conf);
    }

    @Test
    public void test_registers_when_valid_class_name() {
        Class<BlowfishTupleSerializer> arbitraryClass = BlowfishTupleSerializer.class;
        String secretKey = "0123456789abcdef";
        Map conf = Utils.readDefaultConfig();
        conf.put("topology.tuple.serializer", arbitraryClass.getName());
        conf.put("topology.tuple.serializer.blowfish.key", secretKey);
        Kryo kryo = SerializationFactory.getKryo((Map)conf);
        Assert.assertEquals(arbitraryClass, kryo.getSerializer(ListDelegate.class).getClass());
    }
}

