/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.state;

import org.apache.storm.state.InMemoryKeyValueState;
import org.apache.storm.state.KeyValueState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InMemoryKeyValueStateTest {
    KeyValueState<String, String> keyValueState;

    @Before
    public void setUp() {
        this.keyValueState = new InMemoryKeyValueState();
    }

    @Test
    public void testPutAndGet() throws Exception {
        this.keyValueState.put((Object)"a", (Object)"1");
        this.keyValueState.put((Object)"b", (Object)"2");
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", null}, (Object[])this.getValues());
    }

    @Test
    public void testPutAndDelete() throws Exception {
        this.keyValueState.put((Object)"a", (Object)"1");
        this.keyValueState.put((Object)"b", (Object)"2");
        Assert.assertEquals((Object)"1", (Object)this.keyValueState.get((Object)"a"));
        Assert.assertEquals((Object)"2", (Object)this.keyValueState.get((Object)"b"));
        Assert.assertEquals(null, (Object)this.keyValueState.get((Object)"c"));
        Assert.assertEquals((Object)"1", (Object)this.keyValueState.delete((Object)"a"));
        Assert.assertEquals(null, (Object)this.keyValueState.get((Object)"a"));
        Assert.assertEquals((Object)"2", (Object)this.keyValueState.get((Object)"b"));
        Assert.assertEquals(null, (Object)this.keyValueState.get((Object)"c"));
    }

    @Test
    public void testPrepareCommitRollback() throws Exception {
        this.keyValueState.put((Object)"a", (Object)"1");
        this.keyValueState.put((Object)"b", (Object)"2");
        this.keyValueState.prepareCommit(1L);
        this.keyValueState.put((Object)"c", (Object)"3");
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])this.getValues());
        this.keyValueState.rollback();
        Assert.assertArrayEquals((Object[])new String[]{null, null, null}, (Object[])this.getValues());
        this.keyValueState.put((Object)"a", (Object)"1");
        this.keyValueState.put((Object)"b", (Object)"2");
        this.keyValueState.prepareCommit(1L);
        this.keyValueState.commit(1L);
        this.keyValueState.put((Object)"c", (Object)"3");
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])this.getValues());
        this.keyValueState.rollback();
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", null}, (Object[])this.getValues());
        this.keyValueState.put((Object)"c", (Object)"3");
        Assert.assertEquals((Object)"2", (Object)this.keyValueState.delete((Object)"b"));
        Assert.assertEquals((Object)"3", (Object)this.keyValueState.delete((Object)"c"));
        Assert.assertArrayEquals((Object[])new String[]{"1", null, null}, (Object[])this.getValues());
        this.keyValueState.prepareCommit(2L);
        Assert.assertArrayEquals((Object[])new String[]{"1", null, null}, (Object[])this.getValues());
        this.keyValueState.commit(2L);
        Assert.assertArrayEquals((Object[])new String[]{"1", null, null}, (Object[])this.getValues());
        this.keyValueState.put((Object)"b", (Object)"2");
        this.keyValueState.prepareCommit(3L);
        this.keyValueState.put((Object)"c", (Object)"3");
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])this.getValues());
        this.keyValueState.rollback();
        Assert.assertArrayEquals((Object[])new String[]{"1", null, null}, (Object[])this.getValues());
    }

    private String[] getValues() {
        return new String[]{(String)this.keyValueState.get((Object)"a"), (String)this.keyValueState.get((Object)"b"), (String)this.keyValueState.get((Object)"c")};
    }
}

