/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.storm.streams.Pair;
import org.apache.storm.streams.operations.PairValueJoiner;
import org.apache.storm.streams.operations.ValueJoiner;
import org.apache.storm.streams.processors.JoinProcessor;
import org.apache.storm.streams.processors.ProcessorContext;
import org.junit.Assert;
import org.junit.Test;

public class JoinProcessorTest {
    JoinProcessor<Integer, Pair<Integer, Integer>, Integer, Integer> joinProcessor;
    String leftStream = "left";
    String rightStream = "right";
    List<Pair<Integer, List<Pair<Integer, Integer>>>> res = new ArrayList<Pair<Integer, List<Pair<Integer, Integer>>>>();
    ProcessorContext context = new ProcessorContext(){

        public <T> void forward(T input) {
            JoinProcessorTest.this.res.add((Pair<Integer, List<Pair<Integer, Integer>>>)((Pair)input));
        }

        public <T> void forward(T input, String stream) {
        }

        public boolean isWindowed() {
            return true;
        }

        public Set<String> getWindowedParentStreams() {
            return null;
        }
    };
    List<Pair<Integer, Integer>> leftKeyValeus = Arrays.asList(Pair.of((Object)2, (Object)4), Pair.of((Object)5, (Object)25), Pair.of((Object)7, (Object)49));
    List<Pair<Integer, Integer>> rightKeyValues = Arrays.asList(Pair.of((Object)1, (Object)1), Pair.of((Object)2, (Object)8), Pair.of((Object)5, (Object)125), Pair.of((Object)6, (Object)216));

    @Test
    public void testInnerJoin() throws Exception {
        this.joinProcessor = new JoinProcessor(this.leftStream, this.rightStream, (ValueJoiner)new PairValueJoiner());
        this.processValues();
        Assert.assertEquals((Object)Pair.of((Object)2, (Object)Pair.of((Object)4, (Object)8)), this.res.get(0));
        Assert.assertEquals((Object)Pair.of((Object)5, (Object)Pair.of((Object)25, (Object)125)), this.res.get(1));
    }

    @Test
    public void testLeftOuterJoin() throws Exception {
        this.joinProcessor = new JoinProcessor(this.leftStream, this.rightStream, (ValueJoiner)new PairValueJoiner(), JoinProcessor.JoinType.OUTER, JoinProcessor.JoinType.INNER);
        this.processValues();
        Assert.assertEquals((Object)Pair.of((Object)2, (Object)Pair.of((Object)4, (Object)8)), this.res.get(0));
        Assert.assertEquals((Object)Pair.of((Object)5, (Object)Pair.of((Object)25, (Object)125)), this.res.get(1));
        Assert.assertEquals((Object)Pair.of((Object)7, (Object)Pair.of((Object)49, null)), this.res.get(2));
    }

    @Test
    public void testRightOuterJoin() throws Exception {
        this.joinProcessor = new JoinProcessor(this.leftStream, this.rightStream, (ValueJoiner)new PairValueJoiner(), JoinProcessor.JoinType.INNER, JoinProcessor.JoinType.OUTER);
        this.processValues();
        Assert.assertEquals((Object)Pair.of((Object)1, (Object)Pair.of(null, (Object)1)), this.res.get(0));
        Assert.assertEquals((Object)Pair.of((Object)2, (Object)Pair.of((Object)4, (Object)8)), this.res.get(1));
        Assert.assertEquals((Object)Pair.of((Object)5, (Object)Pair.of((Object)25, (Object)125)), this.res.get(2));
        Assert.assertEquals((Object)Pair.of((Object)6, (Object)Pair.of(null, (Object)216)), this.res.get(3));
    }

    @Test
    public void testFullOuterJoin() throws Exception {
        this.joinProcessor = new JoinProcessor(this.leftStream, this.rightStream, (ValueJoiner)new PairValueJoiner(), JoinProcessor.JoinType.OUTER, JoinProcessor.JoinType.OUTER);
        this.processValues();
        Assert.assertEquals((Object)Pair.of((Object)1, (Object)Pair.of(null, (Object)1)), this.res.get(0));
        Assert.assertEquals((Object)Pair.of((Object)2, (Object)Pair.of((Object)4, (Object)8)), this.res.get(1));
        Assert.assertEquals((Object)Pair.of((Object)5, (Object)Pair.of((Object)25, (Object)125)), this.res.get(2));
        Assert.assertEquals((Object)Pair.of((Object)6, (Object)Pair.of(null, (Object)216)), this.res.get(3));
        Assert.assertEquals((Object)Pair.of((Object)7, (Object)Pair.of((Object)49, null)), this.res.get(4));
    }

    private void processValues() {
        this.res.clear();
        this.joinProcessor.init(this.context);
        for (Pair<Integer, Integer> kv : this.leftKeyValeus) {
            this.joinProcessor.execute(kv, this.leftStream);
        }
        for (Pair<Integer, Integer> kv : this.rightKeyValues) {
            this.joinProcessor.execute(kv, this.rightStream);
        }
        this.joinProcessor.finish();
    }
}

