/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.tuple;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.storm.tuple.Fields;
import org.junit.Assert;
import org.junit.Test;

public class FieldsTest {
    @Test
    public void fieldsConstructorDoesNotThrowWithValidArgsTest() {
        Assert.assertEquals((long)new Fields(new String[]{"foo", "bar"}).size(), (long)2L);
        Assert.assertEquals((long)new Fields(new String[]{"foo", "bar"}).size(), (long)2L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void duplicateFieldsNotAllowedWhenConstructingWithVarArgsTest() {
        new Fields(new String[]{"foo", "bar", "foo"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void duplicateFieldsNotAllowedTestWhenConstructingFromListTest() {
        new Fields(new String[]{"foo", "bar", "foo"});
    }

    @Test
    public void getDoesNotThrowWithValidIndexTest() {
        Fields fields = new Fields(new String[]{"foo", "bar"});
        Assert.assertEquals((Object)fields.get(0), (Object)"foo");
        Assert.assertEquals((Object)fields.get(1), (Object)"bar");
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getThrowsWhenOutOfBoundsTest() {
        Fields fields = new Fields(new String[]{"foo", "bar"});
        fields.get(2);
    }

    @Test
    public void fieldIndexTest() {
        Fields fields = new Fields(new String[]{"foo", "bar"});
        Assert.assertEquals((long)fields.fieldIndex("foo"), (long)0L);
        Assert.assertEquals((long)fields.fieldIndex("bar"), (long)1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void fieldIndexThrowsWhenOutOfBoundsTest() {
        new Fields(new String[]{"foo"}).fieldIndex("baz");
    }

    @Test
    public void containsTest() {
        Fields fields = new Fields(new String[]{"foo", "bar"});
        Assert.assertTrue((boolean)fields.contains("foo"));
        Assert.assertTrue((boolean)fields.contains("bar"));
        Assert.assertFalse((boolean)fields.contains("baz"));
    }

    @Test
    public void toListTest() {
        Fields fields = new Fields(new String[]{"foo", "bar"});
        List fieldList = fields.toList();
        Assert.assertEquals((long)fieldList.size(), (long)2L);
        Assert.assertEquals(fieldList.get(0), (Object)"foo");
        Assert.assertEquals(fieldList.get(1), (Object)"bar");
    }

    @Test
    public void toIteratorTest() {
        Fields fields = new Fields(new String[]{"foo", "bar"});
        Iterator fieldIter = fields.iterator();
        Assert.assertTrue((String)"First item is foo", (boolean)fieldIter.hasNext());
        Assert.assertEquals(fieldIter.next(), (Object)"foo");
        Assert.assertTrue((String)"Second item is bar", (boolean)fieldIter.hasNext());
        Assert.assertEquals(fieldIter.next(), (Object)"bar");
        Assert.assertFalse((String)"At end. hasNext should return false", (boolean)fieldIter.hasNext());
    }

    @Test
    public void selectTest() {
        Fields fields = new Fields(new String[]{"foo", "bar"});
        List<Object> second = Arrays.asList("b");
        List<Object> tuple = Arrays.asList("a", "b", "c");
        List pickSecond = fields.select(new Fields(new String[]{"bar"}), tuple);
        Assert.assertTrue((boolean)pickSecond.equals(second));
        List<Object> secondAndFirst = Arrays.asList("b", "a");
        List pickSecondAndFirst = fields.select(new Fields(new String[]{"bar", "foo"}), tuple);
        Assert.assertTrue((boolean)pickSecondAndFirst.equals(secondAndFirst));
    }

    @Test(expected=IllegalArgumentException.class)
    public void selectingUnknownFieldThrowsTest() {
        Fields fields = new Fields(new String[]{"foo", "bar"});
        fields.select(new Fields(new String[]{"bar", "baz"}), Arrays.asList("a", "b", "c"));
    }
}

