/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.hooks.BaseWorkerHook;
import org.apache.storm.utils.ThriftTopologyUtils;
import org.apache.storm.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class ThriftTopologyUtilsTest
extends TestCase {
    @Test
    public void testIsWorkerHook() {
        Assert.assertEquals((Object)false, (Object)ThriftTopologyUtils.isWorkerHook((StormTopology._Fields)StormTopology._Fields.BOLTS));
        Assert.assertEquals((Object)false, (Object)ThriftTopologyUtils.isWorkerHook((StormTopology._Fields)StormTopology._Fields.SPOUTS));
        Assert.assertEquals((Object)false, (Object)ThriftTopologyUtils.isWorkerHook((StormTopology._Fields)StormTopology._Fields.STATE_SPOUTS));
        Assert.assertEquals((Object)false, (Object)ThriftTopologyUtils.isWorkerHook((StormTopology._Fields)StormTopology._Fields.DEPENDENCY_JARS));
        Assert.assertEquals((Object)false, (Object)ThriftTopologyUtils.isWorkerHook((StormTopology._Fields)StormTopology._Fields.DEPENDENCY_ARTIFACTS));
        Assert.assertEquals((Object)true, (Object)ThriftTopologyUtils.isWorkerHook((StormTopology._Fields)StormTopology._Fields.WORKER_HOOKS));
    }

    @Test
    public void testIsDependencies() {
        Assert.assertEquals((Object)false, (Object)ThriftTopologyUtils.isDependencies((StormTopology._Fields)StormTopology._Fields.BOLTS));
        Assert.assertEquals((Object)false, (Object)ThriftTopologyUtils.isDependencies((StormTopology._Fields)StormTopology._Fields.SPOUTS));
        Assert.assertEquals((Object)false, (Object)ThriftTopologyUtils.isDependencies((StormTopology._Fields)StormTopology._Fields.STATE_SPOUTS));
        Assert.assertEquals((Object)false, (Object)ThriftTopologyUtils.isDependencies((StormTopology._Fields)StormTopology._Fields.WORKER_HOOKS));
        Assert.assertEquals((Object)true, (Object)ThriftTopologyUtils.isDependencies((StormTopology._Fields)StormTopology._Fields.DEPENDENCY_JARS));
        Assert.assertEquals((Object)true, (Object)ThriftTopologyUtils.isDependencies((StormTopology._Fields)StormTopology._Fields.DEPENDENCY_ARTIFACTS));
    }

    @Test
    public void testGetComponentIdsWithWorkerHook() {
        StormTopology stormTopology = this.genereateStormTopology(true);
        Set componentIds = ThriftTopologyUtils.getComponentIds((StormTopology)stormTopology);
        Assert.assertEquals((String)"We expect to get the IDs of the components sans the Worker Hook", (Object)ImmutableSet.of((Object)"bolt-1", (Object)"spout-1"), (Object)componentIds);
    }

    @Test
    public void testGetComponentIdsWithoutWorkerHook() {
        StormTopology stormTopology = this.genereateStormTopology(false);
        Set componentIds = ThriftTopologyUtils.getComponentIds((StormTopology)stormTopology);
        Assert.assertEquals((String)"We expect to get the IDs of the components sans the Worker Hook", (Object)ImmutableSet.of((Object)"bolt-1", (Object)"spout-1"), (Object)componentIds);
    }

    @Test
    public void testGetComponentCommonWithWorkerHook() {
        StormTopology stormTopology = this.genereateStormTopology(true);
        ComponentCommon componentCommon = ThriftTopologyUtils.getComponentCommon((StormTopology)stormTopology, (String)"bolt-1");
        Assert.assertEquals((String)"We expect to get bolt-1's common", (Object)new Bolt().get_common(), (Object)componentCommon);
    }

    @Test
    public void testGetComponentCommonWithoutWorkerHook() {
        StormTopology stormTopology = this.genereateStormTopology(false);
        ComponentCommon componentCommon = ThriftTopologyUtils.getComponentCommon((StormTopology)stormTopology, (String)"bolt-1");
        Assert.assertEquals((String)"We expect to get bolt-1's common", (Object)new Bolt().get_common(), (Object)componentCommon);
    }

    private StormTopology genereateStormTopology(boolean withWorkerHook) {
        ImmutableMap spouts = ImmutableMap.of((Object)"spout-1", (Object)new SpoutSpec());
        ImmutableMap bolts = ImmutableMap.of((Object)"bolt-1", (Object)new Bolt());
        ImmutableMap state_spouts = ImmutableMap.of();
        StormTopology stormTopology = new StormTopology((Map)spouts, (Map)bolts, (Map)state_spouts);
        if (withWorkerHook) {
            BaseWorkerHook workerHook = new BaseWorkerHook();
            stormTopology.add_to_worker_hooks(ByteBuffer.wrap(Utils.javaSerialize((Object)workerHook)));
        }
        return stormTopology;
    }
}

