/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import org.apache.storm.utils.Time;
import org.junit.Assert;
import org.junit.Test;

public class TimeTest {
    @Test
    public void secsToMillisLongTest() {
        Assert.assertEquals((long)Time.secsToMillisLong((double)0.0), (long)0L);
        Assert.assertEquals((long)Time.secsToMillisLong((double)0.002), (long)2L);
        Assert.assertEquals((long)Time.secsToMillisLong((double)1.0), (long)1000L);
        Assert.assertEquals((long)Time.secsToMillisLong((double)1.08), (long)1080L);
        Assert.assertEquals((long)Time.secsToMillisLong((double)10.0), (long)10000L);
        Assert.assertEquals((long)Time.secsToMillisLong((double)10.1), (long)10100L);
    }

    @Test(expected=IllegalStateException.class)
    public void ifNotSimulatingAdvanceTimeThrowsTest() {
        Time.advanceTime((long)1000L);
    }

    @Test
    public void isSimulatingReturnsTrueDuringSimulationTest() {
        Assert.assertFalse((boolean)Time.isSimulating());
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            Assert.assertTrue((boolean)Time.isSimulating());
        }
    }

    @Test
    public void shouldNotAdvanceTimeTest() {
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            long current = Time.currentTimeMillis();
            Time.advanceTime((long)0L);
            Assert.assertEquals((long)Time.deltaMs((long)current), (long)0L);
        }
    }

    @Test
    public void shouldAdvanceForwardTest() {
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            long current = Time.currentTimeMillis();
            Time.advanceTime((long)1000L);
            Assert.assertEquals((long)Time.deltaMs((long)current), (long)1000L);
            Time.advanceTime((long)500L);
            Assert.assertEquals((long)Time.deltaMs((long)current), (long)1500L);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfAttemptToAdvanceBackwardsTest() {
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            Time.advanceTime((long)-1500L);
        }
    }

    @Test
    public void deltaSecsConvertsToSecondsTest() {
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            int current = Time.currentTimeSecs();
            Time.advanceTime((long)1000L);
            Assert.assertEquals((long)Time.deltaSecs((int)current), (long)1L);
        }
    }

    @Test
    public void deltaSecsTruncatesFractionalSecondsTest() {
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            int current = Time.currentTimeSecs();
            Time.advanceTime((long)1500L);
            Assert.assertEquals((float)Time.deltaSecs((int)current), (float)1.0f, (float)0.0f);
        }
    }
}

