/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;
import org.apache.thrift.transport.TTransportException;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void isZkAuthenticationConfiguredTopologyTest() {
        Assert.assertFalse((String)"Returns null if given null config", (boolean)Utils.isZkAuthenticationConfiguredTopology(null));
        Assert.assertFalse((String)"Returns false if scheme key is missing", (boolean)Utils.isZkAuthenticationConfiguredTopology((Map)this.emptyMockMap()));
        Assert.assertFalse((String)"Returns false if scheme value is null", (boolean)Utils.isZkAuthenticationConfiguredTopology((Map)this.topologyMockMap(null)));
        Assert.assertTrue((String)"Returns true if scheme value is string", (boolean)Utils.isZkAuthenticationConfiguredTopology((Map)this.topologyMockMap("foobar")));
    }

    private Map topologyMockMap(String value) {
        return this.mockMap("storm.zookeeper.topology.auth.scheme", value);
    }

    private Map mockMap(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        return map;
    }

    private Map serverMockMap(String value) {
        return this.mockMap("storm.zookeeper.auth.scheme", value);
    }

    private Map emptyMockMap() {
        return new HashMap();
    }

    @Test
    public void parseJvmHeapMemByChildOptsTest() {
        Assert.assertEquals((String)"1024K results in 1 MB", (double)Utils.parseJvmHeapMemByChildOpts((String)"Xmx1024K", (Double)0.0), (double)1.0, (double)0.0);
        Assert.assertEquals((String)"100M results in 100 MB", (double)Utils.parseJvmHeapMemByChildOpts((String)"Xmx100M", (Double)0.0), (double)100.0, (double)0.0);
        Assert.assertEquals((String)"1G results in 1024 MB", (double)Utils.parseJvmHeapMemByChildOpts((String)"Xmx1G", (Double)0.0), (double)1024.0, (double)0.0);
        Assert.assertEquals((String)"Unmatched value results in default", (double)Utils.parseJvmHeapMemByChildOpts((String)"Xmx1T", (Double)123.0), (double)123.0, (double)0.0);
        Assert.assertEquals((String)"Null value results in default", (double)Utils.parseJvmHeapMemByChildOpts(null, (Double)123.0), (double)123.0, (double)0.0);
    }

    public void getConfiguredClientThrowsRuntimeExceptionOnBadArgsTest() throws TTransportException {
        Map config = ConfigUtils.readStormConfig();
        config.put("storm.nimbus.retry.times", 0);
        try {
            new NimbusClient(config, "", 65535);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("Cause is not TTransportException " + e), (boolean)Utils.exceptionCauseIsInstanceOf(TTransportException.class, (Throwable)e));
        }
    }

    @Test
    public void isZkAuthenticationConfiguredStormServerTest() {
        Assert.assertFalse((String)"Returns false if given null config", (boolean)Utils.isZkAuthenticationConfiguredStormServer(null));
        Assert.assertFalse((String)"Returns false if scheme key is missing", (boolean)Utils.isZkAuthenticationConfiguredStormServer((Map)this.emptyMockMap()));
        Assert.assertFalse((String)"Returns false if scheme value is null", (boolean)Utils.isZkAuthenticationConfiguredStormServer((Map)this.serverMockMap(null)));
        Assert.assertTrue((String)"Returns true if scheme value is string", (boolean)Utils.isZkAuthenticationConfiguredStormServer((Map)this.serverMockMap("foobar")));
    }

    @Test
    public void isZkAuthenticationConfiguredStormServerWithPropertyTest() {
        String key = "java.security.auth.login.config";
        String oldValue = System.getProperty(key);
        try {
            System.setProperty("java.security.auth.login.config", "anything");
            Assert.assertTrue((boolean)Utils.isZkAuthenticationConfiguredStormServer((Map)this.emptyMockMap()));
        }
        finally {
            if (oldValue == null) {
                System.clearProperty(key);
            } else {
                System.setProperty(key, oldValue);
            }
        }
    }
}

