/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.windowing.Event;
import org.apache.storm.windowing.WaterMarkEventGenerator;
import org.apache.storm.windowing.WindowManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WaterMarkEventGeneratorTest {
    WaterMarkEventGenerator<Integer> waterMarkEventGenerator;
    WindowManager<Integer> windowManager;
    List<Event<Integer>> eventList = new ArrayList<Event<Integer>>();

    private GlobalStreamId streamId(String component) {
        return new GlobalStreamId(component, "default");
    }

    @Before
    public void setUp() {
        this.windowManager = new WindowManager<Integer>(null){

            public void add(Event<Integer> event) {
                WaterMarkEventGeneratorTest.this.eventList.add(event);
            }
        };
        this.waterMarkEventGenerator = new WaterMarkEventGenerator(this.windowManager, 100000, 5, Collections.singleton(this.streamId("s1")));
        this.waterMarkEventGenerator.start();
    }

    @Test
    public void testTrackSingleStream() throws Exception {
        this.waterMarkEventGenerator.track(this.streamId("s1"), 100L);
        this.waterMarkEventGenerator.track(this.streamId("s1"), 110L);
        this.waterMarkEventGenerator.run();
        Assert.assertTrue((boolean)this.eventList.get(0).isWatermark());
        Assert.assertEquals((long)105L, (long)this.eventList.get(0).getTimestamp());
    }

    @Test
    public void testTrackSingleStreamOutOfOrder() throws Exception {
        this.waterMarkEventGenerator.track(this.streamId("s1"), 100L);
        this.waterMarkEventGenerator.track(this.streamId("s1"), 110L);
        this.waterMarkEventGenerator.track(this.streamId("s1"), 104L);
        this.waterMarkEventGenerator.run();
        Assert.assertTrue((boolean)this.eventList.get(0).isWatermark());
        Assert.assertEquals((long)105L, (long)this.eventList.get(0).getTimestamp());
    }

    @Test
    public void testTrackTwoStreams() throws Exception {
        HashSet<GlobalStreamId> streams = new HashSet<GlobalStreamId>();
        streams.add(this.streamId("s1"));
        streams.add(this.streamId("s2"));
        this.waterMarkEventGenerator = new WaterMarkEventGenerator(this.windowManager, 100000, 5, streams);
        this.waterMarkEventGenerator.track(this.streamId("s1"), 100L);
        this.waterMarkEventGenerator.track(this.streamId("s1"), 110L);
        this.waterMarkEventGenerator.run();
        Assert.assertTrue((boolean)this.eventList.isEmpty());
        this.waterMarkEventGenerator.track(this.streamId("s2"), 95L);
        this.waterMarkEventGenerator.track(this.streamId("s2"), 98L);
        this.waterMarkEventGenerator.run();
        Assert.assertTrue((boolean)this.eventList.get(0).isWatermark());
        Assert.assertEquals((long)93L, (long)this.eventList.get(0).getTimestamp());
    }

    @Test
    public void testNoEvents() throws Exception {
        this.waterMarkEventGenerator.run();
        Assert.assertTrue((boolean)this.eventList.isEmpty());
    }

    @Test
    public void testLateEvent() throws Exception {
        Assert.assertTrue((boolean)this.waterMarkEventGenerator.track(this.streamId("s1"), 100L));
        Assert.assertTrue((boolean)this.waterMarkEventGenerator.track(this.streamId("s1"), 110L));
        this.waterMarkEventGenerator.run();
        Assert.assertTrue((boolean)this.eventList.get(0).isWatermark());
        Assert.assertEquals((long)105L, (long)this.eventList.get(0).getTimestamp());
        this.eventList.clear();
        Assert.assertTrue((boolean)this.waterMarkEventGenerator.track(this.streamId("s1"), 105L));
        Assert.assertTrue((boolean)this.waterMarkEventGenerator.track(this.streamId("s1"), 106L));
        Assert.assertTrue((boolean)this.waterMarkEventGenerator.track(this.streamId("s1"), 115L));
        Assert.assertFalse((boolean)this.waterMarkEventGenerator.track(this.streamId("s1"), 104L));
        this.waterMarkEventGenerator.run();
        Assert.assertTrue((boolean)this.eventList.get(0).isWatermark());
        Assert.assertEquals((long)110L, (long)this.eventList.get(0).getTimestamp());
    }
}

