/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWriter
extends Thread {
    private Logger logger;
    private BufferedReader in;

    public LogWriter(InputStream in, Logger logger) {
        this.in = new BufferedReader(new InputStreamReader(in));
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Logger logger = this.logger;
        BufferedReader in = this.in;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                logger.info(line);
            }
        }
        catch (IOException e) {
            logger.error("Internal ERROR", (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error("Internal ERROR", (Throwable)e);
            }
        }
    }

    public void close() throws Exception {
        this.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(args);
        Process p = pb.start();
        LogWriter err = null;
        LogWriter in = null;
        int ret = -1;
        try {
            Logger logger = LoggerFactory.getLogger((String)"STDERR");
            err = new LogWriter(p.getErrorStream(), logger);
            err.start();
            in = new LogWriter(p.getInputStream(), logger);
            in.start();
            ret = p.waitFor();
        }
        finally {
            if (err != null) {
                err.close();
            }
            if (in != null) {
                in.close();
            }
        }
        System.exit(ret);
    }
}

