/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cluster;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.storm.cluster.ExecutorBeat;
import org.apache.storm.cluster.VersionedData;
import org.apache.storm.generated.Assignment;
import org.apache.storm.generated.ClusterWorkerHeartbeat;
import org.apache.storm.generated.Credentials;
import org.apache.storm.generated.ErrorInfo;
import org.apache.storm.generated.ExecutorInfo;
import org.apache.storm.generated.LogConfig;
import org.apache.storm.generated.NimbusSummary;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.generated.ProfileRequest;
import org.apache.storm.generated.StormBase;
import org.apache.storm.generated.SupervisorInfo;
import org.apache.storm.nimbus.NimbusInfo;

public interface IStormClusterState {
    public List<String> assignments(Runnable var1);

    public Assignment assignmentInfo(String var1, Runnable var2);

    public VersionedData<Assignment> assignmentInfoWithVersion(String var1, Runnable var2);

    public Integer assignmentVersion(String var1, Runnable var2) throws Exception;

    public List<String> blobstoreInfo(String var1);

    public List<NimbusSummary> nimbuses();

    public void addNimbusHost(String var1, NimbusSummary var2);

    public List<String> activeStorms();

    public StormBase stormBase(String var1, Runnable var2);

    public ClusterWorkerHeartbeat getWorkerHeartbeat(String var1, String var2, Long var3);

    public List<ProfileRequest> getWorkerProfileRequests(String var1, NodeInfo var2);

    public List<ProfileRequest> getTopologyProfileRequests(String var1);

    public void setWorkerProfileRequest(String var1, ProfileRequest var2);

    public void deleteTopologyProfileRequests(String var1, ProfileRequest var2);

    public Map<ExecutorInfo, ExecutorBeat> executorBeats(String var1, Map<List<Long>, NodeInfo> var2);

    public List<String> supervisors(Runnable var1);

    public SupervisorInfo supervisorInfo(String var1);

    public void setupHeatbeats(String var1);

    public void teardownHeartbeats(String var1);

    public void teardownTopologyErrors(String var1);

    public List<String> heartbeatStorms();

    public List<String> errorTopologies();

    public List<String> backpressureTopologies();

    public void setTopologyLogConfig(String var1, LogConfig var2);

    public LogConfig topologyLogConfig(String var1, Runnable var2);

    public void workerHeartbeat(String var1, String var2, Long var3, ClusterWorkerHeartbeat var4);

    public void removeWorkerHeartbeat(String var1, String var2, Long var3);

    public void supervisorHeartbeat(String var1, SupervisorInfo var2);

    public void workerBackpressure(String var1, String var2, Long var3, boolean var4);

    public boolean topologyBackpressure(String var1, Runnable var2);

    public void setupBackpressure(String var1);

    public void removeBackpressure(String var1);

    public void removeWorkerBackpressure(String var1, String var2, Long var3);

    public void activateStorm(String var1, StormBase var2);

    public void updateStorm(String var1, StormBase var2);

    public void removeStormBase(String var1);

    public void setAssignment(String var1, Assignment var2);

    public void setupBlobstore(String var1, NimbusInfo var2, Integer var3);

    public List<String> activeKeys();

    public List<String> blobstore(Runnable var1);

    public void removeStorm(String var1);

    public void removeBlobstoreKey(String var1);

    public void removeKeyVersion(String var1);

    public void reportError(String var1, String var2, String var3, Long var4, Throwable var5);

    public List<ErrorInfo> errors(String var1, String var2);

    public ErrorInfo lastError(String var1, String var2);

    public void setCredentials(String var1, Credentials var2, Map<String, Object> var3) throws NoSuchAlgorithmException;

    public Credentials credentials(String var1, Runnable var2);

    public void disconnect();

    default public Map<String, SupervisorInfo> allSupervisorInfo() {
        return this.allSupervisorInfo(null);
    }

    default public Map<String, SupervisorInfo> allSupervisorInfo(Runnable callback) {
        HashMap<String, SupervisorInfo> ret = new HashMap<String, SupervisorInfo>();
        for (String id : this.supervisors(callback)) {
            ret.put(id, this.supervisorInfo(id));
        }
        return ret;
    }

    default public Optional<String> getTopoId(String topologyName) {
        String ret = null;
        for (String topoId : this.activeStorms()) {
            String name = this.stormBase(topoId, null).get_name();
            if (!topologyName.equals(name)) continue;
            ret = topoId;
            break;
        }
        return Optional.ofNullable(ret);
    }

    default public Map<String, Assignment> topologyAssignments() {
        HashMap<String, Assignment> ret = new HashMap<String, Assignment>();
        for (String topoId : this.assignments(null)) {
            ret.put(topoId, this.assignmentInfo(topoId, null));
        }
        return ret;
    }

    default public Map<String, StormBase> topologyBases() {
        HashMap<String, StormBase> stormBases = new HashMap<String, StormBase>();
        for (String topologyId : this.activeStorms()) {
            StormBase base = this.stormBase(topologyId, null);
            if (base == null) continue;
            stormBases.put(topologyId, base);
        }
        return stormBases;
    }
}

