/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.cgroup;

import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgroupUtils {
    public static final String CGROUP_STATUS_FILE = "/proc/cgroups";
    public static final String MOUNT_STATUS_FILE = "/proc/mounts";
    private static final Logger LOG = LoggerFactory.getLogger(CgroupUtils.class);

    public static void deleteDir(String dir) {
        File d = new File(dir);
        if (!d.exists()) {
            LOG.warn("dir {} does not exist!", (Object)dir);
            return;
        }
        if (!d.isDirectory()) {
            throw new RuntimeException("dir " + dir + " is not a directory!");
        }
        if (!d.delete()) {
            throw new RuntimeException("Cannot delete dir " + dir);
        }
    }

    public static Set<SubSystemType> getSubSystemsFromString(String str) {
        String[] subSystems;
        HashSet<SubSystemType> result2 = new HashSet<SubSystemType>();
        for (String subSystem : subSystems = str.split(",")) {
            SubSystemType type = SubSystemType.getSubSystem(subSystem);
            if (type == null) continue;
            result2.add(type);
        }
        return result2;
    }

    public static String subSystemsToString(Set<SubSystemType> subSystems) {
        StringBuilder sb = new StringBuilder();
        if (subSystems.size() == 0) {
            return sb.toString();
        }
        for (SubSystemType type : subSystems) {
            sb.append(type.name()).append(",");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static boolean enabled() {
        return Utils.checkFileExists(CGROUP_STATUS_FILE);
    }

    public static List<String> readFileByLine(String filePath) throws IOException {
        return Files.readLines((File)new File(filePath), (Charset)Charset.defaultCharset());
    }

    public static void writeFileByLine(String filePath, List<String> linesToWrite) throws IOException {
        LOG.debug("For CGroups - writing {} to {} ", linesToWrite, (Object)filePath);
        File file = new File(filePath);
        if (!file.exists()) {
            LOG.error("{} does not exist", (Object)filePath);
            return;
        }
        try (FileWriter writer = new FileWriter(file, true);
             BufferedWriter bw = new BufferedWriter(writer);){
            for (String string : linesToWrite) {
                bw.write(string);
                bw.newLine();
                bw.flush();
            }
        }
    }

    public static void writeFileByLine(String filePath, String lineToWrite) throws IOException {
        CgroupUtils.writeFileByLine(filePath, Arrays.asList(lineToWrite));
    }

    public static String getDir(String dir, String constant) {
        return dir + constant;
    }
}

