/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.storm.Thrift;
import org.apache.storm.daemon.GrouperFactory;
import org.apache.storm.daemon.metrics.BuiltinMetrics;
import org.apache.storm.daemon.metrics.BuiltinMetricsUtil;
import org.apache.storm.daemon.worker.WorkerState;
import org.apache.storm.executor.Executor;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.ComponentObject;
import org.apache.storm.generated.JavaObject;
import org.apache.storm.generated.ShellComponent;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StateSpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.grouping.LoadAwareCustomStreamGrouping;
import org.apache.storm.grouping.LoadMapping;
import org.apache.storm.hooks.ITaskHook;
import org.apache.storm.hooks.info.EmitInfo;
import org.apache.storm.spout.ShellSpout;
import org.apache.storm.stats.CommonStats;
import org.apache.storm.task.ShellBolt;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task {
    private static final Logger LOG = LoggerFactory.getLogger(Task.class);
    private Executor executor;
    private WorkerState workerData;
    private TopologyContext systemTopologyContext;
    private TopologyContext userTopologyContext;
    private WorkerTopologyContext workerTopologyContext;
    private LoadMapping loadMapping;
    private Integer taskId;
    private String componentId;
    private Object taskObject;
    private Map<String, Object> topoConf;
    private Callable<Boolean> emitSampler;
    private CommonStats executorStats;
    private Map<String, Map<String, LoadAwareCustomStreamGrouping>> streamComponentToGrouper;
    private BuiltinMetrics builtInMetrics;
    private boolean debug;

    public Task(Executor executor, Integer taskId) throws IOException {
        this.taskId = taskId;
        this.executor = executor;
        this.workerData = executor.getWorkerData();
        this.topoConf = executor.getStormConf();
        this.componentId = executor.getComponentId();
        this.streamComponentToGrouper = executor.getStreamToComponentToGrouper();
        this.executorStats = executor.getStats();
        this.builtInMetrics = BuiltinMetricsUtil.mkData(executor.getType(), this.executorStats);
        this.workerTopologyContext = executor.getWorkerTopologyContext();
        this.emitSampler = ConfigUtils.mkStatsSampler(this.topoConf);
        this.loadMapping = this.workerData.getLoadMapping();
        this.systemTopologyContext = this.mkTopologyContext(this.workerData.getSystemTopology());
        this.userTopologyContext = this.mkTopologyContext(this.workerData.getTopology());
        this.taskObject = this.mkTaskObject();
        this.debug = this.topoConf.containsKey("topology.debug") && (Boolean)this.topoConf.get("topology.debug") != false;
        this.addTaskHooks();
    }

    public List<Integer> getOutgoingTasks(Integer outTaskId, String stream, List<Object> values) {
        if (this.debug) {
            LOG.info("Emitting direct: {}; {} {} {} ", new Object[]{outTaskId, this.componentId, stream, values});
        }
        String targetComponent = this.workerTopologyContext.getComponentId(outTaskId);
        Map<String, LoadAwareCustomStreamGrouping> componentGrouping = this.streamComponentToGrouper.get(stream);
        LoadAwareCustomStreamGrouping grouping = componentGrouping.get(targetComponent);
        if (null == grouping) {
            outTaskId = null;
        }
        if (grouping != null && grouping != GrouperFactory.DIRECT) {
            throw new IllegalArgumentException("Cannot emitDirect to a task expecting a regular grouping");
        }
        new EmitInfo(values, stream, this.taskId, Collections.singletonList(outTaskId)).applyOn(this.userTopologyContext);
        try {
            if (this.emitSampler.call().booleanValue()) {
                this.executorStats.emittedTuple(stream);
                if (null != outTaskId) {
                    this.executorStats.transferredTuples(stream, 1);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (null != outTaskId) {
            return Collections.singletonList(outTaskId);
        }
        return new ArrayList<Integer>(0);
    }

    public List<Integer> getOutgoingTasks(String stream, List<Object> values) {
        if (this.debug) {
            LOG.info("Emitting: {} {} {}", new Object[]{this.componentId, stream, values});
        }
        ArrayList<Integer> outTasks = new ArrayList<Integer>();
        if (!this.streamComponentToGrouper.containsKey(stream)) {
            throw new IllegalArgumentException("Unknown stream ID: " + stream);
        }
        if (null != this.streamComponentToGrouper.get(stream)) {
            for (LoadAwareCustomStreamGrouping grouper : this.streamComponentToGrouper.get(stream).values()) {
                if (grouper == GrouperFactory.DIRECT) {
                    throw new IllegalArgumentException("Cannot do regular emit to direct stream");
                }
                List<Integer> compTasks = grouper.chooseTasks(this.taskId, values, this.loadMapping);
                outTasks.addAll(compTasks);
            }
        }
        new EmitInfo(values, stream, this.taskId, outTasks).applyOn(this.userTopologyContext);
        try {
            if (this.emitSampler.call().booleanValue()) {
                this.executorStats.emittedTuple(stream);
                this.executorStats.transferredTuples(stream, outTasks.size());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return outTasks;
    }

    public Tuple getTuple(String stream, List values) {
        return new TupleImpl(this.systemTopologyContext, values, this.systemTopologyContext.getThisTaskId(), stream);
    }

    public Integer getTaskId() {
        return this.taskId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public TopologyContext getUserContext() {
        return this.userTopologyContext;
    }

    public Object getTaskObject() {
        return this.taskObject;
    }

    public BuiltinMetrics getBuiltInMetrics() {
        return this.builtInMetrics;
    }

    private TopologyContext mkTopologyContext(StormTopology topology) throws IOException {
        Map conf = this.workerData.getConf();
        return new TopologyContext(topology, this.workerData.getTopologyConf(), this.workerData.getTaskToComponent(), this.workerData.getComponentToSortedTasks(), this.workerData.getComponentToStreamToFields(), this.workerData.getTopologyId(), ConfigUtils.supervisorStormResourcesPath(ConfigUtils.supervisorStormDistRoot(conf, this.workerData.getTopologyId())), ConfigUtils.workerPidsRoot(conf, this.workerData.getWorkerId()), this.taskId, this.workerData.getPort(), this.workerData.getTaskIds(), this.workerData.getDefaultSharedResources(), this.workerData.getUserSharedResources(), this.executor.getSharedExecutorData(), this.executor.getIntervalToTaskToMetricToRegistry(), this.executor.getOpenOrPrepareWasCalled());
    }

    private Object mkTaskObject() {
        ComponentObject componentObject;
        StormTopology topology = this.systemTopologyContext.getRawTopology();
        Map<String, SpoutSpec> spouts = topology.get_spouts();
        Map<String, Bolt> bolts = topology.get_bolts();
        Map<String, StateSpoutSpec> stateSpouts = topology.get_state_spouts();
        if (spouts.containsKey(this.componentId)) {
            componentObject = spouts.get(this.componentId).get_spout_object();
        } else if (bolts.containsKey(this.componentId)) {
            componentObject = bolts.get(this.componentId).get_bolt_object();
        } else if (stateSpouts.containsKey(this.componentId)) {
            componentObject = stateSpouts.get(this.componentId).get_state_spout_object();
        } else {
            throw new RuntimeException("Could not find " + this.componentId + " in " + topology);
        }
        Object result2 = Utils.getSetComponentObject(componentObject);
        if (result2 instanceof ShellComponent) {
            result2 = spouts.containsKey(this.componentId) ? new ShellSpout((ShellComponent)result2) : new ShellBolt((ShellComponent)result2);
        }
        if (result2 instanceof JavaObject) {
            result2 = Thrift.instantiateJavaObject((JavaObject)result2);
        }
        return result2;
    }

    private void addTaskHooks() {
        List hooksClassList = (List)this.topoConf.get("topology.auto.task.hooks");
        if (null != hooksClassList) {
            for (String hookClass : hooksClassList) {
                try {
                    this.userTopologyContext.addTaskHook((ITaskHook)Class.forName(hookClass).newInstance());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Failed to add hook: " + hookClass, e);
                }
            }
        }
    }
}

