/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.metrics;

import org.apache.storm.daemon.metrics.BuiltinMetrics;
import org.apache.storm.metric.internal.MultiCountStatAndMetric;
import org.apache.storm.metric.internal.MultiLatencyStatAndMetric;
import org.apache.storm.stats.SpoutExecutorStats;

public class BuiltinSpoutMetrics
extends BuiltinMetrics {
    private final MultiCountStatAndMetric ackCount;
    private final MultiCountStatAndMetric failCount;
    private final MultiCountStatAndMetric emitCount;
    private final MultiCountStatAndMetric transferCount;
    private final MultiLatencyStatAndMetric completeLatency;

    public BuiltinSpoutMetrics(SpoutExecutorStats stats) {
        this.ackCount = stats.getAcked();
        this.failCount = stats.getFailed();
        this.emitCount = stats.getEmitted();
        this.transferCount = stats.getTransferred();
        this.completeLatency = stats.getCompleteLatencies();
        this.metricMap.put("ack-count", this.ackCount);
        this.metricMap.put("fail-count", this.failCount);
        this.metricMap.put("emit-count", this.emitCount);
        this.metricMap.put("transfer-count", this.transferCount);
        this.metricMap.put("complete-latency", this.completeLatency);
    }

    public MultiCountStatAndMetric getAckCount() {
        return this.ackCount;
    }

    public MultiCountStatAndMetric getFailCount() {
        return this.failCount;
    }

    public MultiCountStatAndMetric getEmitCount() {
        return this.emitCount;
    }

    public MultiCountStatAndMetric getTransferCount() {
        return this.transferCount;
    }

    public MultiLatencyStatAndMetric getCompleteLatency() {
        return this.completeLatency;
    }
}

