/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.daemon.supervisor.IAdvancedFSOps;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedFSOps
implements IAdvancedFSOps {
    private static final Logger LOG = LoggerFactory.getLogger(AdvancedFSOps.class);
    protected final boolean _symlinksDisabled;

    public static AdvancedFSOps make(Map<String, Object> conf) {
        if (Utils.isOnWindows()) {
            return new AdvancedWindowsFSOps(conf);
        }
        if (ObjectReader.getBoolean(conf.get("supervisor.run.worker.as.user"), false)) {
            return new AdvancedRunAsUserFSOps(conf);
        }
        return new AdvancedFSOps(conf);
    }

    protected AdvancedFSOps(Map<String, Object> conf) {
        this._symlinksDisabled = (Boolean)conf.getOrDefault("storm.disable.symlinks", false);
    }

    @Override
    public void restrictDirectoryPermissions(File dir) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE));
        Files.setPosixFilePermissions(dir.toPath(), perms);
    }

    @Override
    public void moveDirectoryPreferAtomic(File fromDir, File toDir) throws IOException {
        FileUtils.forceMkdir((File)toDir);
        Files.move(fromDir.toPath(), toDir.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    @Override
    public boolean supportsAtomicDirectoryMove() {
        return true;
    }

    @Override
    public void copyDirectory(File fromDir, File toDir) throws IOException {
        FileUtils.copyDirectory((File)fromDir, (File)toDir);
    }

    @Override
    public void setupBlobPermissions(File path, String user) throws IOException {
    }

    @Override
    public void deleteIfExists(File path, String user, String logPrefix) throws IOException {
        this.deleteIfExists(path);
    }

    @Override
    public void deleteIfExists(File path) throws IOException {
        LOG.info("Deleting path {}", (Object)path);
        Path p = path.toPath();
        if (Files.exists(p, new LinkOption[0])) {
            try {
                FileUtils.forceDelete((File)path);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setupStormCodeDir(Map<String, Object> topologyConf, File path) throws IOException {
    }

    @Override
    public void setupWorkerArtifactsDir(Map<String, Object> topologyConf, File path) throws IOException {
    }

    @Override
    public boolean doRequiredTopoFilesExist(Map<String, Object> conf, String topologyId) throws IOException {
        return ClientSupervisorUtils.doRequiredTopoFilesExist(conf, topologyId);
    }

    @Override
    public void forceMkdir(File path) throws IOException {
        FileUtils.forceMkdir((File)path);
    }

    @Override
    public boolean fileExists(File path) throws IOException {
        return path.exists();
    }

    @Override
    public Writer getWriter(File file) throws IOException {
        return new FileWriter(file);
    }

    @Override
    public OutputStream getOutputStream(File file) throws IOException {
        return new FileOutputStream(file);
    }

    @Override
    public void dump(File location, String data) throws IOException {
        File parent = location.getParentFile();
        if (!parent.exists()) {
            this.forceMkdir(parent);
        }
        try (Writer w = this.getWriter(location);){
            w.write(data);
        }
    }

    @Override
    public String slurpString(File location) throws IOException {
        return FileUtils.readFileToString((File)location, (String)"UTF-8");
    }

    @Override
    public byte[] slurp(File location) throws IOException {
        return FileUtils.readFileToByteArray((File)location);
    }

    @Override
    public void createSymlink(File link, File target) throws IOException {
        if (this._symlinksDisabled) {
            throw new IOException("Symlinks have been disabled, this should not be called");
        }
        Path plink = link.toPath().toAbsolutePath();
        Path ptarget = target.toPath().toAbsolutePath();
        LOG.debug("Creating symlink [{}] to [{}]", (Object)plink, (Object)ptarget);
        if (Files.exists(plink, new LinkOption[0])) {
            if (Files.isSameFile(plink, ptarget)) {
                return;
            }
            FileUtils.forceDelete((File)link);
        }
        Files.createSymbolicLink(plink, ptarget, new FileAttribute[0]);
    }

    private static class AdvancedWindowsFSOps
    extends AdvancedFSOps {
        public AdvancedWindowsFSOps(Map<String, Object> conf) {
            super(conf);
            if (ObjectReader.getBoolean(conf.get("supervisor.run.worker.as.user"), false)) {
                throw new RuntimeException("ERROR: Windows doesn't support running workers as different users yet");
            }
        }

        @Override
        public void restrictDirectoryPermissions(File dir) throws IOException {
        }

        @Override
        public void moveDirectoryPreferAtomic(File fromDir, File toDir) throws IOException {
            FileUtils.moveDirectory((File)fromDir, (File)toDir);
        }

        @Override
        public boolean supportsAtomicDirectoryMove() {
            return false;
        }
    }

    private static class AdvancedRunAsUserFSOps
    extends AdvancedFSOps {
        private final Map<String, Object> _conf;

        public AdvancedRunAsUserFSOps(Map<String, Object> conf) {
            super(conf);
            if (Utils.isOnWindows()) {
                throw new UnsupportedOperationException("ERROR: Windows doesn't support running workers as different users yet");
            }
            this._conf = conf;
        }

        @Override
        public void setupBlobPermissions(File path, String user) throws IOException {
            String logPrefix = "setup blob permissions for " + path;
            ClientSupervisorUtils.processLauncherAndWait(this._conf, user, Arrays.asList("blob", path.toString()), null, logPrefix);
        }

        @Override
        public void deleteIfExists(File path, String user, String logPrefix) throws IOException {
            String absolutePath = path.getAbsolutePath();
            LOG.info("Deleting path {}", (Object)absolutePath);
            if (user == null) {
                user = Files.getOwner(path.toPath(), new LinkOption[0]).getName();
            }
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("rmr");
            commands.add(absolutePath);
            ClientSupervisorUtils.processLauncherAndWait(this._conf, user, commands, null, logPrefix);
            if (Utils.checkFileExists(absolutePath)) {
                Utils.forceDelete(absolutePath);
                if (Utils.checkFileExists(absolutePath)) {
                    throw new RuntimeException(path + " was not deleted.");
                }
            }
        }

        @Override
        public void setupStormCodeDir(Map<String, Object> topologyConf, File path) throws IOException {
            ClientSupervisorUtils.setupStormCodeDir(this._conf, topologyConf, path.getCanonicalPath());
        }

        @Override
        public void setupWorkerArtifactsDir(Map<String, Object> topologyConf, File path) throws IOException {
            ClientSupervisorUtils.setupWorkerArtifactsDir(this._conf, topologyConf, path.getCanonicalPath());
        }
    }
}

