/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.grouping;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.grouping.LoadAwareCustomStreamGrouping;
import org.apache.storm.grouping.LoadMapping;
import org.apache.storm.task.WorkerTopologyContext;

public class LoadAwareShuffleGrouping
implements LoadAwareCustomStreamGrouping,
Serializable {
    private Random random;
    private List<Integer>[] rets;
    private int[] targets;
    private int[] loads;
    private int total;
    private long lastUpdate = 0L;

    @Override
    public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
        this.random = new Random();
        this.rets = new List[targetTasks.size()];
        this.targets = new int[targetTasks.size()];
        for (int i = 0; i < this.targets.length; ++i) {
            this.rets[i] = Arrays.asList(targetTasks.get(i));
            this.targets[i] = targetTasks.get(i);
        }
        this.loads = new int[this.targets.length];
    }

    @Override
    public List<Integer> chooseTasks(int taskId, List<Object> values) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public List<Integer> chooseTasks(int taskId, List<Object> values, LoadMapping load) {
        if (this.lastUpdate + 1000L < System.currentTimeMillis()) {
            int local_total = 0;
            for (int i = 0; i < this.targets.length; ++i) {
                int val;
                this.loads[i] = val = (int)(101.0 - load.get(this.targets[i]) * 100.0);
                local_total += val;
            }
            this.total = local_total;
            this.lastUpdate = System.currentTimeMillis();
        }
        int selected = this.random.nextInt(this.total);
        int sum = 0;
        for (int i = 0; i < this.targets.length; ++i) {
            if (selected >= (sum += this.loads[i])) continue;
            return this.rets[i];
        }
        return this.rets[this.rets.length - 1];
    }
}

