/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import org.apache.storm.messaging.netty.INettySerializable;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;

public enum ControlMessage implements INettySerializable
{
    CLOSE_MESSAGE(-100),
    EOB_MESSAGE(-201),
    OK_RESPONSE(-200),
    FAILURE_RESPONSE(-400),
    SASL_TOKEN_MESSAGE_REQUEST(-202),
    SASL_COMPLETE_REQUEST(-203);

    private short code;

    private ControlMessage(short code) {
        this.code = code;
    }

    public static ControlMessage mkMessage(short encoded) {
        for (ControlMessage cm : ControlMessage.values()) {
            if (encoded != cm.code) continue;
            return cm;
        }
        return null;
    }

    @Override
    public int encodeLength() {
        return 2;
    }

    @Override
    public ChannelBuffer buffer() throws IOException {
        ChannelBufferOutputStream bout = new ChannelBufferOutputStream(ChannelBuffers.directBuffer((int)this.encodeLength()));
        this.write(bout);
        bout.close();
        return bout.buffer();
    }

    public static ControlMessage read(byte[] serial) {
        ChannelBuffer cm_buffer = ChannelBuffers.copiedBuffer((byte[])serial);
        return ControlMessage.mkMessage(cm_buffer.getShort(0));
    }

    public void write(ChannelBufferOutputStream bout) throws IOException {
        bout.writeShort((int)this.code);
    }
}

