/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import java.util.Map;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.ISaslClient;
import org.apache.storm.messaging.netty.KerberosSaslNettyClient;
import org.apache.storm.messaging.netty.KerberosSaslNettyClientState;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosSaslClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosSaslClientHandler.class);
    private ISaslClient client;
    long start_time;
    private Map<String, Object> topoConf;
    private String jaas_section;
    private String host;

    public KerberosSaslClientHandler(ISaslClient client, Map<String, Object> topoConf, String jaas_section, String host) throws IOException {
        this.client = client;
        this.topoConf = topoConf;
        this.jaas_section = jaas_section;
        this.host = host;
        this.start_time = System.currentTimeMillis();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent event) {
        Channel channel = ctx.getChannel();
        this.client.channelConnected(channel);
        LOG.info("Connection established from {} to {}", (Object)channel.getLocalAddress(), (Object)channel.getRemoteAddress());
        try {
            KerberosSaslNettyClient saslNettyClient = (KerberosSaslNettyClient)KerberosSaslNettyClientState.getKerberosSaslNettyClient.get(channel);
            if (saslNettyClient == null) {
                LOG.debug("Creating saslNettyClient now for channel: {}", (Object)channel);
                saslNettyClient = new KerberosSaslNettyClient(this.topoConf, this.jaas_section, this.host);
                KerberosSaslNettyClientState.getKerberosSaslNettyClient.set(channel, (Object)saslNettyClient);
            }
            LOG.debug("Going to initiate Kerberos negotiations.");
            byte[] initialChallenge = saslNettyClient.saslResponse(new SaslMessageToken(new byte[0]));
            LOG.debug("Sending initial challenge: {}", (Object)initialChallenge);
            channel.write((Object)new SaslMessageToken(initialChallenge));
        }
        catch (Exception e) {
            LOG.error("Failed to authenticate with server due to error: ", (Throwable)e);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        LOG.debug("send/recv time (ms): {}", (Object)(System.currentTimeMillis() - this.start_time));
        Channel channel = ctx.getChannel();
        KerberosSaslNettyClient saslNettyClient = (KerberosSaslNettyClient)KerberosSaslNettyClientState.getKerberosSaslNettyClient.get(channel);
        if (saslNettyClient == null) {
            throw new Exception("saslNettyClient was unexpectedly null for channel:" + channel);
        }
        if (event.getMessage() instanceof ControlMessage) {
            ControlMessage msg = (ControlMessage)event.getMessage();
            if (msg == ControlMessage.SASL_COMPLETE_REQUEST) {
                LOG.debug("Server has sent us the SaslComplete message. Allowing normal work to proceed.");
                if (!saslNettyClient.isComplete()) {
                    String message = "Server returned a Sasl-complete message, but as far as we can tell, we are not authenticated yet.";
                    LOG.error(message);
                    throw new Exception(message);
                }
                ctx.getPipeline().remove((ChannelHandler)this);
                this.client.channelReady();
                Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)msg);
            } else {
                LOG.warn("Unexpected control message: {}", (Object)msg);
            }
            return;
        }
        if (event.getMessage() instanceof SaslMessageToken) {
            SaslMessageToken saslTokenMessage = (SaslMessageToken)event.getMessage();
            LOG.debug("Responding to server's token of length: {}", (Object)saslTokenMessage.getSaslToken().length);
            byte[] responseToServer = saslNettyClient.saslResponse(saslTokenMessage);
            if (responseToServer == null) {
                LOG.debug("Response to server is null: authentication should now be complete.");
                if (!saslNettyClient.isComplete()) {
                    LOG.warn("Generated a null response, but authentication is not complete.");
                    throw new Exception("Our reponse to the server is null, but as far as we can tell, we are not authenticated yet.");
                }
                this.client.channelReady();
                return;
            }
            LOG.debug("Response to server token has length: {}", (Object)responseToServer.length);
            SaslMessageToken saslResponse = new SaslMessageToken(responseToServer);
            channel.write((Object)saslResponse);
        } else {
            LOG.error("Unexpected message from server: {}", event.getMessage());
        }
    }
}

