/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.ISaslServer;
import org.apache.storm.messaging.netty.KerberosSaslNettyServer;
import org.apache.storm.messaging.netty.KerberosSaslNettyServerState;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosSaslServerHandler
extends SimpleChannelUpstreamHandler {
    ISaslServer server;
    private Map<String, Object> topoConf;
    private String jaas_section;
    private List<String> authorizedUsers;
    private static final Logger LOG = LoggerFactory.getLogger(KerberosSaslServerHandler.class);

    public KerberosSaslServerHandler(ISaslServer server, Map<String, Object> topoConf, String jaas_section, List<String> authorizedUsers) throws IOException {
        this.server = server;
        this.topoConf = topoConf;
        this.jaas_section = jaas_section;
        this.authorizedUsers = authorizedUsers;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg == null) {
            return;
        }
        Channel channel = ctx.getChannel();
        if (msg instanceof SaslMessageToken) {
            try {
                LOG.debug("Got SaslMessageToken!");
                KerberosSaslNettyServer saslNettyServer = (KerberosSaslNettyServer)KerberosSaslNettyServerState.getKerberosSaslNettyServer.get(channel);
                if (saslNettyServer == null) {
                    LOG.debug("No saslNettyServer for {}  yet; creating now, with topology token: ", (Object)channel);
                    try {
                        saslNettyServer = new KerberosSaslNettyServer(this.topoConf, this.jaas_section, this.authorizedUsers);
                        KerberosSaslNettyServerState.getKerberosSaslNettyServer.set(channel, (Object)saslNettyServer);
                    }
                    catch (RuntimeException ioe) {
                        LOG.error("Error occurred while creating saslNettyServer on server {} for client {}", (Object)channel.getLocalAddress(), (Object)channel.getRemoteAddress());
                        throw ioe;
                    }
                } else {
                    LOG.debug("Found existing saslNettyServer on server: {} for client {}", (Object)channel.getLocalAddress(), (Object)channel.getRemoteAddress());
                }
                byte[] responseBytes = saslNettyServer.response(((SaslMessageToken)msg).getSaslToken());
                SaslMessageToken saslTokenMessageRequest = new SaslMessageToken(responseBytes);
                if (saslTokenMessageRequest.getSaslToken() == null) {
                    channel.write((Object)ControlMessage.SASL_COMPLETE_REQUEST);
                } else {
                    channel.write((Object)saslTokenMessageRequest);
                }
                if (saslNettyServer.isComplete()) {
                    LOG.info("SASL authentication is complete for client with username: {}", (Object)saslNettyServer.getUserName());
                    channel.write((Object)ControlMessage.SASL_COMPLETE_REQUEST);
                    LOG.debug("Removing SaslServerHandler from pipeline since SASL authentication is complete.");
                    ctx.getPipeline().remove((ChannelHandler)this);
                    this.server.authenticated(channel);
                }
                return;
            }
            catch (Exception ex) {
                LOG.error("Failed to handle SaslMessageToken: ", (Throwable)ex);
                throw ex;
            }
        }
        LOG.warn("Sending upstream an unexpected non-SASL message : {}", msg);
        Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        if (this.server != null) {
            this.server.closeChannel(e.getChannel());
        }
    }
}

