/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.ArrayList;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class MessageDecoder
extends FrameDecoder {
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buf) throws Exception {
        long available = buf.readableBytes();
        if (available < 2L) {
            return null;
        }
        ArrayList<TaskMessage> ret = new ArrayList<TaskMessage>();
        while (available >= 2L) {
            ChannelBuffer payload;
            int length;
            buf.markReaderIndex();
            short code = buf.readShort();
            available -= 2L;
            ControlMessage ctrl_msg = ControlMessage.mkMessage(code);
            if (ctrl_msg != null) {
                if (ctrl_msg == ControlMessage.EOB_MESSAGE) continue;
                return ctrl_msg;
            }
            if (code == -500) {
                if (buf.readableBytes() < 4) {
                    buf.resetReaderIndex();
                    return null;
                }
                length = buf.readInt();
                if (length <= 0) {
                    return new SaslMessageToken(null);
                }
                if (buf.readableBytes() < length) {
                    buf.resetReaderIndex();
                    return null;
                }
                payload = buf.readBytes(length);
                return new SaslMessageToken(payload.array());
            }
            if (available < 4L) {
                buf.resetReaderIndex();
                break;
            }
            length = buf.readInt();
            available -= 4L;
            if (length <= 0) {
                ret.add(new TaskMessage(code, null));
                break;
            }
            if (available < (long)length) {
                buf.resetReaderIndex();
                break;
            }
            available -= (long)length;
            payload = buf.readBytes(length);
            ret.add(new TaskMessage(code, payload.array()));
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }
}

