/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.Map;
import org.apache.storm.messaging.netty.Client;
import org.apache.storm.messaging.netty.MessageDecoder;
import org.apache.storm.messaging.netty.MessageEncoder;
import org.apache.storm.messaging.netty.SaslStormClientHandler;
import org.apache.storm.messaging.netty.StormClientHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;

class StormClientPipelineFactory
implements ChannelPipelineFactory {
    private Client client;
    private Map<String, Object> conf;

    StormClientPipelineFactory(Client client, Map<String, Object> conf) {
        this.client = client;
        this.conf = conf;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new MessageDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new MessageEncoder());
        boolean isNettyAuth = (Boolean)this.conf.get("storm.messaging.netty.authentication");
        if (isNettyAuth) {
            pipeline.addLast("saslClientHandler", (ChannelHandler)new SaslStormClientHandler(this.client));
        }
        pipeline.addLast("handler", (ChannelHandler)new StormClientHandler(this.client, this.conf));
        return pipeline;
    }
}

