/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.messaging.netty.IServer;
import org.apache.storm.utils.Utils;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormServerHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StormServerHandler.class);
    IServer server;
    private AtomicInteger failure_count;
    private Channel channel;

    public StormServerHandler(IServer server) {
        this.server = server;
        this.failure_count = new AtomicInteger(0);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.server.channelConnected(e.getChannel());
        if (this.channel != null) {
            LOG.debug("Replacing channel with new channel: {} -> ", (Object)this.channel, (Object)e.getChannel());
        }
        this.channel = e.getChannel();
        this.server.channelConnected(this.channel);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object msgs = e.getMessage();
        if (msgs == null) {
            return;
        }
        try {
            this.server.received(msgs, e.getRemoteAddress().toString(), this.channel);
        }
        catch (InterruptedException e1) {
            LOG.info("failed to enqueue a request message", (Object)e);
            this.failure_count.incrementAndGet();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        LOG.error("server errors in handling the request", e.getCause());
        Utils.handleUncaughtException(e.getCause());
        this.server.closeChannel(e.getChannel());
    }
}

