/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import org.apache.storm.messaging.netty.MessageDecoder;
import org.apache.storm.messaging.netty.MessageEncoder;
import org.apache.storm.messaging.netty.SaslStormServerAuthorizeHandler;
import org.apache.storm.messaging.netty.SaslStormServerHandler;
import org.apache.storm.messaging.netty.Server;
import org.apache.storm.messaging.netty.StormServerHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;

class StormServerPipelineFactory
implements ChannelPipelineFactory {
    private Server server;

    StormServerPipelineFactory(Server server) {
        this.server = server;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new MessageDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new MessageEncoder());
        boolean isNettyAuth = (Boolean)this.server.topoConf.get("storm.messaging.netty.authentication");
        if (isNettyAuth) {
            pipeline.addLast("saslServerHandler", (ChannelHandler)new SaslStormServerHandler(this.server));
            pipeline.addLast("authorizeServerHandler", (ChannelHandler)new SaslStormServerAuthorizeHandler());
        }
        pipeline.addLast("handler", (ChannelHandler)new StormServerHandler(this.server));
        return pipeline;
    }
}

