/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import java.util.Map;
import org.apache.storm.metric.FileBasedEventLogger;
import org.apache.storm.metric.IEventLogger;
import org.apache.storm.task.IBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLoggerBolt
implements IBolt {
    private static final Logger LOG = LoggerFactory.getLogger(EventLoggerBolt.class);
    public static final String FIELD_TS = "ts";
    public static final String FIELD_VALUES = "values";
    public static final String FIELD_COMPONENT_ID = "component-id";
    public static final String FIELD_MESSAGE_ID = "message-id";
    private IEventLogger eventLogger;

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        LOG.info("EventLoggerBolt prepare called");
        this.eventLogger = new FileBasedEventLogger();
        this.eventLogger.prepare(topoConf, context);
    }

    @Override
    public void execute(Tuple input) {
        LOG.debug("** EventLoggerBolt got tuple from sourceComponent {}, with values {}", (Object)input.getSourceComponent(), input.getValues());
        Object msgId = input.getValueByField(FIELD_MESSAGE_ID);
        IEventLogger.EventInfo eventInfo = new IEventLogger.EventInfo(input.getValueByField(FIELD_TS).toString(), input.getSourceComponent(), String.valueOf(input.getSourceTask()), msgId == null ? "" : msgId.toString(), input.getValueByField(FIELD_VALUES).toString());
        this.eventLogger.log(eventInfo);
    }

    @Override
    public void cleanup() {
        this.eventLogger.close();
    }
}

