/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.cgroup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Map;
import org.apache.storm.container.cgroup.CgroupCenter;
import org.apache.storm.container.cgroup.CgroupCoreFactory;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.CgroupCore;
import org.apache.storm.metric.api.IMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CGroupMetricsBase<T>
implements IMetric {
    private static final Logger LOG = LoggerFactory.getLogger(CGroupMetricsBase.class);
    private boolean enabled;
    private CgroupCore core = null;

    public CGroupMetricsBase(Map<String, Object> conf, SubSystemType type) {
        String simpleName = this.getClass().getSimpleName();
        this.enabled = false;
        CgroupCenter center = CgroupCenter.getInstance();
        if (center == null) {
            LOG.warn("{} is diabled. cgroups do not appear to be enabled on this system", (Object)simpleName);
            return;
        }
        if (!center.isSubSystemEnabled(type)) {
            LOG.warn("{} is disabled. {} is not an enabled subsystem", (Object)simpleName, (Object)type);
            return;
        }
        if (null == center.getHierarchyWithSubSystem(type)) {
            LOG.warn("{} is disabled. {} is not a mounted subsystem", (Object)simpleName, (Object)type);
            return;
        }
        String hierarchyDir = (String)conf.get("storm.cgroup.hierarchy.dir");
        if (hierarchyDir == null || hierarchyDir.isEmpty()) {
            LOG.warn("{} is disabled {} is not set", (Object)simpleName, (Object)"storm.cgroup.hierarchy.dir");
            return;
        }
        if (!new File(hierarchyDir).exists()) {
            LOG.warn("{} is disabled {} does not exist", (Object)simpleName, (Object)hierarchyDir);
            return;
        }
        File cgroupFile = new File("/proc/self/cgroup");
        if (!cgroupFile.exists()) {
            LOG.warn("{} is disabled we do not appear to be a part of a CGroup", (Object)this.getClass().getSimpleName());
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(cgroupFile));){
            String line = reader.readLine();
            String[] parts = line.split(":");
            String cgroupPath = parts[2];
            this.core = CgroupCoreFactory.getInstance(type, new File(hierarchyDir, cgroupPath).getAbsolutePath());
        }
        catch (Exception e) {
            LOG.warn("{} is disabled error trying to read or parse {}", (Object)simpleName, (Object)cgroupFile);
            return;
        }
        this.enabled = true;
        LOG.info("{} is ENABLED {} exists...", (Object)simpleName);
    }

    @Override
    public Object getValueAndReset() {
        if (!this.enabled) {
            return null;
        }
        try {
            return this.getDataFrom(this.core);
        }
        catch (FileNotFoundException e) {
            LOG.warn("Exception trying to read a file {}", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract T getDataFrom(CgroupCore var1) throws Exception;
}

