/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.internal.MetricStatTimer;

public class CountStatAndMetric
implements IMetric {
    private final AtomicLong _currentBucket;
    private long _bucketStart;
    private long _exactExtra;
    private final int _tmSize;
    private final long[] _tmBuckets;
    private final long[] _tmTime;
    private final int _thSize;
    private final long[] _thBuckets;
    private final long[] _thTime;
    private final int _odSize;
    private final long[] _odBuckets;
    private final long[] _odTime;
    private long _allTime;
    private final TimerTask _task;

    public CountStatAndMetric(int numBuckets) {
        this(numBuckets, -1L);
    }

    CountStatAndMetric(int numBuckets, long startTime) {
        numBuckets = Math.max(numBuckets, 2);
        this._tmSize = 600000 / (numBuckets - 1);
        this._thSize = 10800000 / (numBuckets - 1);
        this._odSize = 86400000 / (numBuckets - 1);
        if (this._tmSize < 1 || this._thSize < 1 || this._odSize < 1) {
            throw new IllegalArgumentException("number of buckets is too large to be supported");
        }
        this._tmBuckets = new long[numBuckets];
        this._tmTime = new long[numBuckets];
        this._thBuckets = new long[numBuckets];
        this._thTime = new long[numBuckets];
        this._odBuckets = new long[numBuckets];
        this._odTime = new long[numBuckets];
        this._allTime = 0L;
        this._exactExtra = 0L;
        this._bucketStart = startTime >= 0L ? startTime : System.currentTimeMillis();
        this._currentBucket = new AtomicLong(0L);
        if (startTime < 0L) {
            this._task = new Fresher();
            MetricStatTimer._timer.scheduleAtFixedRate(this._task, this._tmSize, (long)this._tmSize);
        } else {
            this._task = null;
        }
    }

    public void incBy(long count) {
        this._currentBucket.addAndGet(count);
    }

    @Override
    public synchronized Object getValueAndReset() {
        return this.getValueAndReset(System.currentTimeMillis());
    }

    synchronized Object getValueAndReset(long now) {
        long value = this._currentBucket.getAndSet(0L);
        long timeSpent = now - this._bucketStart;
        long ret = value + this._exactExtra;
        this._bucketStart = now;
        this._exactExtra = 0L;
        this.rotateBuckets(value, timeSpent);
        return ret;
    }

    synchronized void rotateSched(long now) {
        long value = this._currentBucket.getAndSet(0L);
        long timeSpent = now - this._bucketStart;
        this._exactExtra += value;
        this._bucketStart = now;
        this.rotateBuckets(value, timeSpent);
    }

    synchronized void rotateBuckets(long value, long timeSpent) {
        this.rotate(value, timeSpent, this._tmSize, this._tmTime, this._tmBuckets);
        this.rotate(value, timeSpent, this._thSize, this._thTime, this._thBuckets);
        this.rotate(value, timeSpent, this._odSize, this._odTime, this._odBuckets);
        this._allTime += value;
    }

    private synchronized void rotate(long value, long timeSpent, long targetSize, long[] times, long[] buckets) {
        times[0] = times[0] + timeSpent;
        buckets[0] = buckets[0] + value;
        long currentTime = 0L;
        long currentVal = 0L;
        if (times[0] >= targetSize) {
            for (int i = 0; i < buckets.length; ++i) {
                long tmpTime = times[i];
                times[i] = currentTime;
                currentTime = tmpTime;
                long cnt = buckets[i];
                buckets[i] = currentVal;
                currentVal = cnt;
            }
        }
    }

    public synchronized Map<String, Long> getTimeCounts() {
        return this.getTimeCounts(System.currentTimeMillis());
    }

    synchronized Map<String, Long> getTimeCounts(long now) {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        long value = this._currentBucket.get();
        long timeSpent = now - this._bucketStart;
        ret.put("600", this.readApproximateTime(value, timeSpent, this._tmTime, this._tmBuckets, 600000L));
        ret.put("10800", this.readApproximateTime(value, timeSpent, this._thTime, this._thBuckets, 10800000L));
        ret.put("86400", this.readApproximateTime(value, timeSpent, this._odTime, this._odBuckets, 86400000L));
        ret.put(":all-time", value + this._allTime);
        return ret;
    }

    long readApproximateTime(long value, long timeSpent, long[] bucketTime, long[] buckets, long desiredTime) {
        long timeNeeded = desiredTime - timeSpent;
        long total = value;
        for (int i = 0; i < bucketTime.length; ++i) {
            if (timeNeeded < bucketTime[i]) {
                double pct = (double)timeNeeded / (double)bucketTime[i];
                total += (long)(pct * (double)buckets[i]);
                timeNeeded = 0L;
                break;
            }
            total += buckets[i];
            timeNeeded -= bucketTime[i];
        }
        return total;
    }

    public void close() {
        if (this._task != null) {
            this._task.cancel();
        }
    }

    private class Fresher
    extends TimerTask {
        private Fresher() {
        }

        @Override
        public void run() {
            CountStatAndMetric.this.rotateSched(System.currentTimeMillis());
        }
    }
}

