/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.internal.CountStatAndMetric;

public class MultiCountStatAndMetric<T>
implements IMetric {
    private ConcurrentHashMap<T, CountStatAndMetric> _counts = new ConcurrentHashMap();
    private final int _numBuckets;

    public MultiCountStatAndMetric(int numBuckets) {
        this._numBuckets = numBuckets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CountStatAndMetric get(T key) {
        CountStatAndMetric c = this._counts.get(key);
        if (c == null) {
            MultiCountStatAndMetric multiCountStatAndMetric = this;
            synchronized (multiCountStatAndMetric) {
                c = this._counts.get(key);
                if (c == null) {
                    c = new CountStatAndMetric(this._numBuckets);
                    this._counts.put(key, c);
                }
            }
        }
        return c;
    }

    public void incBy(T key, long count) {
        this.get(key).incBy(count);
    }

    protected String keyToString(T key) {
        if (key instanceof List) {
            List lk = (List)key;
            return (String)lk.get(0) + ":" + (String)lk.get(1);
        }
        return key.toString();
    }

    @Override
    public Object getValueAndReset() {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        for (Map.Entry<T, CountStatAndMetric> entry : this._counts.entrySet()) {
            String key = this.keyToString(entry.getKey());
            Long val = (Long)entry.getValue().getValueAndReset();
            Long other = (Long)ret.get(key);
            val = val + (other == null ? 0L : other);
            ret.put(key, val);
        }
        return ret;
    }

    public Map<String, Map<T, Long>> getTimeCounts() {
        HashMap<String, Map<T, Long>> ret = new HashMap<String, Map<T, Long>>();
        for (Map.Entry<T, CountStatAndMetric> entry : this._counts.entrySet()) {
            T key = entry.getKey();
            Map<String, Long> toFlip = entry.getValue().getTimeCounts();
            for (Map.Entry<String, Long> subEntry : toFlip.entrySet()) {
                String time = subEntry.getKey();
                HashMap<T, Long> tmp = (HashMap<T, Long>)ret.get(time);
                if (tmp == null) {
                    tmp = new HashMap<T, Long>();
                    ret.put(time, tmp);
                }
                tmp.put(key, subEntry.getValue());
            }
        }
        return ret;
    }

    public void close() {
        for (CountStatAndMetric cc : this._counts.values()) {
            cc.close();
        }
    }
}

