/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker;

import java.net.ConnectException;
import org.apache.storm.generated.HBMessage;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.pacemaker.PacemakerClient;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacemakerClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PacemakerClientHandler.class);
    private PacemakerClient client;

    public PacemakerClientHandler(PacemakerClient client) {
        this.client = client;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent event) {
        Channel channel = ctx.getChannel();
        this.client.channelConnected(channel);
        LOG.info("Connection established from {} to {}", (Object)channel.getLocalAddress(), (Object)channel.getRemoteAddress());
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        LOG.debug("Got Message: {}", (Object)event.getMessage().toString());
        Object evm = event.getMessage();
        if (evm instanceof ControlMessage) {
            LOG.debug("Got control message: {}", (Object)evm.toString());
            return;
        }
        if (evm instanceof HBMessage) {
            this.client.gotMessage((HBMessage)evm);
        } else {
            LOG.warn("Got unexpected message: {} from server.", evm);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable t = event.getCause();
        if (t instanceof ConnectException) {
            LOG.warn("Connection to pacemaker failed. Trying to reconnect {}", (Object)t.getMessage());
        } else {
            LOG.error("Exception occurred in Pacemaker.", t);
        }
        this.client.reconnect();
    }
}

