/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.storm.generated.HBMessage;
import org.apache.storm.pacemaker.PacemakerClient;
import org.apache.storm.pacemaker.PacemakerConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacemakerClientPool {
    private static final Logger LOG = LoggerFactory.getLogger(PacemakerClientPool.class);
    private ConcurrentHashMap<String, PacemakerClient> clientForServer = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<String> servers;
    private Map<String, Object> config;

    public PacemakerClientPool(Map<String, Object> config) {
        this.config = config;
        ArrayList serverList = (ArrayList)config.get("pacemaker.servers");
        serverList = serverList == null ? new ArrayList() : new ArrayList(serverList);
        Collections.shuffle(serverList);
        this.servers = serverList != null ? new ConcurrentLinkedQueue(serverList) : new ConcurrentLinkedQueue();
    }

    public HBMessage send(HBMessage m) throws PacemakerConnectionException {
        try {
            return this.getWriteClient().send(m);
        }
        catch (Exception e) {
            this.rotateClients();
            throw e;
        }
    }

    public List<HBMessage> sendAll(HBMessage m) throws PacemakerConnectionException {
        ArrayList<HBMessage> responses = new ArrayList<HBMessage>();
        LOG.debug("Using servers: {}", this.servers);
        for (String s : this.servers) {
            try {
                HBMessage response = this.getClientForServer(s).send(m);
                responses.add(response);
            }
            catch (PacemakerConnectionException e) {
                LOG.error("Failed to send message to Pacemaker " + s + " " + e.getMessage());
            }
        }
        if (responses.size() == 0) {
            throw new PacemakerConnectionException("Failed to connect to any Pacemaker.");
        }
        return responses;
    }

    public void close() {
        for (PacemakerClient client : this.clientForServer.values()) {
            client.shutdown();
            client.close();
        }
    }

    private void rotateClients() {
        PacemakerClient c = this.getWriteClient();
        String server = this.servers.peek();
        this.servers.add((String)this.servers.remove());
        this.clientForServer.remove(server);
        c.shutdown();
        c.close();
    }

    private PacemakerClient getWriteClient() {
        return this.getClientForServer(this.servers.peek());
    }

    private PacemakerClient getClientForServer(String server) {
        PacemakerClient client = this.clientForServer.get(server);
        if (client == null) {
            client = new PacemakerClient(this.config, server);
            this.clientForServer.put(server, client);
        }
        return client;
    }
}

