/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker.codec;

import java.io.IOException;
import org.apache.storm.generated.HBMessage;
import org.apache.storm.generated.HBMessageData;
import org.apache.storm.generated.HBServerMessageType;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.INettySerializable;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.apache.storm.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftEncoder
extends OneToOneEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftEncoder.class);

    private HBMessage encodeNettySerializable(INettySerializable netty_message, HBServerMessageType mType) {
        HBMessageData message_data = new HBMessageData();
        HBMessage m = new HBMessage();
        try {
            ChannelBuffer cbuffer = netty_message.buffer();
            if (cbuffer.hasArray()) {
                message_data.set_message_blob(cbuffer.array());
            } else {
                byte[] buff = new byte[netty_message.encodeLength()];
                cbuffer.readBytes(buff, 0, netty_message.encodeLength());
                message_data.set_message_blob(buff);
            }
            m.set_type(mType);
            m.set_data(message_data);
            return m;
        }
        catch (IOException e) {
            LOG.error("Failed to encode NettySerializable: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) {
        HBMessage m;
        if (msg == null) {
            return null;
        }
        LOG.debug("Trying to encode: " + msg.getClass().toString() + " : " + msg.toString());
        if (msg instanceof INettySerializable) {
            HBServerMessageType type;
            INettySerializable nettyMsg = (INettySerializable)msg;
            if (msg instanceof ControlMessage) {
                type = HBServerMessageType.CONTROL_MESSAGE;
            } else if (msg instanceof SaslMessageToken) {
                type = HBServerMessageType.SASL_MESSAGE_TOKEN;
            } else {
                LOG.error("Didn't recognise INettySerializable: " + nettyMsg.toString());
                throw new RuntimeException("Unrecognized INettySerializable.");
            }
            m = this.encodeNettySerializable(nettyMsg, type);
        } else {
            m = (HBMessage)msg;
        }
        try {
            byte[] serialized = Utils.thriftSerialize(m);
            ChannelBuffer ret = ChannelBuffers.directBuffer((int)(serialized.length + 4));
            ret.writeInt(serialized.length);
            ret.writeBytes(serialized);
            return ret;
        }
        catch (RuntimeException e) {
            LOG.error("Failed to serialize.", (Throwable)e);
            throw e;
        }
    }
}

