/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker.codec;

import java.io.IOException;
import java.util.Map;
import org.apache.storm.messaging.netty.KerberosSaslClientHandler;
import org.apache.storm.messaging.netty.SaslStormClientHandler;
import org.apache.storm.pacemaker.PacemakerClient;
import org.apache.storm.pacemaker.PacemakerClientHandler;
import org.apache.storm.pacemaker.codec.ThriftDecoder;
import org.apache.storm.pacemaker.codec.ThriftEncoder;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftNettyClientCodec {
    public static final String SASL_HANDLER = "sasl-handler";
    public static final String KERBEROS_HANDLER = "kerberos-handler";
    private static final Logger LOG = LoggerFactory.getLogger(ThriftNettyClientCodec.class);
    private PacemakerClient client;
    private AuthMethod authMethod;
    private Map<String, Object> topoConf;
    private String host;

    public ThriftNettyClientCodec(PacemakerClient pacemaker_client, Map<String, Object> topoConf, AuthMethod authMethod, String host) {
        this.client = pacemaker_client;
        this.authMethod = authMethod;
        this.topoConf = topoConf;
        this.host = host;
    }

    public ChannelPipelineFactory pipelineFactory() {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("encoder", (ChannelHandler)new ThriftEncoder());
                pipeline.addLast("decoder", (ChannelHandler)new ThriftDecoder());
                if (ThriftNettyClientCodec.this.authMethod == AuthMethod.KERBEROS) {
                    try {
                        LOG.debug("Adding KerberosSaslClientHandler to pacemaker client pipeline.");
                        pipeline.addLast(ThriftNettyClientCodec.KERBEROS_HANDLER, (ChannelHandler)new KerberosSaslClientHandler(ThriftNettyClientCodec.this.client, ThriftNettyClientCodec.this.topoConf, "PacemakerClient", ThriftNettyClientCodec.this.host));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else if (ThriftNettyClientCodec.this.authMethod == AuthMethod.DIGEST) {
                    try {
                        LOG.debug("Adding SaslStormClientHandler to pacemaker client pipeline.");
                        pipeline.addLast(ThriftNettyClientCodec.SASL_HANDLER, (ChannelHandler)new SaslStormClientHandler(ThriftNettyClientCodec.this.client));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    ThriftNettyClientCodec.this.client.channelReady();
                }
                pipeline.addLast("PacemakerClientHandler", (ChannelHandler)new PacemakerClientHandler(ThriftNettyClientCodec.this.client));
                return pipeline;
            }
        };
    }

    public static enum AuthMethod {
        DIGEST,
        KERBEROS,
        NONE;

    }
}

