/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.networktopography.DNSToSwitchMapping;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.INimbus;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.SchedulerAssignmentImpl;
import org.apache.storm.scheduler.SupervisorDetails;
import org.apache.storm.scheduler.Topologies;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.Utils;

public class Cluster {
    private Map<String, SupervisorDetails> supervisors;
    private Map<String, Double[]> supervisorsResources;
    private Map<String, Map<WorkerSlot, Double[]>> workerResources;
    private Map<String, List<String>> networkTopography;
    private Map<String, SchedulerAssignmentImpl> assignments;
    private Map<String, String> status;
    private Map<String, Double[]> topologyResources;
    private Map<String, List<String>> hostToId;
    private Map<String, Object> conf = null;
    private Set<String> blackListedHosts = new HashSet<String>();
    private INimbus inimbus;
    private static final Double PER_WORKER_CPU_SWAG = 100.0;

    public Cluster(INimbus nimbus, Map<String, SupervisorDetails> supervisors, Map<String, SchedulerAssignmentImpl> assignments, Map<String, Object> topoConf) {
        this.inimbus = nimbus;
        this.supervisors = new HashMap<String, SupervisorDetails>(supervisors.size());
        this.supervisors.putAll(supervisors);
        this.assignments = new HashMap<String, SchedulerAssignmentImpl>(assignments.size());
        this.assignments.putAll(assignments);
        this.status = new HashMap<String, String>();
        this.topologyResources = new HashMap<String, Double[]>();
        this.supervisorsResources = new HashMap<String, Double[]>();
        this.workerResources = new HashMap<String, Map<WorkerSlot, Double[]>>();
        this.hostToId = new HashMap<String, List<String>>();
        for (Map.Entry<String, SupervisorDetails> entry : supervisors.entrySet()) {
            String nodeId = entry.getKey();
            SupervisorDetails supervisor = entry.getValue();
            String host = supervisor.getHost();
            if (!this.hostToId.containsKey(host)) {
                this.hostToId.put(host, new ArrayList());
            }
            this.hostToId.get(host).add(nodeId);
        }
        this.conf = topoConf;
    }

    public Cluster(Cluster src) {
        this(src.inimbus, src.supervisors, new HashMap<String, SchedulerAssignmentImpl>(), new HashMap<String, Object>(src.conf));
        this.supervisorsResources.putAll(src.supervisorsResources);
        for (Map.Entry<String, SchedulerAssignmentImpl> entry : src.assignments.entrySet()) {
            this.assignments.put(entry.getKey(), new SchedulerAssignmentImpl(entry.getValue().getTopologyId(), entry.getValue().getExecutorToSlot()));
        }
        this.status.putAll(src.status);
        this.topologyResources.putAll(src.topologyResources);
        this.blackListedHosts.addAll(src.blackListedHosts);
        if (src.networkTopography != null) {
            this.networkTopography = new HashMap<String, List<String>>(src.networkTopography);
        }
    }

    public void setBlacklistedHosts(Set<String> hosts) {
        this.blackListedHosts = hosts;
    }

    public Set<String> getBlacklistedHosts() {
        return this.blackListedHosts;
    }

    public void blacklistHost(String host) {
        if (this.blackListedHosts == null) {
            this.blackListedHosts = new HashSet<String>();
        }
        if (!(this.blackListedHosts instanceof HashSet)) {
            this.blackListedHosts = new HashSet<String>(this.blackListedHosts);
        }
        this.blackListedHosts.add(host);
    }

    public boolean isBlackListed(String supervisorId) {
        return this.blackListedHosts != null && this.blackListedHosts.contains(this.getHost(supervisorId));
    }

    public boolean isBlacklistedHost(String host) {
        return this.blackListedHosts != null && this.blackListedHosts.contains(host);
    }

    public String getHost(String supervisorId) {
        return this.inimbus.getHostName(this.supervisors, supervisorId);
    }

    public List<TopologyDetails> needsSchedulingTopologies(Topologies topologies) {
        ArrayList<TopologyDetails> ret = new ArrayList<TopologyDetails>();
        for (TopologyDetails topology : topologies.getTopologies()) {
            if (!this.needsScheduling(topology)) continue;
            ret.add(topology);
        }
        return ret;
    }

    public boolean needsScheduling(TopologyDetails topology) {
        int assignedNumWorkers;
        int desiredNumWorkers = topology.getNumWorkers();
        return desiredNumWorkers > (assignedNumWorkers = this.getAssignedNumWorkers(topology)) || this.getUnassignedExecutors(topology).size() > 0;
    }

    public Map<ExecutorDetails, String> getNeedsSchedulingExecutorToComponents(TopologyDetails topology) {
        HashSet<ExecutorDetails> allExecutors = new HashSet<ExecutorDetails>(topology.getExecutors());
        SchedulerAssignment assignment = this.assignments.get(topology.getId());
        if (assignment != null) {
            Set<ExecutorDetails> assignedExecutors = assignment.getExecutors();
            allExecutors.removeAll(assignedExecutors);
        }
        return topology.selectExecutorToComponent(allExecutors);
    }

    public Map<String, List<ExecutorDetails>> getNeedsSchedulingComponentToExecutors(TopologyDetails topology) {
        Map<ExecutorDetails, String> executorToComponents = this.getNeedsSchedulingExecutorToComponents(topology);
        HashMap<String, List<ExecutorDetails>> componentToExecutors = new HashMap<String, List<ExecutorDetails>>();
        for (Map.Entry<ExecutorDetails, String> entry : executorToComponents.entrySet()) {
            ExecutorDetails executor = entry.getKey();
            String component = entry.getValue();
            if (!componentToExecutors.containsKey(component)) {
                componentToExecutors.put(component, new ArrayList());
            }
            ((List)componentToExecutors.get(component)).add(executor);
        }
        return componentToExecutors;
    }

    public Set<Integer> getUsedPorts(SupervisorDetails supervisor) {
        Map<String, SchedulerAssignment> assignments = this.getAssignments();
        HashSet<Integer> usedPorts = new HashSet<Integer>();
        for (SchedulerAssignment assignment : assignments.values()) {
            for (WorkerSlot slot : assignment.getExecutorToSlot().values()) {
                if (!slot.getNodeId().equals(supervisor.getId())) continue;
                usedPorts.add(slot.getPort());
            }
        }
        return usedPorts;
    }

    public Set<Integer> getAvailablePorts(SupervisorDetails supervisor) {
        Set<Integer> usedPorts = this.getUsedPorts(supervisor);
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.addAll(this.getAssignablePorts(supervisor));
        ret.removeAll(usedPorts);
        return ret;
    }

    public Set<Integer> getAssignablePorts(SupervisorDetails supervisor) {
        if (this.isBlackListed(supervisor.id)) {
            return new HashSet<Integer>();
        }
        return supervisor.allPorts;
    }

    public List<WorkerSlot> getAvailableSlots(SupervisorDetails supervisor) {
        Set<Integer> ports = this.getAvailablePorts(supervisor);
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>(ports.size());
        for (Integer port : ports) {
            slots.add(new WorkerSlot(supervisor.getId(), port));
        }
        return slots;
    }

    public List<WorkerSlot> getAssignableSlots(SupervisorDetails supervisor) {
        Set<Integer> ports = this.getAssignablePorts(supervisor);
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>(ports.size());
        for (Integer port : ports) {
            slots.add(new WorkerSlot(supervisor.getId(), port));
        }
        return slots;
    }

    public Collection<ExecutorDetails> getUnassignedExecutors(TopologyDetails topology) {
        if (topology == null) {
            return new ArrayList<ExecutorDetails>(0);
        }
        HashSet<ExecutorDetails> ret = new HashSet<ExecutorDetails>(topology.getExecutors());
        SchedulerAssignment assignment = this.getAssignmentById(topology.getId());
        if (assignment != null) {
            Set<ExecutorDetails> assignedExecutors = assignment.getExecutors();
            ret.removeAll(assignedExecutors);
        }
        return ret;
    }

    public int getAssignedNumWorkers(TopologyDetails topology) {
        SchedulerAssignment assignment;
        SchedulerAssignment schedulerAssignment = assignment = topology != null ? this.getAssignmentById(topology.getId()) : null;
        if (assignment == null) {
            return 0;
        }
        HashSet<WorkerSlot> slots = new HashSet<WorkerSlot>();
        slots.addAll(assignment.getExecutorToSlot().values());
        return slots.size();
    }

    public void assign(WorkerSlot slot, String topologyId, Collection<ExecutorDetails> executors) {
        if (this.isSlotOccupied(slot)) {
            throw new RuntimeException("slot: [" + slot.getNodeId() + ", " + slot.getPort() + "] is already occupied.");
        }
        SchedulerAssignmentImpl assignment = (SchedulerAssignmentImpl)this.getAssignmentById(topologyId);
        if (assignment == null) {
            assignment = new SchedulerAssignmentImpl(topologyId, new HashMap<ExecutorDetails, WorkerSlot>());
            this.assignments.put(topologyId, assignment);
        } else {
            for (ExecutorDetails executor : executors) {
                if (!assignment.isExecutorAssigned(executor)) continue;
                throw new RuntimeException("Attempting to assign executor: " + executor + " of topology: " + topologyId + " to workerslot: " + slot + ". The executor is already assigned to workerslot: " + assignment.getExecutorToSlot().get(executor) + ". The executor must unassigned before it can be assigned to another slot!");
            }
        }
        assignment.assign(slot, executors);
    }

    public List<WorkerSlot> getAvailableSlots() {
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>();
        for (SupervisorDetails supervisor : this.supervisors.values()) {
            slots.addAll(this.getAvailableSlots(supervisor));
        }
        return slots;
    }

    public List<WorkerSlot> getAssignableSlots() {
        ArrayList<WorkerSlot> slots = new ArrayList<WorkerSlot>();
        for (SupervisorDetails supervisor : this.supervisors.values()) {
            slots.addAll(this.getAssignableSlots(supervisor));
        }
        return slots;
    }

    public void freeSlot(WorkerSlot slot) {
        for (SchedulerAssignmentImpl assignment : this.assignments.values()) {
            if (!assignment.isSlotOccupied(slot)) continue;
            assignment.unassignBySlot(slot);
        }
    }

    public void freeSlots(Collection<WorkerSlot> slots) {
        if (slots != null) {
            for (WorkerSlot slot : slots) {
                this.freeSlot(slot);
            }
        }
    }

    public boolean isSlotOccupied(WorkerSlot slot) {
        for (SchedulerAssignment schedulerAssignment : this.assignments.values()) {
            if (!schedulerAssignment.isSlotOccupied(slot)) continue;
            return true;
        }
        return false;
    }

    public SchedulerAssignment getAssignmentById(String topologyId) {
        if (this.assignments.containsKey(topologyId)) {
            return this.assignments.get(topologyId);
        }
        return null;
    }

    public Collection<WorkerSlot> getUsedSlotsByTopologyId(String topologyId) {
        if (!this.assignments.containsKey(topologyId)) {
            return null;
        }
        return this.assignments.get(topologyId).getSlots();
    }

    public SupervisorDetails getSupervisorById(String nodeId) {
        if (this.supervisors.containsKey(nodeId)) {
            return this.supervisors.get(nodeId);
        }
        return null;
    }

    public Collection<WorkerSlot> getUsedSlots() {
        HashSet<WorkerSlot> ret = new HashSet<WorkerSlot>();
        for (SchedulerAssignmentImpl s : this.assignments.values()) {
            ret.addAll(s.getExecutorToSlot().values());
        }
        return ret;
    }

    public List<SupervisorDetails> getSupervisorsByHost(String host) {
        List<String> nodeIds = this.hostToId.get(host);
        ArrayList<SupervisorDetails> ret = new ArrayList<SupervisorDetails>();
        if (nodeIds != null) {
            for (String nodeId : nodeIds) {
                ret.add(this.getSupervisorById(nodeId));
            }
        }
        return ret;
    }

    public Map<String, SchedulerAssignment> getAssignments() {
        HashMap<String, SchedulerAssignment> ret = new HashMap<String, SchedulerAssignment>(this.assignments.size());
        for (String topologyId : this.assignments.keySet()) {
            ret.put(topologyId, this.assignments.get(topologyId));
        }
        return ret;
    }

    public void setAssignments(Map<String, SchedulerAssignment> newAssignments) {
        this.assignments = new HashMap<String, SchedulerAssignmentImpl>(newAssignments.size());
        for (Map.Entry<String, SchedulerAssignment> entry : newAssignments.entrySet()) {
            this.assignments.put(entry.getKey(), new SchedulerAssignmentImpl(entry.getValue().getTopologyId(), entry.getValue().getExecutorToSlot()));
        }
    }

    public Map<String, SupervisorDetails> getSupervisors() {
        return this.supervisors;
    }

    public double getClusterTotalCPUResource() {
        double sum = 0.0;
        for (SupervisorDetails sup : this.supervisors.values()) {
            sum += sup.getTotalCPU().doubleValue();
        }
        return sum;
    }

    public double getClusterTotalMemoryResource() {
        double sum = 0.0;
        for (SupervisorDetails sup : this.supervisors.values()) {
            sum += sup.getTotalMemory().doubleValue();
        }
        return sum;
    }

    public Map<String, List<String>> getNetworkTopography() {
        if (this.networkTopography == null) {
            this.networkTopography = new HashMap<String, List<String>>();
            ArrayList<String> supervisorHostNames = new ArrayList<String>();
            for (SupervisorDetails s : this.supervisors.values()) {
                supervisorHostNames.add(s.getHost());
            }
            String clazz = (String)this.conf.get("storm.network.topography.plugin");
            DNSToSwitchMapping topographyMapper = (DNSToSwitchMapping)ReflectionUtils.newInstance(clazz);
            Map<String, String> resolvedSuperVisors = topographyMapper.resolve(supervisorHostNames);
            for (Map.Entry<String, String> entry : resolvedSuperVisors.entrySet()) {
                String hostName = entry.getKey();
                String rack = entry.getValue();
                List<String> nodesForRack = this.networkTopography.get(rack);
                if (nodesForRack == null) {
                    nodesForRack = new ArrayList<String>();
                    this.networkTopography.put(rack, nodesForRack);
                }
                nodesForRack.add(hostName);
            }
        }
        return this.networkTopography;
    }

    public void setNetworkTopography(Map<String, List<String>> networkTopography) {
        this.networkTopography = networkTopography;
    }

    private String getStringFromStringList(Object o) {
        StringBuilder sb = new StringBuilder();
        for (String s : (List)o) {
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString();
    }

    public Double getAssignedMemoryForSlot(Map topConf) {
        Double totalWorkerMemory = 0.0;
        Integer TOPOLOGY_WORKER_DEFAULT_MEMORY_ALLOCATION = 768;
        String topologyWorkerGcChildopts = null;
        topologyWorkerGcChildopts = topConf.get("topology.worker.gc.childopts") instanceof List ? this.getStringFromStringList(topConf.get("topology.worker.gc.childopts")) : ObjectReader.getString(topConf.get("topology.worker.gc.childopts"), null);
        String workerGcChildopts = null;
        workerGcChildopts = topConf.get("worker.gc.childopts") instanceof List ? this.getStringFromStringList(topConf.get("worker.gc.childopts")) : ObjectReader.getString(topConf.get("worker.gc.childopts"), null);
        Double memGcChildopts = null;
        memGcChildopts = Utils.parseJvmHeapMemByChildOpts(topologyWorkerGcChildopts, null);
        if (memGcChildopts == null) {
            memGcChildopts = Utils.parseJvmHeapMemByChildOpts(workerGcChildopts, null);
        }
        String topologyWorkerChildopts = null;
        topologyWorkerChildopts = topConf.get("topology.worker.childopts") instanceof List ? this.getStringFromStringList(topConf.get("topology.worker.childopts")) : ObjectReader.getString(topConf.get("topology.worker.childopts"), null);
        Double memTopologyWorkerChildopts = Utils.parseJvmHeapMemByChildOpts(topologyWorkerChildopts, null);
        String workerChildopts = null;
        workerChildopts = topConf.get("worker.childopts") instanceof List ? this.getStringFromStringList(topConf.get("worker.childopts")) : ObjectReader.getString(topConf.get("worker.childopts"), null);
        Double memWorkerChildopts = Utils.parseJvmHeapMemByChildOpts(workerChildopts, null);
        totalWorkerMemory = memGcChildopts != null ? Double.valueOf(totalWorkerMemory + memGcChildopts) : (memTopologyWorkerChildopts != null ? Double.valueOf(totalWorkerMemory + memTopologyWorkerChildopts) : (memWorkerChildopts != null ? Double.valueOf(totalWorkerMemory + memWorkerChildopts) : Double.valueOf(totalWorkerMemory + (double)ObjectReader.getInt(topConf.get("worker.heap.memory.mb"), TOPOLOGY_WORKER_DEFAULT_MEMORY_ALLOCATION).intValue())));
        String topoWorkerLwChildopts = null;
        topoWorkerLwChildopts = topConf.get("topology.worker.logwriter.childopts") instanceof List ? this.getStringFromStringList(topConf.get("topology.worker.logwriter.childopts")) : ObjectReader.getString(topConf.get("topology.worker.logwriter.childopts"), null);
        if (topoWorkerLwChildopts != null) {
            totalWorkerMemory = totalWorkerMemory + Utils.parseJvmHeapMemByChildOpts(topoWorkerLwChildopts, 0.0);
        }
        return totalWorkerMemory;
    }

    public void updateAssignedMemoryForTopologyAndSupervisor(Topologies topologies) {
        HashMap<String, Double> supervisorToAssignedMem = new HashMap<String, Double>();
        for (Map.Entry<String, SchedulerAssignment> entry : this.getAssignments().entrySet()) {
            Double[] topo_resources;
            Map<Object, Object> workerResources;
            String topId = entry.getValue().getTopologyId();
            if (topologies.getById(topId) == null) continue;
            Map topConf = topologies.getById(topId).getConf();
            Double assignedMemForTopology = 0.0;
            Double assignedMemPerSlot = this.getAssignedMemoryForSlot(topConf);
            if (this.workerResources.containsKey(topId)) {
                workerResources = this.workerResources.get(topId);
            } else {
                workerResources = new HashMap();
                this.workerResources.put(topId, workerResources);
            }
            for (WorkerSlot ws : entry.getValue().getSlots()) {
                Double[] worker_resources;
                assignedMemForTopology = assignedMemForTopology + assignedMemPerSlot;
                String nodeId = ws.getNodeId();
                if (workerResources.containsKey(ws)) {
                    worker_resources = (Double[])workerResources.get(ws);
                    worker_resources[0] = assignedMemPerSlot;
                } else {
                    worker_resources = new Double[]{assignedMemPerSlot, 0.0, 0.0};
                    workerResources.put(ws, worker_resources);
                }
                if (supervisorToAssignedMem.containsKey(nodeId)) {
                    supervisorToAssignedMem.put(nodeId, (Double)supervisorToAssignedMem.get(nodeId) + assignedMemPerSlot);
                    continue;
                }
                supervisorToAssignedMem.put(nodeId, assignedMemPerSlot);
            }
            if (this.topologyResources.containsKey(topId)) {
                topo_resources = this.topologyResources.get(topId);
                topo_resources[3] = assignedMemForTopology;
                continue;
            }
            topo_resources = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            topo_resources[3] = assignedMemForTopology;
            this.setTopologyResources(topId, topo_resources);
        }
        for (Map.Entry<String, SchedulerAssignment> entry : supervisorToAssignedMem.entrySet()) {
            Double[] supervisor_resources;
            String nodeId = entry.getKey();
            if (this.supervisorsResources.containsKey(nodeId)) {
                supervisor_resources = this.supervisorsResources.get(nodeId);
                supervisor_resources[2] = (Double)((Object)entry.getValue());
                continue;
            }
            supervisor_resources = new Double[]{0.0, 0.0, 0.0, 0.0};
            supervisor_resources[2] = (Double)((Object)entry.getValue());
            this.supervisorsResources.put(nodeId, supervisor_resources);
        }
    }

    public void updateAssignedCpuForTopologyAndSupervisor(Topologies topologies) {
        HashMap<String, Double> supervisorToAssignedCpu = new HashMap<String, Double>();
        for (Map.Entry<String, SchedulerAssignment> entry : this.getAssignments().entrySet()) {
            Double[] topo_resources;
            HashMap<WorkerSlot, Double[]> workerResources;
            String topId = entry.getValue().getTopologyId();
            if (topologies.getById(topId) == null) continue;
            Map topConf = topologies.getById(topId).getConf();
            Double assignedCpuForTopology = 0.0;
            if (this.workerResources.containsKey(topId)) {
                workerResources = this.workerResources.get(topId);
            } else {
                workerResources = new HashMap();
                this.workerResources.put(topId, workerResources);
            }
            for (WorkerSlot ws : entry.getValue().getSlots()) {
                Double[] worker_resources;
                assignedCpuForTopology = assignedCpuForTopology + PER_WORKER_CPU_SWAG;
                String nodeId = ws.getNodeId();
                if (workerResources.containsKey(ws)) {
                    worker_resources = (Double[])workerResources.get(ws);
                    worker_resources[2] = PER_WORKER_CPU_SWAG;
                } else {
                    worker_resources = new Double[]{0.0, 0.0, PER_WORKER_CPU_SWAG};
                    workerResources.put(ws, worker_resources);
                }
                if (supervisorToAssignedCpu.containsKey(nodeId)) {
                    supervisorToAssignedCpu.put(nodeId, (Double)supervisorToAssignedCpu.get(nodeId) + PER_WORKER_CPU_SWAG);
                    continue;
                }
                supervisorToAssignedCpu.put(nodeId, PER_WORKER_CPU_SWAG);
            }
            this.setWorkerResources(topId, workerResources);
            if (this.getTopologyResourcesMap().containsKey(topId)) {
                topo_resources = this.getTopologyResourcesMap().get(topId);
                topo_resources[5] = assignedCpuForTopology;
                continue;
            }
            topo_resources = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            topo_resources[5] = assignedCpuForTopology;
            this.setTopologyResources(topId, topo_resources);
        }
        for (Map.Entry<String, SchedulerAssignment> entry : supervisorToAssignedCpu.entrySet()) {
            Double[] supervisor_resources;
            String nodeId = entry.getKey();
            if (this.supervisorsResources.containsKey(nodeId)) {
                supervisor_resources = this.supervisorsResources.get(nodeId);
                supervisor_resources[3] = (Double)((Object)entry.getValue());
                continue;
            }
            supervisor_resources = new Double[]{0.0, 0.0, 0.0, 0.0};
            supervisor_resources[3] = (Double)((Object)entry.getValue());
            this.supervisorsResources.put(nodeId, supervisor_resources);
        }
    }

    public void setStatus(String topologyId, String status) {
        this.status.put(topologyId, status);
    }

    public Map<String, String> getStatusMap() {
        return this.status;
    }

    public void setStatusMap(Map<String, String> statusMap) {
        this.status.clear();
        this.status.putAll(statusMap);
    }

    public void setTopologyResources(String topologyId, Double[] resources) {
        this.topologyResources.put(topologyId, resources);
    }

    public void setTopologyResourcesMap(Map<String, Double[]> topologyResources) {
        this.topologyResources.putAll(topologyResources);
    }

    public Map<String, Double[]> getTopologyResourcesMap() {
        return this.topologyResources;
    }

    public void setSupervisorResources(String supervisorId, Double[] resources) {
        this.supervisorsResources.put(supervisorId, resources);
    }

    public void setSupervisorsResourcesMap(Map<String, Double[]> supervisorResources) {
        this.supervisorsResources.putAll(supervisorResources);
    }

    public Map<String, Double[]> getSupervisorsResourcesMap() {
        return this.supervisorsResources;
    }

    public Map<String, Map<WorkerSlot, Double[]>> getWorkerResourcesMap() {
        return this.workerResources;
    }

    public void setWorkerResourcesMap(Map<String, Map<WorkerSlot, Double[]>> resources) {
        this.workerResources.putAll(resources);
    }

    public void setWorkerResources(String topologyId, Map<WorkerSlot, Double[]> resources) {
        this.workerResources.put(topologyId, resources);
    }

    public INimbus getINimbus() {
        return this.inimbus;
    }

    public Map getConf() {
        return this.conf;
    }
}

